/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.security;

import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.Decrypter;
import org.refcodes.security.DecryptionException;

public class PasswordTextDecrypter
implements Decrypter<String, String, DecryptionException> {
    private static final String CIPHER = "AES/CBC/PKCS5Padding";
    private static final String KEY_FACTORY = "PBKDF2WithHmacSHA256";
    private static final String ALGORITHM = "AES";
    private char[] _password;

    public PasswordTextDecrypter(char[] aPassword) {
        this._password = SystemContext.HOST_USER_APPLICATION_SESSION.toInvertible(aPassword);
        Arrays.fill(aPassword, '\u0000');
    }

    public PasswordTextDecrypter(String aPassword) {
        this(aPassword.toCharArray());
    }

    @Override
    public String toDecrypted(String aInput) throws DecryptionException {
        byte[] theCombined = Base64.getDecoder().decode(aInput);
        byte[] theSalt = new byte[8];
        byte[] iv = new byte[16];
        byte[] theEncrypted = new byte[theCombined.length - theSalt.length - iv.length];
        System.arraycopy(theCombined, 0, theSalt, 0, theSalt.length);
        System.arraycopy(theCombined, theSalt.length, iv, 0, iv.length);
        System.arraycopy(theCombined, theSalt.length + iv.length, theEncrypted, 0, theEncrypted.length);
        PBEKeySpec theSpec = new PBEKeySpec(SystemContext.HOST_USER_APPLICATION_SESSION.toInvertible(this._password), theSalt, 65536, 256);
        SecretKeySpec theSecret = null;
        try {
            SecretKeyFactory theFactory = SecretKeyFactory.getInstance(KEY_FACTORY);
            theSecret = new SecretKeySpec(theFactory.generateSecret(theSpec).getEncoded(), ALGORITHM);
            Cipher theCipher = Cipher.getInstance(CIPHER);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            theCipher.init(2, (Key)theSecret, ivSpec);
            byte[] theDecrypted = theCipher.doFinal(theEncrypted);
            String string = new String(theDecrypted, StandardCharsets.UTF_8);
            return string;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new DecryptionException("Unable to decrypt text as of <" + e.getClass().getName() + ">!", e);
        }
        finally {
            Arrays.fill(theSalt, (byte)0);
            Arrays.fill(theCombined, (byte)0);
            Arrays.fill(iv, (byte)0);
            Arrays.fill(theEncrypted, (byte)0);
            theSpec.clearPassword();
            if (theSecret != null) {
                try {
                    theSecret.destroy();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public int toDecrypted(byte[] aBuffer, int aOffset, int aLength, byte[] aOutBuffer, int aOutOffset) throws DecryptionException {
        String theInput = new String(aBuffer, aOffset, aLength, StandardCharsets.ISO_8859_1);
        byte[] theEcrypted = this.toDecrypted(theInput).getBytes(StandardCharsets.ISO_8859_1);
        for (int i = 0; i < theEcrypted.length; ++i) {
            aOutBuffer[i + aOffset] = theEcrypted[i];
        }
        return aLength;
    }

    @Override
    public void dispose() {
        Arrays.fill(this._password, '\u0000');
    }
}

