/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.mixin.EnabledAccessor;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.ValueAccessor;
import org.refcodes.runtime.EnvironmentVariable;

public enum SystemProperty implements KeyAccessor<String>,
ValueAccessor.ValueProperty<String>,
EnabledAccessor.EnabledProperty
{
    LOG_TESTS("log.tests"),
    LOG_DEBUG("log.debug"),
    ARGS_FILTER("args.filter"),
    ARGS_NOTATION("args.notation"),
    NATIVE_IMAGE_CODE("org.graalvm.nativeimage.imagecode"),
    NATIVE_IMAGE_KIND("org.graalvm.nativeimage.kind"),
    JAVA_AWT_HEADLESS("java.awt.headless"),
    HTTP_PROXY_HOST("http.proxyHost"),
    HTTP_PROXY_PORT("http.proxyPort"),
    HTTPS_PROXY_HOST("https.proxyHost"),
    HTTPS_PROXY_PORT("https.proxyPort"),
    SOCKS_PROXY_HOST("socksProxyHost"),
    SOCKS_PROXY_PORT("socksProxyPort"),
    HOST_SEED("host.seed"),
    HTTP_NON_PROXY_HOSTS("http.nonProxyHosts"),
    HTTPS_NON_PROXY_HOSTS("https.nonProxyHosts"),
    OS_ARCH("os.arch"),
    OS_NAME("os.name"),
    CONFIG_DIR("config.dir"),
    FILE_SEPARATOR("file.separator"),
    FILE_ENCODING("file.encoding"),
    TEMP_DIR("java.io.tmpdir"),
    PROCESS_ID("PID"),
    LINE_SEPARATOR("line.separator"),
    OPERATING_SYSTEM_NAME("os.name"),
    OPERATING_SYSTEM_VERSION("os.version"),
    LAUNCHER_DIR("launcher.dir"),
    CONSOLE_HEIGHT("console.height"),
    CONSOLE_WIDTH("console.width"),
    CONSOLE_ANSI("console.ansi"),
    CONSOLE_LINE_BREAK("console.lineBreak"),
    LOGGER_LAYOUT("logger.layout"),
    LOGGER_STYLE("logger.style"),
    USER_HOME("user.home"),
    USER_NAME("user.name"),
    USER_LANGUAGE("user.language"),
    USER_COUNTRY("user.country"),
    USER_DIR("user.dir"),
    KEY_STORE_FILE("javax.net.ssl.keyStore"),
    KEY_STORE_PASSWORD("javax.net.ssl.keyStorePassword"),
    KEY_STORE_TYPE("javax.net.ssl.keyStoreType"),
    TRUST_STORE_FILE("javax.net.ssl.trustStore"),
    TRUST_STORE_PASSWORD("javax.net.ssl.trustStorePassword"),
    TRUST_STORE_TYPE("javax.net.ssl.trustStoreType"),
    DOCUMENT_ROOT_PRESERVE("document.root.preserve");

    private String _systemPropertyName;

    private SystemProperty(String aSystemPropertyName) {
        this._systemPropertyName = aSystemPropertyName;
    }

    @Override
    public String getKey() {
        return this._systemPropertyName;
    }

    @Override
    public String getValue() {
        return System.getProperty(this._systemPropertyName);
    }

    @Override
    public void setValue(String aValue) {
        System.setProperty(this._systemPropertyName, aValue);
    }

    @Override
    public boolean isEnabled() {
        return Boolean.getBoolean(this._systemPropertyName);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.setValue(Boolean.toString(isEnabled));
    }

    public static String toPropertyValue(String aDefaultValue, SystemProperty aSystemProperty, EnvironmentVariable ... aEnvironmentProperties) {
        String theValue = aSystemProperty.getValue();
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            for (EnvironmentVariable eProperty : aEnvironmentProperties) {
                theValue = eProperty.getValue();
                if (theValue == null || theValue.length() <= 0) continue;
                return theValue;
            }
        }
        if (theValue != null && theValue.length() > 0) {
            return theValue;
        }
        return aDefaultValue;
    }

    public static String toPropertyValue(SystemProperty aSystemProperty, EnvironmentVariable ... aEnvironmentProperties) {
        String theValue = null;
        if (aSystemProperty != null && (theValue = aSystemProperty.getValue()) != null && theValue.length() != 0) {
            return theValue;
        }
        if (aEnvironmentProperties != null) {
            for (EnvironmentVariable eProperty : aEnvironmentProperties) {
                theValue = eProperty.getValue();
                if (theValue == null || theValue.length() == 0) continue;
                return theValue;
            }
        }
        return null;
    }
}

