/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Text;
import org.refcodes.numerical.NumericalUtility;
import org.refcodes.runtime.EnvironmentVariable;
import org.refcodes.runtime.Execution;
import org.refcodes.runtime.Host;
import org.refcodes.runtime.SystemProperty;

public enum SystemContext {
    APPLICATION(false, false, true, false),
    USER_APPLICATION(false, true, true, false),
    HOST_USER_APPLICATION(true, true, true, false),
    HOST_APPLICATION(true, false, true, false),
    USER(false, true, false, false),
    HOST_USER(true, true, false, false),
    HOST(true, false, false, false),
    SESSION(false, false, false, true),
    APPLICATION_SESSION(false, false, true, true),
    USER_APPLICATION_SESSION(false, true, true, true),
    HOST_USER_APPLICATION_SESSION(true, true, true, true),
    HOST_APPLICATION_SESSION(true, false, true, true),
    USER_SESSION(false, true, false, true),
    HOST_USER_SESSION(true, true, false, true),
    HOST_SESSION(true, false, false, true);

    private static String _hostAddress;
    private static volatile long SESSION_SEED;
    private boolean _isHostLevel;
    private boolean _isUserLevel;
    private boolean _isApplicationLevel;
    private boolean _isSessionLevel;
    private String _ctxSequence = null;

    private SystemContext(boolean isHostLevel, boolean isUserLevel, boolean isApplicationLevel, boolean isSessionLevel) {
        this._isHostLevel = isHostLevel;
        this._isUserLevel = isUserLevel;
        this._isApplicationLevel = isApplicationLevel;
        this._isSessionLevel = isSessionLevel;
    }

    public boolean isHostLevel() {
        return this._isHostLevel;
    }

    public boolean isUserLevel() {
        return this._isUserLevel;
    }

    public boolean isApplicationLevel() {
        return this._isApplicationLevel;
    }

    public boolean isSessionLevel() {
        return this._isSessionLevel;
    }

    public String toContextString() {
        return this.toContextBuffer(null).toString();
    }

    public String toContextString(String aSeed) {
        return this.toContextBuffer(aSeed != null ? aSeed.toCharArray() : null).toString();
    }

    public String toContextString(char[] aSeed) {
        return this.toContextBuffer(aSeed).toString();
    }

    public char[] toContextSequence() {
        return this.toContextSequence((char[])null);
    }

    public char[] toContextSequence(String aSeed) {
        return this.toContextSequence(aSeed != null ? aSeed.toCharArray() : (char[])null);
    }

    public char[] toContextSequence(char[] aSeed) {
        StringBuilder theBuffer = this.toContextBuffer(aSeed);
        int length = theBuffer.length();
        char[] theSequence = new char[length];
        theBuffer.getChars(0, length, theSequence, 0);
        return theSequence;
    }

    public int toContextId() {
        return this.toContextId(null);
    }

    public int toContextId(String aSeed) {
        String theSystemString = this.toContextString(aSeed);
        return NumericalUtility.toHashCode(theSystemString);
    }

    public int[] toContextIds(int aIdLength) {
        return this.toContextIds(aIdLength, null);
    }

    public int[] toContextIds(int aIdLength, String aSeed) {
        String theSystemString = this.toContextString(aSeed);
        return NumericalUtility.toHashCodes(theSystemString, aIdLength);
    }

    public char[] toObfuscated(String aText) {
        return this.toInvertible(aText.toCharArray());
    }

    public char[] toInvertible(char[] aText) {
        byte[] theXorBytes = this.toContextString().getBytes();
        char[] theObfuscated = new char[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theObfuscated[i] = (char)(aText[i] ^ theXorBytes[i % theXorBytes.length]);
        }
        return theObfuscated;
    }

    private StringBuilder toContextBuffer(char[] aSeed) {
        String theSeed;
        StringBuilder theBuffer = new StringBuilder();
        if (this._ctxSequence != null) {
            theBuffer.append(this._ctxSequence);
        } else {
            if (this.isSessionLevel()) {
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                theBuffer.append(SESSION_SEED);
                for (String eValue : System.getenv().keySet()) {
                    theBuffer.append(Delimiter.LIST.getChar());
                    theBuffer.append(System.getenv(eValue));
                }
            }
            if (this.isHostLevel()) {
                String theCores;
                String theComputerName;
                String theArch;
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if (((theArch = SystemProperty.OS_ARCH.getValue()) == null || theArch.isEmpty()) && ((theArch = EnvironmentVariable.PROCESSOR_ARCHITECTURE.getKey()) == null || theArch.isEmpty()) && (theArch = EnvironmentVariable.PROCESSOR_ARCHITEW6432.getKey()) == null) {
                    theArch = Text.ARECIBO_MESSAGE.getText().substring(32, 48);
                }
                theBuffer.append(theArch);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if (_hostAddress == null) {
                    try {
                        _hostAddress = Arrays.toString(Host.toHostMacAddress());
                    }
                    catch (SocketException | UnknownHostException eValue) {
                        // empty catch block
                    }
                    if (_hostAddress == null || _hostAddress.isEmpty()) {
                        try {
                            _hostAddress = Arrays.toString(Host.toHostIpAddress());
                        }
                        catch (IOException eValue) {
                            // empty catch block
                        }
                        if (_hostAddress == null || _hostAddress.isEmpty()) {
                            _hostAddress = Text.ARECIBO_MESSAGE.getText().substring(64, 80);
                        }
                    }
                }
                theBuffer.append(_hostAddress);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theComputerName = Host.getComputerName()) == null || theComputerName.isEmpty()) {
                    theComputerName = Text.ARECIBO_MESSAGE.getText().substring(96, 112);
                }
                theBuffer.append(theComputerName);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                try {
                    theCores = Integer.toString(Runtime.getRuntime().availableProcessors());
                }
                catch (Exception ignore) {
                    theCores = EnvironmentVariable.NUMBER_OF_PROCESSORS.getValue();
                }
                if (theCores == null || theCores.isEmpty()) {
                    theCores = Text.ARECIBO_MESSAGE.getText().substring(112, 128);
                }
                theBuffer.append(theCores);
            }
            if (this.isUserLevel()) {
                String theTemp;
                String theUserHome;
                String theUserName;
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theUserName = SystemProperty.USER_NAME.getValue()) == null || theUserName.isEmpty()) {
                    theUserName = Text.ARECIBO_MESSAGE.getText().substring(0, 16);
                }
                theBuffer.append(theUserName);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theUserHome = SystemProperty.USER_HOME.getValue()) == null || theUserHome.isEmpty()) {
                    theUserHome = Text.ARECIBO_MESSAGE.getText().substring(16, 32);
                }
                theBuffer.append(theUserHome);
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                if ((theTemp = Host.getTempDir()) == null) {
                    theTemp = Text.ARECIBO_MESSAGE.getText().substring(48, 64);
                }
                theBuffer.append(theTemp);
            }
            if (this.isApplicationLevel()) {
                Class theMainClass;
                if (theBuffer.length() != 0) {
                    theBuffer.append(Delimiter.LIST.getChar());
                }
                String theMainString = (theMainClass = Execution.getMainClass()) != null ? theMainClass.getName() : Text.ARECIBO_MESSAGE.getText().substring(128, 144);
                theBuffer.append(theMainString);
            }
            this._ctxSequence = theBuffer.toString();
        }
        if (aSeed != null && aSeed.length != 0) {
            if (theBuffer.length() != 0) {
                theBuffer.append(Delimiter.LIST.getChar());
            }
            theBuffer.append(aSeed);
        }
        if ((theSeed = EnvironmentVariable.HOST_SEED.getValue()) != null && theSeed.length() != 0) {
            if (theBuffer.length() != 0) {
                theBuffer.append(Delimiter.LIST.getChar());
            }
            theBuffer.append(theSeed);
        }
        if ((theSeed = SystemProperty.HOST_SEED.getValue()) != null && theSeed.length() != 0) {
            if (theBuffer.length() != 0) {
                theBuffer.append(Delimiter.LIST.getChar());
            }
            theBuffer.append(theSeed);
        }
        return theBuffer;
    }

    static {
        _hostAddress = null;
        SESSION_SEED = System.currentTimeMillis();
    }
}

