/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.runtime.SystemProperty;

public enum OperatingSystem {
    UNIX(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    WINDOWS(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    MAC(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    UNKNOWN(null);

    private String _version = SystemProperty.OPERATING_SYSTEM_VERSION.getValue();

    private OperatingSystem(String aName) {
        if (aName != null && (this._version == null || this._version.isEmpty())) {
            for (int i = 0; i < aName.length(); ++i) {
                if (!Character.isDigit(aName.charAt(i)) && aName.charAt(i) != '.') continue;
                this._version = this._version + aName.charAt(i);
            }
        }
    }

    public static OperatingSystem toOperatingSystem() {
        String theOperationSystem = SystemProperty.OPERATING_SYSTEM_NAME.getValue();
        if (theOperationSystem != null) {
            if ((theOperationSystem = theOperationSystem.toLowerCase()).contains("win")) {
                return WINDOWS;
            }
            if (theOperationSystem.contains("mac")) {
                return MAC;
            }
            if (theOperationSystem.contains("linux")) {
                return UNIX;
            }
            if (theOperationSystem.contains("sunos")) {
                return UNIX;
            }
            if (theOperationSystem.contains("aix")) {
                return UNIX;
            }
            if (theOperationSystem.contains("nix")) {
                return UNIX;
            }
        }
        return UNKNOWN;
    }

    public String getVersion() {
        return this == OperatingSystem.toOperatingSystem() ? this._version : null;
    }
}

