/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.ValueAccessor;

public enum EnvironmentVariable implements KeyAccessor<String>,
ValueAccessor.ValueProperty<String>
{
    ANSICON("ANSICON"),
    COMPUTERNAME("COMPUTERNAME"),
    CONSOLE_ANSI("CONSOLE_ANSI"),
    CONSOLE_CONEMU_ANSI("ConEmuANSI"),
    CONSOLE_HEIGHT("CONSOLE_HEIGHT"),
    CONSOLE_LINE_BREAK("CONSOLE_LINE_BREAK"),
    CONSOLE_WIDTH("CONSOLE_WIDTH"),
    HOST_SEED("HOST_SEED"),
    HOSTNAME("HOSTNAME"),
    HTTP_PROXY("HTTP_PROXY"),
    HTTPS_PROXY("HTTPS_PROXY"),
    LANG("LANG"),
    LOGGER_LAYOUT("LOGGER_LAYOUT"),
    LOGGER_STYLE("LOGGER_STYLE"),
    NO_PROXY("NO_PROXY"),
    NUMBER_OF_PROCESSORS("NUMBER_OF_PROCESSORS"),
    PROCESSOR_ARCHITECTURE("PROCESSOR_ARCHITECTURE"),
    PROCESSOR_ARCHITEW6432("PROCESSOR_ARCHITEW6432"),
    TERM("TERM"),
    TERMINAL_COLUMNS("COLUMNS"),
    TERMINAL_ENCODING("terminalEncoding"),
    TERMINAL_LINES("LINES"),
    TMPDIR("TMPDIR"),
    USER_DIR("PWD"),
    USER_HOME("HOME"),
    USER_NAME("USER");

    private String _envVariableName;

    private EnvironmentVariable(String aEnvVariableName) {
        this._envVariableName = aEnvVariableName;
    }

    @Override
    public String getKey() {
        return this._envVariableName;
    }

    @Override
    public String getValue() {
        String theValue = System.getenv(this._envVariableName.toUpperCase());
        if ((theValue == null || theValue.isEmpty()) && ((theValue = System.getenv(this._envVariableName.toLowerCase())) == null || theValue.isEmpty())) {
            theValue = System.getenv(this._envVariableName);
        }
        return theValue;
    }

    @Override
    public void setValue(String aValue) {
        String theValue = System.getenv(this._envVariableName.toUpperCase());
        if (theValue == null || theValue.isEmpty()) {
            theValue = System.getenv(this._envVariableName.toLowerCase());
            if (theValue != null && theValue.length() != 0) {
                System.getenv().put(this._envVariableName.toLowerCase(), aValue);
                return;
            }
            theValue = System.getenv(this._envVariableName);
            if (theValue != null && theValue.length() != 0) {
                System.getenv().put(this._envVariableName, aValue);
                return;
            }
        }
        System.getenv().put(this._envVariableName.toUpperCase(), aValue);
    }
}

