/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import org.refcodes.rest.RestRequest;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestfulClient;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.HeaderFieldsAccessor;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;
import org.refcodes.web.HttpRequestBuilder;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.RedirectDepthAccessor;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlAccessor;
import org.refcodes.web.UrlBuilder;

public class RestRequestBuilder
extends RestRequest
implements RedirectDepthAccessor.RedirectDepthBuilder<RestRequestBuilder>,
HttpRequestBuilder<RestRequestBuilder>,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<RestRequestBuilder>,
HeaderFieldsAccessor.HeaderFieldsBuilder<RequestHeaderFields, RestRequestBuilder> {
    private RestfulClient _restClient;

    protected RestRequestBuilder(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, RestfulClient aRestClient) {
        this(aHttpMethod, aUrl instanceof UrlBuilder ? aUrl : new UrlBuilder(aUrl), aHeaderFields, aRequest, -1, aRestClient);
    }

    protected RestRequestBuilder(HttpMethod aHttpMethod, Url aUrl, RestfulClient aRestClient) {
        this(aHttpMethod, aUrl, null, null, aRestClient);
    }

    protected RestRequestBuilder(RestfulClient aRestClient) {
        this(null, null, null, null, aRestClient);
    }

    protected RestRequestBuilder(HttpMethod aHttpMethod, Url aUrl, Object aRequest, RestfulClient aRestClient) {
        this(aHttpMethod, aUrl, null, aRequest, aRestClient);
    }

    protected RestRequestBuilder(HttpMethod aHttpMethod, Url aUrl, int aRedirectDepth, RestfulClient aRestClient) {
        this(aHttpMethod, aUrl, null, null, aRedirectDepth, aRestClient);
    }

    protected RestRequestBuilder(HttpMethod aHttpMethod, Url aUrl, Object aRequest, int aRedirectDepth, RestfulClient aRestClient) {
        this(aHttpMethod, aUrl, null, aRequest, aRedirectDepth, aRestClient);
    }

    protected RestRequestBuilder(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth, RestfulClient aRestClient) {
        super(aHttpMethod, aUrl instanceof UrlAccessor.UrlBuilder ? aUrl : new UrlBuilder(aUrl), aHeaderFields, aRequest, aRedirectDepth, aRestClient);
        this._restClient = aRestClient;
    }

    @Override
    public RestRequestBuilder withUrl(Url aUrl) {
        this.setUrl(aUrl);
        return this;
    }

    @Override
    public RestRequestBuilder withHttpMethod(HttpMethod aHttpMethod) {
        this.setHttpMethod(aHttpMethod);
        return this;
    }

    public <REQ> RestRequestBuilder withRequest(REQ aRequest) {
        this.setRequest(aRequest);
        return this;
    }

    @Override
    public RestRequestBuilder withHeaderFields(RequestHeaderFields aRequestHeaderFields) {
        this.setHeaderFields(aRequestHeaderFields);
        return this;
    }

    @Override
    public RestRequestBuilder withRedirectDepth(int aRedirectDepth) {
        this.setRedirectDepth(aRedirectDepth);
        return this;
    }

    @Override
    public RestRequestBuilder build(RestfulClient aRestClient) {
        return new RestRequestBuilder(aRestClient);
    }

    @Override
    public UrlBuilder getUrl() {
        return (UrlBuilder)this._url;
    }

    @Override
    public void setUrl(Url aUrl) {
        this._url = aUrl;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this._httpMethod + ": " + this._url.toHttpUrl() + "?" + new VerboseTextBuilder().withElements(this._url.getQueryFields()).toString() + ")@" + this.hashCode();
    }

    @Override
    public void setHeaderFields(RequestHeaderFields aHeaderFields) {
        this._headerFields = aHeaderFields;
    }

    @Override
    public RestResponse toRestResponse() throws HttpResponseException {
        return this._restClient.doRequest(this.getHttpMethod(), this.getUrl(), this.getHeaderFields(), this.getRequest(), this.getRedirectDepth());
    }
}

