/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Port;
import org.refcodes.data.Scheme;
import org.refcodes.io.ReplayInputStream;
import org.refcodes.rest.AbstractRestfulClient;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestfulHttpClient;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.security.TrustStoreDescriptor;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.BadRequestException;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpClientContext;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpClientResponse;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.HttpStatusCode;
import org.refcodes.web.OauthToken;
import org.refcodes.web.PostHttpClientInterceptor;
import org.refcodes.web.PreHttpClientInterceptor;
import org.refcodes.web.ResponseHeaderFields;
import org.refcodes.web.Url;
import org.refcodes.web.UrlBuilder;

public class HttpRestClient
extends AbstractRestfulClient
implements RestfulHttpClient {
    private static final Logger LOGGER = Logger.getLogger(HttpRestClient.class.getName());
    private static final int PIPE_STREAM_BUFFER = 1024;
    private Url _baseUrl = null;
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    private TrustStoreDescriptor _storeDescriptor;
    private final List<PreHttpClientInterceptor> _preHttpInterceptos = new ArrayList<PreHttpClientInterceptor>();
    private final List<PostHttpClientInterceptor> _postHttpInterceptos = new ArrayList<PostHttpClientInterceptor>();

    public HttpRestClient() {
        this.onRestRequest(new HttpRestRequestHandler());
    }

    public HttpRestClient(ExecutorService aExecutorService) {
        super(aExecutorService);
        this.onRestRequest(new HttpRestRequestHandler());
    }

    @Override
    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    @Override
    public Url getBaseUrl() {
        return this._baseUrl;
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    @Override
    public TrustStoreDescriptor getTrustStoreDescriptor() {
        return this._storeDescriptor;
    }

    @Override
    public void open(Url aBaseUrl, TrustStoreDescriptor aStoreDescriptor) throws IOException {
        if (aStoreDescriptor == null) {
            aStoreDescriptor = this.getTrustStoreDescriptor();
        } else {
            this._storeDescriptor = aStoreDescriptor;
        }
        if (aBaseUrl == null) {
            aBaseUrl = this.getBaseUrl();
        } else {
            this._baseUrl = aBaseUrl;
        }
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            throw new IOException("The HTTP rest client is already open, close first before opening again!");
        }
        this._connectionStatus = ConnectionStatus.OPENED;
        if (aStoreDescriptor != null) {
            SystemProperty.TRUST_STORE_FILE.setValue(aStoreDescriptor.getStoreFile().getAbsolutePath());
            SystemProperty.TRUST_STORE_PASSWORD.setValue(aStoreDescriptor.getStorePassword() != null ? aStoreDescriptor.getStorePassword() : "");
            SystemProperty.TRUST_STORE_TYPE.setValue(aStoreDescriptor.getStoreType().name());
        }
    }

    @Override
    public void setBaseUrl(Url aBaseUrl) {
        if (aBaseUrl != null) {
            if (aBaseUrl.getScheme() != Scheme.HTTP && aBaseUrl.getScheme() != Scheme.HTTPS) {
                throw new IllegalArgumentException("Cannot use the protocol <" + aBaseUrl.getScheme() + "> to do HTTP requests (" + aBaseUrl.toHttpUrl() + "). You must provide a base URL for protocols <" + Scheme.HTTP.getName() + "> or <" + Scheme.HTTPS.getName() + ">.");
            }
            if (aBaseUrl.getQueryFields() != null && aBaseUrl.getQueryFields().size() != 0) {
                throw new IllegalArgumentException("Cannot use a query <" + new VerboseTextBuilder().withElements(aBaseUrl.getQueryFields()) + "> as bayse path. You must provide a base URL without a query.");
            }
        }
        this._baseUrl = aBaseUrl;
    }

    @Override
    public void setBaseUrl(URL aBaseUrl) {
        this.setBaseUrl(new Url(aBaseUrl));
    }

    @Override
    public void setTrustStoreDescriptor(TrustStoreDescriptor aTrustStoreDescriptor) {
        this._storeDescriptor = aTrustStoreDescriptor;
    }

    @Override
    public boolean hasPreHttpInterceptor(PreHttpClientInterceptor aPreInterceptor) {
        return this._preHttpInterceptos.contains(aPreInterceptor);
    }

    @Override
    public boolean addPreHttpInterceptor(PreHttpClientInterceptor aPreInterceptor) {
        if (!this._preHttpInterceptos.contains(aPreInterceptor)) {
            return this._preHttpInterceptos.add(aPreInterceptor);
        }
        return false;
    }

    @Override
    public boolean removePreHttpInterceptor(PreHttpClientInterceptor aPreInterceptor) {
        return this._preHttpInterceptos.remove(aPreInterceptor);
    }

    @Override
    public boolean hasPostHttpInterceptor(PostHttpClientInterceptor aPostInterceptor) {
        return this._postHttpInterceptos.contains(aPostInterceptor);
    }

    @Override
    public boolean addPostHttpInterceptor(PostHttpClientInterceptor aPostInterceptor) {
        if (!this._postHttpInterceptos.contains(aPostInterceptor)) {
            return this._postHttpInterceptos.add(aPostInterceptor);
        }
        return false;
    }

    @Override
    public boolean removePostHttpInterceptor(PostHttpClientInterceptor aPostInterceptor) {
        return this._postHttpInterceptos.remove(aPostInterceptor);
    }

    @Override
    public HttpRestClient withOpen() throws IOException {
        this.open();
        return this;
    }

    @Override
    public HttpRestClient withOpen(HttpClientContext aCtx) throws IOException {
        this.open(aCtx);
        return this;
    }

    @Override
    public HttpRestClient withOpen(TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(aStoreDescriptor);
        return this;
    }

    @Override
    public HttpRestClient withOpen(Url aBaseUrl) throws IOException {
        this.open(aBaseUrl);
        return this;
    }

    @Override
    public HttpRestClient withOpen(Url aBaseUrl, TrustStoreDescriptor aStoreDescriptor) throws IOException {
        this.open(aBaseUrl, aStoreDescriptor);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(String aBaseUrl) throws MalformedURLException {
        this.setBaseUrl(aBaseUrl);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(Url aBaseUrl) {
        this.setBaseUrl(aBaseUrl);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(URL aBaseURL) {
        this.setBaseUrl(aBaseURL);
        return this;
    }

    @Override
    public HttpRestClient withBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this.setBasicAuthCredentials(aBasicAuthCredentials);
        return this;
    }

    @Override
    public HttpRestClient withBasicAuthCredentials(String aUserName, String aSecret) {
        this.setBasicAuthCredentials(aUserName, aSecret);
        return this;
    }

    @Override
    public HttpRestClient withOAuthToken(OauthToken aOauthToken) {
        this.setOauthToken(aOauthToken);
        return this;
    }

    @Override
    public HttpRestClient withTrustStoreDescriptor(TrustStoreDescriptor aStoreDescriptor) {
        this.setTrustStoreDescriptor(aStoreDescriptor);
        return this;
    }

    @Override
    public HttpRestClient withUserAgent(String aUserAgent) {
        this.setUserAgent(aUserAgent);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(String aProtocol, String aHost) throws MalformedURLException {
        this.setBaseUrl(aProtocol, aHost);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(Scheme aScheme, String aHost) throws MalformedURLException {
        this.setBaseUrl(aScheme, aHost);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(String aProtocol, String aHost, String aPath) throws MalformedURLException {
        this.setBaseUrl(aProtocol, aHost, aPath);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(Scheme aScheme, String aHost, String aPath) throws MalformedURLException {
        this.setBaseUrl(aScheme, aHost, aPath);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(String aProtocol, String aHost, int aPort) throws MalformedURLException {
        this.setBaseUrl(aProtocol, aHost, aPort);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(Scheme aScheme, String aHost, int aPort) throws MalformedURLException {
        this.setBaseUrl(aScheme, aHost, aPort);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(String aProtocol, String aHost, int aPort, String aPath) throws MalformedURLException {
        this.setBaseUrl(aProtocol, aHost, aPort, aPath);
        return this;
    }

    @Override
    public HttpRestClient withBaseUrl(Scheme aScheme, String aHost, int aPort, String aPath) throws MalformedURLException {
        this.setBaseUrl(aScheme, aHost, aPort, aPath);
        return this;
    }

    @Override
    public HttpRestClient withOpenUnchecked() {
        this.openUnchecked();
        return this;
    }

    protected static void pipe(InputStream aInputStream, OutputStream aOutoutStream) throws IOException {
        int eBytes;
        byte[] theBuffer = new byte[1024];
        while ((eBytes = aInputStream.read(theBuffer)) > -1) {
            aOutoutStream.write(theBuffer, 0, eBytes);
        }
    }

    @Override
    protected void preIntercept(HttpClientRequest aRequest, HttpClientResponse aResponse) {
        for (PreHttpClientInterceptor eInterceptor : this._preHttpInterceptos) {
            eInterceptor.preIntercept(aRequest, aResponse);
        }
    }

    @Override
    protected void postIntercept(HttpClientRequest aRequest, HttpClientResponse aResponse) {
        for (PostHttpClientInterceptor eInterceptor : this._postHttpInterceptos) {
            eInterceptor.postIntercept(aRequest, aResponse);
        }
    }

    private class HttpRestRequestHandler
    implements RestRequestHandler {
        private HttpRestRequestHandler() {
        }

        @Override
        public RestResponse doRequest(HttpClientRequest aClientRequest) throws HttpResponseException {
            if (HttpRestClient.this._connectionStatus == ConnectionStatus.CLOSED) {
                throw new IllegalStateException(" Expected a connection status <" + ConnectionStatus.OPENED.name() + ">, unable to produce a HTTP request while the connection is in status <" + HttpRestClient.this._connectionStatus.name() + ">, did you forget to call #open(...)?");
            }
            Url theRequestUrl = aClientRequest.getUrl();
            try {
                HttpURLConnection theHttpConnection = null;
                InetSocketAddress theLocalAddress = null;
                InetSocketAddress theRemoteAddress = null;
                HttpStatusCode theStatusCode = null;
                ResponseHeaderFields theResponseHeaderFields = new ResponseHeaderFields();
                HttpClientResponse theClientResponse = new HttpClientResponse(theRequestUrl, theResponseHeaderFields, HttpRestClient.this);
                HttpRestClient.this.preIntercept(aClientRequest, theClientResponse);
                int theRedirectDepth = aClientRequest.getRedirectDepth();
                if (theRedirectDepth < 0) {
                    HttpURLConnection.setFollowRedirects(true);
                    theRedirectDepth = 0;
                } else {
                    HttpURLConnection.setFollowRedirects(false);
                }
                boolean isRedirectCycle = false;
                while (theRedirectDepth >= 0) {
                    URL theUrl = null;
                    try {
                        theUrl = theRequestUrl.toURL();
                    }
                    catch (MalformedURLException e) {
                        if (HttpRestClient.this._baseUrl == null) {
                            throw new HttpResponseException("Unable to create a valid URL from the locator <{1}> with a <null> base URL!", HttpStatusCode.INTERNAL_CLIENT_ERROR, theRequestUrl, e);
                        }
                        try {
                            String theExternalForm = isRedirectCycle ? new UrlBuilder(HttpRestClient.this._baseUrl).withPath(null).toHttpUrl() : HttpRestClient.this._baseUrl.toHttpUrl();
                            String theRelativeUrl = theRequestUrl.toHttpUrl();
                            Object theSeparator = "";
                            if (!(theExternalForm != null && theExternalForm.endsWith("" + Delimiter.PATH.getChar()) || theRelativeUrl != null && theRelativeUrl.startsWith("" + Delimiter.PATH.getChar()))) {
                                theSeparator = "" + Delimiter.PATH.getChar();
                            }
                            theUrl = new URL(theExternalForm + (String)theSeparator + (String)theRelativeUrl);
                        }
                        catch (MalformedURLException e2) {
                            throw new HttpResponseException("Unable to create a valid URL from the base URL <" + HttpRestClient.this._baseUrl.toHttpUrl() + "> and the request URL <{1}>!", HttpStatusCode.INTERNAL_CLIENT_ERROR, theRequestUrl, e2);
                        }
                    }
                    int thePort = theUrl.getPort();
                    if (thePort == -1) {
                        String theProtocol = theUrl.getProtocol();
                        if (Scheme.HTTP.getName().equalsIgnoreCase(theProtocol)) {
                            thePort = Port.HTTP.getPort();
                        }
                        if (Scheme.HTTPS.getName().equalsIgnoreCase(theProtocol)) {
                            thePort = Port.HTTPS.getPort();
                        }
                    }
                    theRemoteAddress = new InetSocketAddress(theUrl.getHost(), thePort);
                    theLocalAddress = InetSocketAddress.createUnresolved(InetAddress.getLocalHost().getHostName(), thePort);
                    theHttpConnection = (HttpURLConnection)theUrl.openConnection();
                    theHttpConnection.setRequestMethod(aClientRequest.getHttpMethod().name());
                    List<String> theAcceptTypes = aClientRequest.getHeaderFields().get(HeaderField.ACCEPT);
                    if (theAcceptTypes == null || theAcceptTypes.size() == 0) {
                        aClientRequest.getHeaderFields().putAcceptTypes(HttpRestClient.this.getFactoryMediaTypes());
                    }
                    theHttpConnection.setRequestMethod(aClientRequest.getHttpMethod().name());
                    for (String eKey : aClientRequest.getHeaderFields().keySet()) {
                        theHttpConnection.setRequestProperty(eKey, aClientRequest.getHeaderFields().toField(eKey));
                    }
                    Object theRequest = aClientRequest.getRequest();
                    if (theRequest instanceof InputStream) {
                        InputStream theInputStream = (InputStream)theRequest;
                        theHttpConnection.setDoOutput(true);
                        HttpRestClient.pipe(theInputStream, theHttpConnection.getOutputStream());
                        theHttpConnection.getOutputStream().flush();
                    } else {
                        String theBody = aClientRequest.toHttpBody();
                        if (theBody != null) {
                            theHttpConnection.setDoOutput(true);
                            theHttpConnection.getOutputStream().write(theBody.getBytes());
                            theHttpConnection.getOutputStream().flush();
                        }
                    }
                    if (!aClientRequest.getHttpMethod().name().equalsIgnoreCase(theHttpConnection.getRequestMethod())) {
                        LOGGER.log(Level.WARNING, "You issued a request with HTTP-Method <" + aClientRequest.getHttpMethod().name() + "> which is not applicable for sending a HTTP body, the HTTP-Method has been changed to <" + theHttpConnection.getRequestMethod() + ">.");
                    }
                    Map<String, List<String>> theHeaderFields = theHttpConnection.getHeaderFields();
                    theResponseHeaderFields.putAll((Map<? extends String, ? extends List<String>>)theHeaderFields);
                    theStatusCode = HttpStatusCode.toHttpStatusCode(theHttpConnection.getResponseCode());
                    if (theStatusCode.isRedirectStatus() && theRedirectDepth > 0) {
                        isRedirectCycle = true;
                        String theLocation = theResponseHeaderFields.getLocation();
                        UrlBuilder theUrlBuilder = new UrlBuilder(theRequestUrl);
                        if (theLocation != null) {
                            if (this.isAbsoluteUrl(theLocation)) {
                                int theTmpPort;
                                String theTmpPath;
                                int[] theTmpIp;
                                String theTmpHost;
                                UrlBuilder theTmpUrl = new UrlBuilder(theLocation);
                                Scheme theTmpScheme = theTmpUrl.getScheme();
                                if (theTmpScheme != null) {
                                    theUrlBuilder.setScheme(theTmpScheme);
                                }
                                if ((theTmpHost = theTmpUrl.getHost()) != null) {
                                    theUrlBuilder.setHost(theTmpHost);
                                }
                                if ((theTmpIp = theTmpUrl.getIpAddress()) != null && theTmpIp.length > 0) {
                                    theUrlBuilder.setIpAddress(theTmpIp);
                                }
                                if ((theTmpPath = theTmpUrl.getPath()) != null) {
                                    theUrlBuilder.setPath(theTmpPath);
                                }
                                if ((theTmpPort = theTmpUrl.getPort()) != -1) {
                                    theUrlBuilder.setPort(theTmpPort);
                                }
                            } else {
                                theUrlBuilder.setPath(theLocation);
                            }
                            theRequestUrl = theUrlBuilder;
                            --theRedirectDepth;
                            continue;
                        }
                        theRedirectDepth = -1;
                        continue;
                    }
                    theRedirectDepth = -1;
                }
                InputStream theHttpInputStream = new HttpConnectionInputStream(theHttpConnection);
                if (!((InputStream)theHttpInputStream).markSupported()) {
                    theHttpInputStream = new ReplayInputStream(theHttpInputStream);
                }
                RestResponse theRestResponse = new RestResponse(theRequestUrl, theLocalAddress, theRemoteAddress, theStatusCode, theResponseHeaderFields, theHttpInputStream, HttpRestClient.this);
                HttpRestClient.this.postIntercept(aClientRequest, theRestResponse);
                return theRestResponse;
            }
            catch (IOException e) {
                throw new HttpResponseException(this.toMessage(aClientRequest), HttpStatusCode.INTERNAL_CLIENT_ERROR, theRequestUrl, e);
            }
            catch (BadRequestException e) {
                throw new HttpResponseException(this.toMessage(aClientRequest), e.getStatusCode(), (Throwable)e);
            }
        }

        private boolean isAbsoluteUrl(String aLocation) {
            String theLocation = aLocation.toLowerCase();
            if (theLocation.startsWith(Scheme.HTTP.toProtocol().toLowerCase())) {
                return true;
            }
            return theLocation.startsWith(Scheme.HTTPS.toProtocol().toLowerCase());
        }

        private String toMessage(HttpClientRequest aClientRequest) {
            return "Error while processing URL <" + aClientRequest.getUrl().toHttpUrl() + "> using HTTP-Method <" + aClientRequest.getHttpMethod().toString() + ">!";
        }
    }

    private static class HttpConnectionInputStream
    extends InputStream {
        private InputStream _inputStream;

        public HttpConnectionInputStream(HttpURLConnection aHttpURLConnection) {
            block2: {
                try {
                    this._inputStream = aHttpURLConnection.getInputStream();
                }
                catch (IOException e1) {
                    this._inputStream = aHttpURLConnection.getErrorStream();
                    if (this._inputStream != null) break block2;
                    String theMessage = e1.getMessage();
                    this._inputStream = new ByteArrayInputStream(theMessage.getBytes(StandardCharsets.UTF_8));
                }
            }
        }

        @Override
        public int available() throws IOException {
            return this._inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this._inputStream.close();
        }

        public boolean equals(Object obj) {
            return this._inputStream.equals(obj);
        }

        public int hashCode() {
            return this._inputStream.hashCode();
        }

        @Override
        public void mark(int readlimit) {
            this._inputStream.mark(readlimit);
        }

        @Override
        public boolean markSupported() {
            return this._inputStream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this._inputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this._inputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this._inputStream.read(b, off, len);
        }

        @Override
        public void reset() throws IOException {
            this._inputStream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this._inputStream.skip(n);
        }

        public String toString() {
            return this._inputStream.toString();
        }
    }
}

