/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.ConnectionStatusAccessor;
import org.refcodes.component.LinkComponent;
import org.refcodes.rest.BasicAuthEndpoint;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.BasicAuthObserver;
import org.refcodes.web.BasicAuthResponse;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpMethodAccessor;

public class BasicAuthEndpointBuilder
implements BasicAuthEndpoint,
HttpMethodAccessor.HttpMethodProperty,
HttpMethodAccessor.HttpMethodBuilder<BasicAuthEndpointBuilder>,
LinkComponent.LinkComponentBuilder<BasicAuthEndpointBuilder>,
ConnectionStatusAccessor {
    private static final Logger LOGGER = Logger.getLogger(BasicAuthEndpointBuilder.class.getName());
    protected BasicAuthObserver _requestObserver = null;
    protected HttpMethod _httpMethod = HttpMethod.GET;
    protected String _locatorPattern = null;
    protected ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    public BasicAuthEndpointBuilder() {
    }

    public BasicAuthEndpointBuilder(HttpMethod aHttpMethod, String aLocatorPathPattern, BasicAuthObserver aRequestConsumer) {
        this._httpMethod = aHttpMethod;
        this._locatorPattern = aLocatorPathPattern;
        this._requestObserver = aRequestConsumer;
    }

    @Override
    public BasicAuthEndpointBuilder withHttpMethod(HttpMethod aHttpMethod) {
        this.setHttpMethod(aHttpMethod);
        return this;
    }

    public BasicAuthEndpointBuilder withLocatorPathPattern(String aLocatorPathPattern) {
        this.setLocatorPathPattern(aLocatorPathPattern);
        return this;
    }

    public BasicAuthEndpointBuilder withRequestObserver(BasicAuthObserver aLambda) {
        this.setRequestObserver(aLambda);
        return this;
    }

    @Override
    public BasicAuthEndpointBuilder withOpen() throws IOException {
        this.open();
        return this;
    }

    @Override
    public BasicAuthEndpointBuilder withClose() throws IOException {
        this.close();
        return this;
    }

    @Override
    public BasicAuthEndpointBuilder withCloseQuietly() {
        this.closeQuietly();
        return this;
    }

    @Override
    public BasicAuthEndpointBuilder withCloseIn(int aCloseMillis) {
        this.closeIn(aCloseMillis);
        return this;
    }

    public void setLocatorPathPattern(String aLocatorPathPattern) {
        this._locatorPattern = aLocatorPathPattern;
    }

    @Override
    public void setHttpMethod(HttpMethod aHttpMethod) {
        this._httpMethod = aHttpMethod;
    }

    public void setRequestObserver(BasicAuthObserver aLambda) {
        this._requestObserver = aLambda;
    }

    public BasicAuthObserver getRequestObserver() {
        return this._requestObserver;
    }

    @Override
    public BasicAuthResponse onBasicAuthRequest(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, String aLocator, BasicAuthCredentials aCredentials, String aRealm) {
        if (this._connectionStatus == ConnectionStatus.OPENED) {
            return this._requestObserver.onBasicAuthRequest(aLocalAddress, aRemoteAddress, aHttpMethod, aLocator, aCredentials, aRealm);
        }
        LOGGER.log(Level.WARNING, "Ignoring Basic-Auth <" + aHttpMethod + "> request for locator <" + aLocator + "> as this rest endpoint is in status <" + this._connectionStatus + ">, you may not have opened it?");
        return BasicAuthResponse.BASIC_AUTH_SKIP;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this._httpMethod;
    }

    @Override
    public String getLocatorPathPattern() {
        return this._locatorPattern;
    }

    @Override
    public void open() throws IOException {
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    @Override
    public void close() throws IOException {
        this._connectionStatus = ConnectionStatus.CLOSED;
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }
}

