/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.controlflow.ExecutionStrategy;
import org.refcodes.data.Delimiter;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.VetoException;
import org.refcodes.io.ReplayInputStream;
import org.refcodes.matcher.AbstractWildcardMatcher;
import org.refcodes.matcher.PathMatcher;
import org.refcodes.matcher.RegExpMatcher;
import org.refcodes.matcher.WildcardMatcher;
import org.refcodes.mixin.WildcardSubstitutes;
import org.refcodes.observer.AbstractObservable;
import org.refcodes.rest.RestEndpoint;
import org.refcodes.rest.RestRequestEvent;
import org.refcodes.rest.RestfulServer;
import org.refcodes.runtime.Host;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.BasicAuthRequiredException;
import org.refcodes.web.ContentType;
import org.refcodes.web.FormMediaTypeFactory;
import org.refcodes.web.HeaderField;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpRequest;
import org.refcodes.web.HttpServerRequest;
import org.refcodes.web.HttpServerResponse;
import org.refcodes.web.HttpStatusException;
import org.refcodes.web.InternalServerErrorException;
import org.refcodes.web.JsonMediaTypeFactory;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.NotFoundException;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.ResponseHeaderFields;
import org.refcodes.web.TextMediaTypeFactory;
import org.refcodes.web.UnsupportedMediaTypeException;
import org.refcodes.web.Url;
import org.refcodes.web.XmlMediaTypeFactory;

public abstract class AbstractRestfulServer
extends AbstractObservable<RestEndpoint, HttpRequest>
implements RestfulServer {
    private static final Logger LOGGER = Logger.getLogger(AbstractRestfulServer.class.getName());
    private final Map<MediaType, MediaTypeFactory> _mediaTypeFacotries = new LinkedHashMap<MediaType, MediaTypeFactory>();
    private final Map<WildcardMatcher, List<RestEndpoint>> _matcherEndpoints = new LinkedHashMap<WildcardMatcher, List<RestEndpoint>>();
    private String _realm = Host.getComputerName();
    private String _baseLocator = null;
    protected boolean _isVerbose;

    public AbstractRestfulServer() {
        this(false);
    }

    public AbstractRestfulServer(boolean isVerbose) {
        this.initMedaTypeFactories();
        this._isVerbose = isVerbose;
    }

    public AbstractRestfulServer(ExecutorService aExecutorService) {
        this(aExecutorService, false);
    }

    public AbstractRestfulServer(ExecutorService aExecutorService, boolean isVerbose) {
        super(aExecutorService);
        this.initMedaTypeFactories();
        this._isVerbose = isVerbose;
    }

    protected void initMedaTypeFactories() {
        this.addMediaTypeFactory(new JsonMediaTypeFactory());
        this.addMediaTypeFactory(new XmlMediaTypeFactory());
        this.addMediaTypeFactory(new FormMediaTypeFactory());
        this.addMediaTypeFactory(new TextMediaTypeFactory());
    }

    @Override
    public void setObserversActive(boolean isActive) {
        super.setObserversActive(isActive);
    }

    @Override
    public boolean isObserversActive() {
        return super.isObserversActive();
    }

    @Override
    public Iterator<RestEndpoint> observers() {
        return super.observers();
    }

    @Override
    public String getRealm() {
        return this._realm;
    }

    @Override
    public void setRealm(String aRealm) {
        this._realm = aRealm;
    }

    @Override
    public String getBaseLocator() {
        return this._baseLocator;
    }

    @Override
    public void setBaseLocator(String aBaseLocator) {
        if (!aBaseLocator.startsWith("" + Delimiter.PATH.getChar())) {
            throw new IllegalArgumentException("Your provided base locator <" + aBaseLocator + "> is not an absolute locator, it has to start with a slash (\"" + Delimiter.PATH.getChar() + "\") character to be an absolute locator.");
        }
        this._baseLocator = aBaseLocator;
    }

    @Override
    public synchronized boolean subscribeObserver(RestEndpoint aObserver) {
        if (super.subscribeObserver(aObserver)) {
            AbstractWildcardMatcher theMatcher;
            if (aObserver.getLocatorPathPattern() != null) {
                theMatcher = new PathMatcher(aObserver.getLocatorPathPattern());
            } else if (aObserver.getLocatorRegExp() != null) {
                theMatcher = new RegExpMatcher(aObserver.getLocatorRegExp());
            } else {
                return false;
            }
            List<RestEndpoint> theEndpoints = this._matcherEndpoints.get(theMatcher);
            if (theEndpoints == null) {
                theEndpoints = new ArrayList<RestEndpoint>();
                this._matcherEndpoints.put((WildcardMatcher)((Object)theMatcher), theEndpoints);
            }
            theEndpoints.add(aObserver);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean unsubscribeObserver(RestEndpoint aObserver) {
        if (super.unsubscribeObserver(aObserver)) {
            Iterator<WildcardMatcher> eMatchers = this._matcherEndpoints.keySet().iterator();
            while (eMatchers.hasNext()) {
                List<RestEndpoint> eObservers = this._matcherEndpoints.get(eMatchers.next());
                Iterator<RestEndpoint> eEndpoints = eObservers.iterator();
                while (eEndpoints.hasNext()) {
                    if (aObserver != eEndpoints.next()) continue;
                    eEndpoints.remove();
                }
                if (!eObservers.isEmpty()) continue;
                eMatchers.remove();
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addMediaTypeFactory(MediaTypeFactory aMediaTypeFactory) {
        boolean hasAddedAny = false;
        for (MediaType eMediaType : aMediaTypeFactory.getMediaTypes()) {
            if (this._mediaTypeFacotries.containsKey(eMediaType)) continue;
            this._mediaTypeFacotries.put(eMediaType, aMediaTypeFactory);
            hasAddedAny = true;
        }
        return hasAddedAny;
    }

    @Override
    public MediaTypeFactory toMediaTypeFactory(MediaType aMediaType) {
        return this._mediaTypeFacotries.get(aMediaType);
    }

    @Override
    public MediaType[] getFactoryMediaTypes() {
        return this._mediaTypeFacotries.keySet().toArray(new MediaType[this._mediaTypeFacotries.size()]);
    }

    @Override
    public void dispose() {
        this._matcherEndpoints.clear();
        this._matcherEndpoints.clear();
        super.dispose();
    }

    protected void onHttpRequest(InetSocketAddress aLocalAddress, InetSocketAddress aRemoteAddress, HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aRequestHeaderFields, InputStream aHttpInputStream, HttpServerResponse aHttpServerResponse) throws HttpStatusException {
        String theLocator = aUrl.getPath();
        RestEndpoint theEndpoint = null;
        ContentType theMediaType = this.toNegotiatedContenType(aRequestHeaderFields);
        if (theMediaType != null) {
            aHttpServerResponse.getHeaderFields().putContentType(theMediaType);
        }
        if (this._baseLocator == null || theLocator.toLowerCase().startsWith(this._baseLocator.toLowerCase())) {
            if (this._baseLocator != null) {
                theLocator = theLocator.substring(this._baseLocator.length());
            }
            Object eResponse = null;
            for (WildcardMatcher eMatcher : this._matcherEndpoints.keySet()) {
                List<RestEndpoint> eEndpoints;
                WildcardSubstitutes eWildcardSubstitutes = eMatcher.toWildcardSubstitutes(theLocator);
                if (eWildcardSubstitutes == null || (eEndpoints = this._matcherEndpoints.get(eMatcher)).size() == 0) continue;
                if (!aHttpInputStream.markSupported()) {
                    aHttpInputStream = new ReplayInputStream(aHttpInputStream);
                }
                HttpServerRequest theHttpServerRequest = new HttpServerRequest(aHttpMethod, aUrl, aRequestHeaderFields, aHttpInputStream, this);
                for (RestEndpoint eEndpoint : eEndpoints) {
                    if (eEndpoint.getHttpMethod() != null && eEndpoint.getHttpMethod() != aHttpMethod) continue;
                    if (theEndpoint == null) {
                        theEndpoint = eEndpoint;
                    }
                    RestRequestEvent eRestRequestEvent = new RestRequestEvent(aLocalAddress, aRemoteAddress, aHttpMethod, aUrl, eWildcardSubstitutes, aRequestHeaderFields, aHttpInputStream, this);
                    try {
                        this.preIntercept(theHttpServerRequest, aHttpServerResponse);
                        eEndpoint.onRequest(eRestRequestEvent, aHttpServerResponse);
                        this.postIntercept(theHttpServerRequest, aHttpServerResponse);
                    }
                    catch (BasicAuthRequiredException e) {
                        aHttpServerResponse.getHeaderFields().putBasicAuthRequired(this.getRealm());
                        throw e;
                    }
                    if (eResponse == null) {
                        eResponse = aHttpServerResponse.getResponse();
                        continue;
                    }
                    if (eResponse == null) continue;
                    if (SystemProperty.LOG_DEBUG.isEnabled() || this._isVerbose) {
                        LOGGER.log(Level.WARNING, "An endpoint of type <" + eEndpoint.getClass().getName() + "> (" + eEndpoint + ") would overwrite the response already produced by an endpoint of type <" + theEndpoint.getClass().getName() + "> (" + theEndpoint + " )");
                    }
                    throw new InternalServerErrorException("Unambiguous responsibility detected for handling resource locator <" + theLocator + "> with HTTP-Method <" + aHttpMethod + ">.");
                }
            }
        }
        if (theEndpoint == null) {
            throw new NotFoundException("There is none endpoint for handling resource locator <" + theLocator + "> with HTTP-Method <" + aHttpMethod + ">.");
        }
    }

    protected ContentType toNegotiatedContenType(RequestHeaderFields aRequestHeaderFields) {
        ContentType theMediatype = null;
        List<ContentType> theRequestAcceptTypes = aRequestHeaderFields.getAcceptTypes();
        if (theRequestAcceptTypes != null) {
            for (ContentType theContentType : theRequestAcceptTypes) {
                if (!this.hasMediaTypeFactory(theContentType.getMediaType())) continue;
                theMediatype = theContentType;
                break;
            }
        } else {
            ContentType theRequestContentType;
            List<String> theUnkonwnAcceptTypes = aRequestHeaderFields.getUnknownAcceptTypes();
            if ((SystemProperty.LOG_DEBUG.isEnabled() || this._isVerbose) && theUnkonwnAcceptTypes != null && theUnkonwnAcceptTypes.size() != 0) {
                LOGGER.log(Level.WARNING, "Unable to resolve unknown request's Header-Field <" + HeaderField.ACCEPT.getName() + ">: " + new VerboseTextBuilder().withElements(theUnkonwnAcceptTypes).toString());
            }
            if ((theRequestContentType = aRequestHeaderFields.getContentType()) != null && this.hasMediaTypeFactory(theRequestContentType.getMediaType())) {
                theMediatype = theRequestContentType;
            }
            List<String> theUnkonwnContentTypes = aRequestHeaderFields.getUnknownContentTypes();
            if ((SystemProperty.LOG_DEBUG.isEnabled() || this._isVerbose) && theUnkonwnContentTypes != null && theUnkonwnContentTypes.size() != 0) {
                LOGGER.log(Level.WARNING, "Unable to resolve unknown request's Header-Field <" + HeaderField.CONTENT_TYPE.getName() + ">: " + new VerboseTextBuilder().withElements(theUnkonwnContentTypes).toString());
            }
        }
        return theMediatype;
    }

    protected byte[] toResponseBody(Object aResponse, RequestHeaderFields aRequestHeaderFields, ResponseHeaderFields aResponseHeaderFields) throws MarshalException, UnsupportedMediaTypeException {
        if (aResponse == null) {
            return new byte[0];
        }
        String theResponseBody = this.toMarshaled(aResponse, aResponseHeaderFields.getContentType(), aResponseHeaderFields);
        if (theResponseBody != null) {
            if (SystemProperty.LOG_DEBUG.isEnabled() || this._isVerbose) {
                LOGGER.log(Level.INFO, "Auto-determined Response-Header's <" + HeaderField.CONTENT_TYPE.getName() + "> Media-Type <" + aResponseHeaderFields.getContentType().toHttpMediaType() + "> for the response.");
            }
            return theResponseBody.getBytes();
        }
        List<ContentType> theAcceptTypes = aRequestHeaderFields.getAcceptTypes();
        if (theAcceptTypes != null) {
            for (ContentType eContentType : theAcceptTypes) {
                theResponseBody = this.toMarshaled(aResponse, eContentType, aResponseHeaderFields);
                if (theResponseBody == null) continue;
                if (SystemProperty.LOG_DEBUG.isEnabled() || this._isVerbose) {
                    LOGGER.log(Level.INFO, "Auto-determined Request-Header's <" + HeaderField.ACCEPT.getName() + "> Media-Type <" + eContentType.toHttpMediaType() + "> for the response.");
                }
                return theResponseBody.getBytes();
            }
        }
        if ((theResponseBody = this.toMarshaled(aResponse, aRequestHeaderFields.getContentType(), aResponseHeaderFields)) != null) {
            if (SystemProperty.LOG_DEBUG.isEnabled() || this._isVerbose) {
                LOGGER.log(Level.INFO, "Auto-determined Request-Header's <" + HeaderField.CONTENT_TYPE.getName() + "> Media-Type <" + aRequestHeaderFields.getContentType().toHttpMediaType() + "> for the response.");
            }
            return theResponseBody.getBytes();
        }
        if (aResponseHeaderFields.getContentType() != null || aRequestHeaderFields.getContentType() != null || aRequestHeaderFields.getAcceptTypes() != null && aRequestHeaderFields.getAcceptTypes().size() != 0) {
            throw new UnsupportedMediaTypeException("No Media-Type factory found for request ACCEPT types <" + new VerboseTextBuilder().withElements(aRequestHeaderFields.getAcceptTypes()) + "> or response CONTENT-TYPE <" + aResponseHeaderFields.getContentType() + "> or request CONTENT type <" + aRequestHeaderFields.getContentType() + ">.");
        }
        throw new UnsupportedMediaTypeException("No Media-Type in HTTP-Request detected.");
    }

    @Override
    protected boolean fireEvent(HttpRequest aEvent, RestEndpoint aObserver, ExecutionStrategy aExecutionStrategy) throws VetoException {
        throw new UnsupportedOperationException("As the #onHttpRequest method takes care of observer invocation.");
    }

    protected void preIntercept(HttpServerRequest aRequest, HttpServerResponse aResponse) {
    }

    protected void postIntercept(HttpServerRequest aRequest, HttpServerResponse aResponse) {
    }

    private String toMarshaled(Object aResponse, MediaType aMediaType, Map<String, String> aMediaTypeParams, ResponseHeaderFields aResponseHeaderFields) {
        MediaTypeFactory theFactory;
        if (aMediaTypeParams != null && aMediaTypeParams.isEmpty()) {
            aMediaTypeParams = null;
        }
        if ((theFactory = this.toMediaTypeFactory(aMediaType)) != null) {
            try {
                String theMarshaled = (String)theFactory.toMarshaled(aResponse, aMediaTypeParams);
                ContentType theContentType = new ContentType(aMediaType, aMediaTypeParams);
                aResponseHeaderFields.putContentType(theContentType);
                return theMarshaled;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String toMarshaled(Object aResponse, ContentType contentType, ResponseHeaderFields aResponseHeaderFields) {
        return this.toMarshaled(aResponse, contentType != null ? contentType.getMediaType() : null, contentType, aResponseHeaderFields);
    }
}

