/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.rest;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.data.Text;
import org.refcodes.rest.RestRequestBuilder;
import org.refcodes.rest.RestRequestHandler;
import org.refcodes.rest.RestResponse;
import org.refcodes.rest.RestResponseConsumer;
import org.refcodes.rest.RestResponseHandler;
import org.refcodes.rest.RestResponseResult;
import org.refcodes.rest.RestfulClient;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.web.AuthType;
import org.refcodes.web.BasicAuthCredentials;
import org.refcodes.web.FormMediaTypeFactory;
import org.refcodes.web.HtmlMediaTypeFactory;
import org.refcodes.web.HttpClientRequest;
import org.refcodes.web.HttpClientResponse;
import org.refcodes.web.HttpMethod;
import org.refcodes.web.HttpResponseException;
import org.refcodes.web.JsonMediaTypeFactory;
import org.refcodes.web.MediaType;
import org.refcodes.web.MediaTypeFactory;
import org.refcodes.web.OauthToken;
import org.refcodes.web.RequestHeaderFields;
import org.refcodes.web.TextMediaTypeFactory;
import org.refcodes.web.Url;
import org.refcodes.web.XmlMediaTypeFactory;

public abstract class AbstractRestfulClient
implements RestfulClient {
    private final Map<MediaType, MediaTypeFactory> _mediaTypeFacotries = new LinkedHashMap<MediaType, MediaTypeFactory>();
    private ExecutorService _executorService;
    private String _userAgent = this.getClass().getSimpleName() + "@" + Text.REFCODES_ORG.getText();
    private RestRequestHandler _requestHandler = null;
    private BasicAuthCredentials _basicAuthCredentials;
    private OauthToken _oauthToken = null;

    public AbstractRestfulClient(ExecutorService aExecutorService) {
        this._executorService = aExecutorService != null ? aExecutorService : ControlFlowUtility.createCachedExecutorService(true);
        this.initMedaTypeFactories();
    }

    public AbstractRestfulClient() {
        this(ControlFlowUtility.createCachedExecutorService(true));
    }

    protected void initMedaTypeFactories() {
        this.addMediaTypeFactory(new JsonMediaTypeFactory());
        this.addMediaTypeFactory(new XmlMediaTypeFactory());
        this.addMediaTypeFactory(new FormMediaTypeFactory());
        this.addMediaTypeFactory(new TextMediaTypeFactory());
        this.addMediaTypeFactory(new HtmlMediaTypeFactory());
    }

    @Override
    public BasicAuthCredentials getBasicAuthCredentials() {
        return this._basicAuthCredentials;
    }

    @Override
    public void setBasicAuthCredentials(BasicAuthCredentials aBasicAuthCredentials) {
        this._basicAuthCredentials = aBasicAuthCredentials;
    }

    @Override
    public void setOauthToken(OauthToken aOauthToken) {
        this._oauthToken = aOauthToken;
    }

    @Override
    public OauthToken getOauthToken() {
        return this._oauthToken;
    }

    @Override
    public RestResponse doRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth) throws HttpResponseException {
        RestRequestHandler theHandler = this._requestHandler;
        if (theHandler == null) {
            throw new IllegalStateException("Unable to process your request with HTTP-Method <" + aHttpMethod + "> for locator <" + aUrl.toLocator() + "> and query fields <" + new VerboseTextBuilder().withElements(aUrl.getQueryFields()).toString() + "> as no <" + RestRequestHandler.class.getSimpleName() + "> has been registered via <doRestRequest(...)>, aborting!");
        }
        aHeaderFields = this.preProcessHeaderFields(aHeaderFields);
        return theHandler.doRequest(new HttpClientRequest(aHttpMethod, aUrl, aHeaderFields, aRequest, aRedirectDepth, this));
    }

    @Override
    public RestResponseHandler onResponse(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth, RestResponseConsumer aResponseConsumer) {
        aHeaderFields = this.preProcessHeaderFields(aHeaderFields);
        RestResponseHandler theResponseHandler = new RestResponseHandler(aHttpMethod, aUrl, aHeaderFields, aRequest, aRedirectDepth, aResponseConsumer, this);
        this._executorService.execute(new RestResponseHandler.RestResponseHandlerDaemon(theResponseHandler, this._requestHandler, this));
        return theResponseHandler;
    }

    @Override
    public RestResponseResult onResponse(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth) {
        aHeaderFields = this.preProcessHeaderFields(aHeaderFields);
        RestResponseResult theResponseResult = new RestResponseResult(aHttpMethod, aUrl, aHeaderFields, aRequest, aRedirectDepth, this);
        this._executorService.execute(new RestResponseResult.RestResponseResultDaemon(theResponseResult, this._requestHandler, this));
        return theResponseResult;
    }

    @Override
    public RestRequestBuilder buildRequest(HttpMethod aHttpMethod, Url aUrl, RequestHeaderFields aHeaderFields, Object aRequest, int aRedirectDepth) {
        aHeaderFields = this.preProcessHeaderFields(aHeaderFields);
        return new RestRequestBuilder(aHttpMethod, aUrl, aHeaderFields, aRequest, aRedirectDepth, this);
    }

    @Override
    public synchronized boolean addMediaTypeFactory(MediaTypeFactory aMediaTypeFactory) {
        boolean hasAddedAny = false;
        for (MediaType eMediaType : aMediaTypeFactory.getMediaTypes()) {
            if (this._mediaTypeFacotries.containsKey(eMediaType)) continue;
            this._mediaTypeFacotries.put(eMediaType, aMediaTypeFactory);
            hasAddedAny = true;
        }
        return hasAddedAny;
    }

    @Override
    public MediaTypeFactory toMediaTypeFactory(MediaType aMediaType) {
        return this._mediaTypeFacotries.get(aMediaType);
    }

    @Override
    public MediaType[] getFactoryMediaTypes() {
        return this._mediaTypeFacotries.keySet().toArray(new MediaType[this._mediaTypeFacotries.size()]);
    }

    @Override
    public String getUserAgent() {
        return this._userAgent;
    }

    @Override
    public void setUserAgent(String aUserAgent) {
        this._userAgent = aUserAgent;
    }

    protected void preIntercept(HttpClientRequest aRequest, HttpClientResponse aResponse) {
    }

    protected void postIntercept(HttpClientRequest aRequest, HttpClientResponse aResponse) {
    }

    protected void onRestRequest(RestRequestHandler aHandler) {
        this._requestHandler = aHandler;
    }

    protected RequestHeaderFields preProcessHeaderFields(RequestHeaderFields aHeaderFields) {
        if (this._userAgent != null && (aHeaderFields == null || aHeaderFields.getUserAgent() == null)) {
            aHeaderFields = aHeaderFields != null ? aHeaderFields : new RequestHeaderFields();
            aHeaderFields.putUserAgent(this._userAgent);
        }
        if (this._oauthToken != null && (aHeaderFields == null || aHeaderFields.getAuthorization() == null)) {
            aHeaderFields = aHeaderFields != null ? aHeaderFields : new RequestHeaderFields();
            aHeaderFields.putAuthorization(AuthType.BEARER, this._oauthToken.getAccessToken());
        }
        if (this._basicAuthCredentials != null && (aHeaderFields == null || aHeaderFields.getBasicAuthCredentials() == null)) {
            aHeaderFields = aHeaderFields != null ? aHeaderFields : new RequestHeaderFields();
            aHeaderFields.putBasicAuthCredentials(this._basicAuthCredentials);
        }
        return aHeaderFields;
    }
}

