/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties.ext.obfuscation;

import org.refcodes.exception.BugException;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ext.obfuscation.AbstractObfuscationPropertiesBuilderDecorator;
import org.refcodes.runtime.SystemContext;
import org.refcodes.security.DecryptionException;
import org.refcodes.security.EncryptionException;
import org.refcodes.security.alt.chaos.ChaosKey;
import org.refcodes.security.alt.chaos.ChaosTextDecrypter;
import org.refcodes.security.alt.chaos.ChaosTextEncrypter;
import org.refcodes.textual.SecretHintBuilder;

public class ObfuscationPropertiesBuilderDecorator
extends AbstractObfuscationPropertiesBuilderDecorator {
    private ChaosKey _chaosKey;

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties) {
        this(aProperties, SystemContext.HOST.toContextString());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aDecryptPrefix, String aEncryptPrefix) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, SystemContext.HOST.toContextString());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aDecryptPrefix, String aEncryptPrefix, SystemContext aObfuscationMode) {
        this(aProperties, aDecryptPrefix, aEncryptPrefix, aObfuscationMode.toContextString());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aDecryptPrefix, String aEncryptPrefix, String aSecret) {
        super(aProperties);
        this._chaosKey = new ChaosKey(aSecret);
        this._decryptPrefix = aDecryptPrefix;
        this._encryptPrefix = aEncryptPrefix;
        this.encryptAll();
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, SystemContext aObfuscationMode) {
        this(aProperties, aObfuscationMode.toContextString());
    }

    public ObfuscationPropertiesBuilderDecorator(Properties.PropertiesBuilder aProperties, String aSecret) {
        super(aProperties);
        this._chaosKey = new ChaosKey(aSecret);
        this.encryptAll();
    }

    @Override
    String toEncrypted(String aValue) {
        try {
            return new ChaosTextEncrypter(this._chaosKey).toEncrypted(aValue);
        }
        catch (EncryptionException e) {
            throw new BugException("Encountered a bug while encrypting value <" + SecretHintBuilder.asString(aValue) + "> with <" + SystemContext.HOST_USER_APPLICATION_SESSION + "> system context!", e);
        }
    }

    @Override
    String toDecrypted(String aValue) {
        try {
            return new ChaosTextDecrypter(this._chaosKey).toDecrypted(aValue);
        }
        catch (DecryptionException e) {
            throw new BugException("Encountered a bug while decrypting value <" + SecretHintBuilder.asString(aValue) + "> with <" + SystemContext.HOST_USER_APPLICATION_SESSION + "> system context!", e);
        }
    }
}

