/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.Map;
import org.refcodes.data.FilenameExtension;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.properties.AbstractResourcePropertiesBuilder;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.SystemProperty;
import org.refcodes.struct.CanonicalMap;
import org.refcodes.struct.CanonicalMapBuilderImpl;
import org.refcodes.struct.ext.factory.CanonicalMapFactory;
import org.refcodes.struct.ext.factory.XmlCanonicalMapFactory;

public class XmlPropertiesBuilder
extends AbstractResourcePropertiesBuilder {
    private static final long serialVersionUID = 1L;

    public XmlPropertiesBuilder() {
        this(false);
    }

    public XmlPropertiesBuilder(boolean isXmlRootPreserve) {
        super(isXmlRootPreserve);
    }

    public XmlPropertiesBuilder(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        this(aResourceClass, aFilePath, false);
    }

    public XmlPropertiesBuilder(Class<?> aResourceClass, String aFilePath, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.loadFrom(aResourceClass, aFilePath);
    }

    public XmlPropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this(aResourceClass, aFilePath, aConfigLocator, false);
    }

    public XmlPropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.seekFrom(aResourceClass, aFilePath, aConfigLocator);
    }

    public XmlPropertiesBuilder(File aFile) throws IOException, ParseException {
        this(aFile, false);
    }

    public XmlPropertiesBuilder(File aFile, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.loadFrom(aFile);
    }

    public XmlPropertiesBuilder(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this(aFile, aConfigLocator, false);
    }

    public XmlPropertiesBuilder(File aFile, ConfigLocator aConfigLocator, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.seekFrom(aFile, aConfigLocator);
    }

    public XmlPropertiesBuilder(InputStream aInputStream) throws IOException, ParseException {
        this(aInputStream, false);
    }

    public XmlPropertiesBuilder(InputStream aInputStream, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.loadFrom(aInputStream);
    }

    public XmlPropertiesBuilder(Map<?, ?> aProperties) {
        this(aProperties, false);
    }

    public XmlPropertiesBuilder(Map<?, ?> aProperties, boolean isXmlRootPreserve) {
        super(aProperties, isXmlRootPreserve);
    }

    public XmlPropertiesBuilder(Object aObj) {
        this(aObj, false);
    }

    public XmlPropertiesBuilder(Object aObj, boolean isXmlRootPreserve) {
        super(aObj, isXmlRootPreserve);
    }

    public XmlPropertiesBuilder(Properties aProperties) {
        this(aProperties, false);
    }

    public XmlPropertiesBuilder(Properties aProperties, boolean isXmlRootPreserve) {
        super(aProperties, isXmlRootPreserve);
    }

    public XmlPropertiesBuilder(Properties.PropertiesBuilder aProperties) {
        this(aProperties, false);
    }

    public XmlPropertiesBuilder(Properties.PropertiesBuilder aProperties, boolean isXmlRootPreserve) {
        super(aProperties, isXmlRootPreserve);
    }

    public XmlPropertiesBuilder(String aFilePath) throws IOException, ParseException {
        this(aFilePath, false);
    }

    public XmlPropertiesBuilder(String aFilePath, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.loadFrom(aFilePath);
    }

    public XmlPropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this(aFilePath, aConfigLocator, false);
    }

    public XmlPropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.seekFrom(aFilePath, aConfigLocator);
    }

    public XmlPropertiesBuilder(URL aUrl) throws IOException, ParseException {
        this(aUrl, false);
    }

    public XmlPropertiesBuilder(URL aUrl, boolean isXmlRootPreserve) throws IOException, ParseException {
        this(isXmlRootPreserve);
        this.loadFrom(aUrl);
    }

    @Override
    protected CanonicalMapFactory createCanonicalMapFactory() {
        return new XmlCanonicalMapFactory(){

            @Override
            public CanonicalMap.CanonicalMapBuilder fromMarshaled(InputStream aExternalRepresentation, Map<String, String> aProperties) throws UnmarshalException {
                boolean isXmlRootPreserve = SystemProperty.DOCUMENT_ROOT_PRESERVE.isEnabled() || Boolean.valueOf(aProperties.get(CanonicalMapFactory.DOCUMENT_ROOT_PRESERVE_PROPERTY)) != false;
                CanonicalMap.CanonicalMapBuilder theCanonicalMap = super.fromMarshaled(aExternalRepresentation, aProperties);
                if (!isXmlRootPreserve && theCanonicalMap.leaves().size() == 0 && theCanonicalMap.dirs().size() == 1) {
                    theCanonicalMap = new CanonicalMapBuilderImpl(theCanonicalMap.retrieveFrom(theCanonicalMap.dirs().iterator().next()));
                }
                return theCanonicalMap;
            }
        };
    }

    public static class XmlPropertiesBuilderFactory
    implements ResourcePropertiesFactory.ResourcePropertiesBuilderFactory {
        private final boolean _isXmlRootPreserve;

        public XmlPropertiesBuilderFactory() {
            this(false);
        }

        public XmlPropertiesBuilderFactory(boolean isXmlRootPreserve) {
            this._isXmlRootPreserve = isXmlRootPreserve;
        }

        @Override
        public String[] getFilenameSuffixes() {
            return new String[]{FilenameExtension.XML.getFilenameSuffix()};
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return new XmlPropertiesBuilder(aResourceClass, aFilePath, aConfigLocator, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return new XmlPropertiesBuilder(aFile, aConfigLocator, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(InputStream aInputStream) throws IOException, ParseException {
            return new XmlPropertiesBuilder(aInputStream, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Map<?, ?> aProperties) {
            return new XmlPropertiesBuilder(aProperties, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Object aObj) {
            return new XmlPropertiesBuilder(aObj, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Properties aProperties) {
            return new XmlPropertiesBuilder(aProperties, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Properties.PropertiesBuilder aProperties) {
            return new XmlPropertiesBuilder(aProperties, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return new XmlPropertiesBuilder(aFilePath, aConfigLocator, this._isXmlRootPreserve);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(URL aUrl) throws IOException, ParseException {
            return new XmlPropertiesBuilder(aUrl, this._isXmlRootPreserve);
        }
    }
}

