/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.refcodes.data.Delimiters;
import org.refcodes.properties.AbstractResourcePropertiesBuilderDecorator;
import org.refcodes.properties.JavaPropertiesBuilder;
import org.refcodes.properties.JsonPropertiesBuilder;
import org.refcodes.properties.PolyglotProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ReloadMode;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.properties.TomlPropertiesBuilder;
import org.refcodes.properties.XmlPropertiesBuilder;
import org.refcodes.properties.YamlPropertiesBuilder;
import org.refcodes.runtime.ConfigLocator;

public class PolyglotPropertiesBuilder
extends AbstractResourcePropertiesBuilderDecorator<ResourceProperties.ResourcePropertiesBuilder> {
    private final char[] _delimiters;
    private final boolean _isDocumentRootPreserve;

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties((Class)aResourceClass, aFilePath));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties((Class)aResourceClass, aFilePath));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties((Class)aResourceClass, aFilePath));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties((Class)aResourceClass, aFilePath));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties((Class)aResourceClass, aFilePath, aConfigLocator));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties((Class)aResourceClass, aFilePath, aConfigLocator));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties((Class)aResourceClass, aFilePath, aConfigLocator));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties((Class)aResourceClass, aFilePath, aConfigLocator));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(File aFile) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aFile));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(File aFile, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aFile));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(File aFile, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFile));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(File aFile, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties(aFile));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aFile, aConfigLocator));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(File aFile, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aFile, aConfigLocator));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(File aFile, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFile, aConfigLocator));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(File aFile, ConfigLocator aConfigLocator, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties(aFile, aConfigLocator));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(InputStream aInputStream) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aInputStream));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(InputStream aInputStream, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aInputStream));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(InputStream aInputStream, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties(aInputStream));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(InputStream aInputStream, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties(aInputStream));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Map<?, ?> aMap) {
        super(new PolyglotPropertiesBuilderFactory().toProperties((Map)aMap));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Map<?, ?> aMap, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties((Map)aMap));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Map<?, ?> aMap, boolean isDocumentRootPreserve, char ... aDelimiters) {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties((Map)aMap));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Map<?, ?> aMap, char ... aDelimiters) {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties((Map)aMap));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Object aObj) {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aObj));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Object aObj, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aObj));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Object aObj, boolean isDocumentRootPreserve, char ... aDelimiters) {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties(aObj));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Object aObj, char ... aDelimiters) {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties(aObj));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Properties aProperties) {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aProperties));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Properties aProperties, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aProperties));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(Properties.PropertiesBuilder aPropertiesBuilder) {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aPropertiesBuilder));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(Properties.PropertiesBuilder aPropertiesBuilder, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aPropertiesBuilder));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aFilePath));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(String aFilePath, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aFilePath));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(String aFilePath, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFilePath));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(String aFilePath, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties(aFilePath));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aFilePath, aConfigLocator));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aFilePath, aConfigLocator));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFilePath, aConfigLocator));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(String aFilePath, ConfigLocator aConfigLocator, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties(aFilePath, aConfigLocator));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(URL aUrl) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory().toProperties(aUrl));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = false;
    }

    public PolyglotPropertiesBuilder(URL aUrl, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve).toProperties(aUrl));
        this._delimiters = Delimiters.PROPERTIES.getChars();
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(URL aUrl, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(isDocumentRootPreserve, aDelimiters).toProperties(aUrl));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = isDocumentRootPreserve;
    }

    public PolyglotPropertiesBuilder(URL aUrl, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesBuilderFactory(aDelimiters).toProperties(aUrl));
        this._delimiters = aDelimiters;
        this._isDocumentRootPreserve = false;
    }

    @Override
    public Properties loadFrom(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aResourceClass, aFilePath, this._isDocumentRootPreserve, this._delimiters);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(File aFile) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aFile, this._isDocumentRootPreserve, this._delimiters);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(InputStream aInputStream) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aInputStream, this._isDocumentRootPreserve, this._delimiters);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(String aFilePath) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aFilePath, this._delimiters);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties loadFrom(URL aUrl) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aUrl, this._delimiters);
        this.insert(theProperties);
        return theProperties;
    }

    @Override
    public Properties reload() throws IOException, ParseException {
        return super.reload();
    }

    @Override
    public Properties reload(ReloadMode aReloadMode) throws IOException, ParseException {
        return super.reload(aReloadMode);
    }

    @Override
    public Properties seekFrom(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        PolyglotProperties theProperties = new PolyglotProperties(aResourceClass, aFilePath, aConfigLocator, this._delimiters);
        this.insert(theProperties);
        return theProperties;
    }

    public static class PolyglotPropertiesBuilderFactory
    implements ResourcePropertiesFactory.ResourcePropertiesBuilderFactory {
        private final List<ResourcePropertiesFactory.ResourcePropertiesBuilderFactory> _factories = new ArrayList<ResourcePropertiesFactory.ResourcePropertiesBuilderFactory>();

        public PolyglotPropertiesBuilderFactory() {
            this(false, Delimiters.PROPERTIES.getChars());
        }

        public PolyglotPropertiesBuilderFactory(boolean isDocumentRootPreserve) {
            this(isDocumentRootPreserve, Delimiters.PROPERTIES.getChars());
        }

        public PolyglotPropertiesBuilderFactory(boolean isDocumentRootPreserve, char ... aDelimiters) {
            this._factories.add(new TomlPropertiesBuilder.TomlPropertiesBuilderFactory(aDelimiters));
            this._factories.add(new YamlPropertiesBuilder.YamlPropertiesBuilderFactory());
            this._factories.add(new XmlPropertiesBuilder.XmlPropertiesBuilderFactory(isDocumentRootPreserve));
            this._factories.add(new JsonPropertiesBuilder.JsonPropertiesBuilderFactory());
            this._factories.add(new JavaPropertiesBuilder.JavaPropertiesBuilderFactory(aDelimiters));
        }

        public PolyglotPropertiesBuilderFactory(char ... aDelimiters) {
            this(false, aDelimiters);
        }

        public PolyglotPropertiesBuilderFactory(ResourcePropertiesFactory.ResourcePropertiesBuilderFactory ... aFactories) {
            for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : aFactories) {
                this._factories.add(eFactory);
            }
        }

        @Override
        public String[] getFilenameSuffixes() {
            ArrayList<String> theExtensions = new ArrayList<String>();
            for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory _factorie : this._factories) {
                String[] eExtensions = _factorie.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    theExtensions.add(eExtension);
                }
            }
            return theExtensions.toArray(new String[theExtensions.size()]);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFilePath, aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties((Class)aResourceClass, aFilePath, aConfigLocator);
                    }
                    catch (ParseException e2) {
                        if (eFactory.hasFilenameSuffix(aFilePath)) {
                            throw new ParseException("Error parsing file <" + aFilePath + "> at offset <" + e2.getErrorOffset() + ">!", e2.getErrorOffset());
                        }
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                    catch (Exception e3) {
                        if (theCause != null) continue;
                        theCause = e3;
                    }
                }
                for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        String eFilePath = aFilePath + eExtension;
                        try {
                            return eFactory.toProperties(eFilePath, aConfigLocator);
                        }
                        catch (ParseException e4) {
                            if (eFactory.hasFilenameSuffix(eFilePath)) {
                                throw new ParseException("Error parsing file <" + eFilePath + "> at offset <" + e4.getErrorOffset() + ">!", e4.getErrorOffset());
                            }
                            if (theCause != null) continue;
                            theCause = e4;
                        }
                        catch (Exception e5) {
                            if (theCause != null) continue;
                            theCause = e5;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with name scheme <" + aFilePath + ".*> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
            }
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFile.getPath(), aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties(aFile, aConfigLocator);
                    }
                    catch (Exception e2) {
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                }
                for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        File eFile = new File(aFile.getAbsolutePath() + eExtension);
                        try {
                            return eFactory.toProperties(eFile, aConfigLocator);
                        }
                        catch (Exception e3) {
                            if (theCause != null) continue;
                            theCause = e3;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with (base) file <" + aFile.getPath() + "> found!");
            }
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(InputStream aInputStream) throws IOException, ParseException {
            Exception theCause = null;
            byte[] theBytes = PolyglotPropertiesBuilderFactory.toByteArray(aInputStream);
            for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(new ByteArrayInputStream(theBytes));
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file for the given InputStream found!");
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Map<?, ?> aPropertiesBuilder) {
            return this._factories.get(0).toProperties((Map)aPropertiesBuilder);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Object aObj) {
            return this._factories.get(0).toProperties(aObj);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Properties aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(Properties.PropertiesBuilder aPropertiesBuilder) {
            return this._factories.get(0).toProperties(aPropertiesBuilder);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return this.toProperties((Class)null, aFilePath, aConfigLocator);
        }

        @Override
        public ResourceProperties.ResourcePropertiesBuilder toProperties(URL aUrl) throws IOException, ParseException {
            Exception theCause;
            block12: {
                theCause = null;
                try {
                    ResourcePropertiesFactory.ResourcePropertiesBuilderFactory theFactory = this.fromFilenameExtension(aUrl.toExternalForm());
                    if (theFactory != null) {
                        return theFactory.toProperties(aUrl);
                    }
                }
                catch (Exception e) {
                    if (theCause != null) break block12;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(aUrl);
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    URL eUrl = new URL(aUrl.toExternalForm() + eExtension);
                    try {
                        return eFactory.toProperties(eUrl);
                    }
                    catch (Exception e) {
                        if (theCause != null) continue;
                        theCause = e;
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with (base) URL <" + aUrl.toExternalForm() + "> found!");
        }

        private ResourcePropertiesFactory.ResourcePropertiesBuilderFactory fromFilenameExtension(String aFilePath) {
            for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    if (!aFilePath.toLowerCase().endsWith(eExtension.toLowerCase())) continue;
                    return eFactory;
                }
            }
            return null;
        }

        private ResourceProperties.ResourcePropertiesBuilder toPropertiesFromFilePath(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause;
            block24: {
                theCause = null;
                File theFile = new File(aFilePath);
                if (theFile.exists()) {
                    ResourcePropertiesFactory.ResourcePropertiesBuilderFactory theFactory = this.fromFilenameExtension(theFile.getAbsolutePath());
                    try {
                        if (theFactory != null) {
                            return theFactory.toProperties(theFile, ConfigLocator.ABSOLUTE);
                        }
                    }
                    catch (ParseException e) {
                        if (theFactory.hasFilenameSuffix(theFile)) {
                            throw new ParseException("Error parsing file <" + theFile.getAbsolutePath() + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset());
                        }
                        if (theCause == null) {
                            theCause = e;
                        }
                    }
                    catch (Exception e) {
                        if (theCause != null) break block24;
                        theCause = e;
                    }
                } else {
                    File eFile;
                    for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                        String[] stringArray = eFactory.getFilenameSuffixes();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String eExtension = stringArray[i];
                            eFile = new File(aFilePath + eExtension);
                            if (!eFile.exists()) continue;
                            try {
                                return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                            }
                            catch (ParseException e) {
                                if (eFactory.hasFilenameSuffix(eFile)) {
                                    throw new ParseException("Error parsing file <" + eFile.getAbsolutePath() + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset());
                                }
                                if (theCause != null) continue;
                                theCause = e;
                                continue;
                            }
                            catch (Exception e) {
                                if (theCause != null) continue;
                                theCause = e;
                            }
                        }
                    }
                    if (aConfigLocator != null && aConfigLocator != ConfigLocator.ABSOLUTE) {
                        File[] theFolders;
                        for (File eDir : theFolders = aConfigLocator.getFolders()) {
                            for (ResourcePropertiesFactory.ResourcePropertiesBuilderFactory eFactory : this._factories) {
                                for (String eExtension : eFactory.getFilenameSuffixes()) {
                                    eFile = new File(eDir, aFilePath + eExtension);
                                    if (!eFile.exists()) continue;
                                    try {
                                        return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                                    }
                                    catch (ParseException e) {
                                        if (eFactory.hasFilenameSuffix(eFile)) {
                                            throw new ParseException("Error parsing file <" + eFile.getAbsolutePath() + "> at offset <" + e.getErrorOffset() + ">!", e.getErrorOffset());
                                        }
                                        if (theCause != null) continue;
                                        theCause = e;
                                    }
                                    catch (Exception e) {
                                        if (theCause != null) continue;
                                        theCause = e;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with name (scheme) <" + aFilePath + "> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
        }

        public static byte[] toByteArray(InputStream aInputStream) throws IOException {
            int eRead;
            ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
            byte[] theData = new byte[16384];
            while ((eRead = aInputStream.read(theData, 0, theData.length)) != -1) {
                theBuffer.write(theData, 0, eRead);
            }
            theBuffer.flush();
            return theBuffer.toByteArray();
        }
    }
}

