/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.refcodes.data.Delimiters;
import org.refcodes.properties.AbstractResourcePropertiesDecorator;
import org.refcodes.properties.JavaProperties;
import org.refcodes.properties.JsonProperties;
import org.refcodes.properties.Properties;
import org.refcodes.properties.ResourceProperties;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.properties.TomlProperties;
import org.refcodes.properties.XmlProperties;
import org.refcodes.properties.YamlProperties;
import org.refcodes.runtime.ConfigLocator;

public class PolyglotProperties
extends AbstractResourcePropertiesDecorator<ResourceProperties> {
    public PolyglotProperties(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aResourceClass, aFilePath));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aResourceClass, aFilePath));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aResourceClass, aFilePath));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aResourceClass, aFilePath));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aResourceClass, aFilePath, aConfigLocator));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aResourceClass, aFilePath, aConfigLocator));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aResourceClass, aFilePath, aConfigLocator));
    }

    public PolyglotProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aResourceClass, aFilePath, aConfigLocator));
    }

    public PolyglotProperties(File aFile) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFile));
    }

    public PolyglotProperties(File aFile, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aFile));
    }

    public PolyglotProperties(File aFile, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFile));
    }

    public PolyglotProperties(File aFile, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aFile));
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFile, aConfigLocator));
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aFile, aConfigLocator));
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFile, aConfigLocator));
    }

    public PolyglotProperties(File aFile, ConfigLocator aConfigLocator, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aFile, aConfigLocator));
    }

    public PolyglotProperties(InputStream aInputStream) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aInputStream));
    }

    public PolyglotProperties(InputStream aInputStream, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aInputStream));
    }

    public PolyglotProperties(InputStream aInputStream, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aInputStream));
    }

    public PolyglotProperties(InputStream aInputStream, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aInputStream));
    }

    public PolyglotProperties(Map<?, ?> aMap) {
        super(new PolyglotPropertiesFactory().toProperties(aMap));
    }

    public PolyglotProperties(Map<?, ?> aMap, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aMap));
    }

    public PolyglotProperties(Map<?, ?> aMap, boolean isDocumentRootPreserve, char ... aDelimiters) {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aMap));
    }

    public PolyglotProperties(Map<?, ?> aMap, char ... aDelimiters) {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aMap));
    }

    public PolyglotProperties(Object aObj) {
        super(new PolyglotPropertiesFactory().toProperties(aObj));
    }

    public PolyglotProperties(Object aObj, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aObj));
    }

    public PolyglotProperties(Object aObj, boolean isDocumentRootPreserve, char ... aDelimiters) {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aObj));
    }

    public PolyglotProperties(Object aObj, char ... aDelimiters) {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aObj));
    }

    public PolyglotProperties(Properties aProperties) {
        super(new PolyglotPropertiesFactory().toProperties(aProperties));
    }

    public PolyglotProperties(Properties aProperties, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aProperties));
    }

    public PolyglotProperties(Properties.PropertiesBuilder aPropertiesBuilder) {
        super(new PolyglotPropertiesFactory().toProperties(aPropertiesBuilder));
    }

    public PolyglotProperties(Properties.PropertiesBuilder aPropertiesBuilder, boolean isDocumentRootPreserve) {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aPropertiesBuilder));
    }

    public PolyglotProperties(String aFilePath) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFilePath));
    }

    public PolyglotProperties(String aFilePath, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aFilePath));
    }

    public PolyglotProperties(String aFilePath, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFilePath));
    }

    public PolyglotProperties(String aFilePath, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aFilePath));
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aFilePath, aConfigLocator));
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aFilePath, aConfigLocator));
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aFilePath, aConfigLocator));
    }

    public PolyglotProperties(String aFilePath, ConfigLocator aConfigLocator, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aFilePath, aConfigLocator));
    }

    public PolyglotProperties(URL aUrl) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory().toProperties(aUrl));
    }

    public PolyglotProperties(URL aUrl, boolean isDocumentRootPreserve) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve).toProperties(aUrl));
    }

    public PolyglotProperties(URL aUrl, boolean isDocumentRootPreserve, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(isDocumentRootPreserve, aDelimiters).toProperties(aUrl));
    }

    public PolyglotProperties(URL aUrl, char ... aDelimiters) throws IOException, ParseException {
        super(new PolyglotPropertiesFactory(aDelimiters).toProperties(aUrl));
    }

    public static class PolyglotPropertiesFactory
    implements ResourcePropertiesFactory {
        private final List<ResourcePropertiesFactory> _factories = new ArrayList<ResourcePropertiesFactory>();

        public PolyglotPropertiesFactory() {
            this(false, Delimiters.PROPERTIES.getChars());
        }

        public PolyglotPropertiesFactory(boolean isDocumentRootPreserve) {
            this(isDocumentRootPreserve, Delimiters.PROPERTIES.getChars());
        }

        public PolyglotPropertiesFactory(boolean isDocumentRootPreserve, char ... aDelimiters) {
            this._factories.add(new TomlProperties.TomlPropertiesFactory(aDelimiters));
            this._factories.add(new YamlProperties.YamlPropertiesFactory());
            this._factories.add(new XmlProperties.XmlPropertiesFactory(isDocumentRootPreserve));
            this._factories.add(new JsonProperties.JsonPropertiesFactory());
            this._factories.add(new JavaProperties.JavaPropertiesFactory(aDelimiters));
        }

        public PolyglotPropertiesFactory(char ... aDelimiters) {
            this(false, aDelimiters);
        }

        public PolyglotPropertiesFactory(ResourcePropertiesFactory ... aFactories) {
            for (ResourcePropertiesFactory eFactory : aFactories) {
                this._factories.add(eFactory);
            }
        }

        @Override
        public String[] getFilenameSuffixes() {
            ArrayList<String> theExtensions = new ArrayList<String>();
            for (ResourcePropertiesFactory _factorie : this._factories) {
                String[] eExtensions = _factorie.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    theExtensions.add(eExtension);
                }
            }
            return theExtensions.toArray(new String[theExtensions.size()]);
        }

        @Override
        public ResourceProperties toProperties(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFilePath, aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties(aResourceClass, aFilePath, aConfigLocator);
                    }
                    catch (Exception e2) {
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        try {
                            return eFactory.toProperties(aResourceClass, aFilePath + eExtension, aConfigLocator);
                        }
                        catch (Exception e3) {
                            if (theCause != null) continue;
                            theCause = e3;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with name (scheme) <" + aFilePath + "> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
            }
        }

        @Override
        public ResourceProperties toProperties(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause = null;
            try {
                return this.toPropertiesFromFilePath(aFile.getPath(), aConfigLocator);
            }
            catch (Exception e) {
                if (theCause == null) {
                    theCause = e;
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    try {
                        return eFactory.toProperties(aFile, aConfigLocator);
                    }
                    catch (Exception e2) {
                        if (theCause != null) continue;
                        theCause = e2;
                    }
                }
                for (ResourcePropertiesFactory eFactory : this._factories) {
                    String[] eExtensions = eFactory.getFilenameSuffixes();
                    if (eExtensions == null) continue;
                    for (String eExtension : eExtensions) {
                        File eFile = new File(aFile.getAbsolutePath() + eExtension);
                        try {
                            return eFactory.toProperties(eFile, aConfigLocator);
                        }
                        catch (Exception e3) {
                            if (theCause != null) continue;
                            theCause = e3;
                        }
                    }
                }
                if (theCause instanceof IOException) {
                    throw (IOException)theCause;
                }
                if (theCause instanceof ParseException) {
                    throw (ParseException)theCause;
                }
                throw new IOException("No configuration file with name (scheme) <" + aFile.toPath() + "> found, where a suffix (if applicable) might by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
            }
        }

        @Override
        public ResourceProperties toProperties(InputStream aInputStream) throws IOException, ParseException {
            Exception theCause = null;
            byte[] theBytes = PolyglotPropertiesFactory.toByteArray(aInputStream);
            for (ResourcePropertiesFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(new ByteArrayInputStream(theBytes));
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file for the given InputStream found!");
        }

        @Override
        public ResourceProperties toProperties(Map<?, ?> aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(Object aObj) {
            return this._factories.get(0).toProperties(aObj);
        }

        @Override
        public ResourceProperties toProperties(Properties aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(Properties.PropertiesBuilder aProperties) {
            return this._factories.get(0).toProperties(aProperties);
        }

        @Override
        public ResourceProperties toProperties(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            return this.toProperties(null, aFilePath, aConfigLocator);
        }

        @Override
        public ResourceProperties toProperties(URL aUrl) throws IOException, ParseException {
            Exception theCause;
            block12: {
                theCause = null;
                try {
                    ResourcePropertiesFactory theFactory = this.fromFilenameExtension(aUrl.toExternalForm());
                    if (theFactory != null) {
                        return theFactory.toProperties(aUrl);
                    }
                }
                catch (Exception e) {
                    if (theCause != null) break block12;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory eFactory : this._factories) {
                try {
                    return eFactory.toProperties(aUrl);
                }
                catch (Exception e) {
                    if (theCause != null) continue;
                    theCause = e;
                }
            }
            for (ResourcePropertiesFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    URL eUrl = new URL(aUrl.toExternalForm() + eExtension);
                    try {
                        return eFactory.toProperties(eUrl);
                    }
                    catch (Exception e) {
                        if (theCause != null) continue;
                        theCause = e;
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with (base) URL <" + aUrl.toExternalForm() + "> found!");
        }

        private ResourcePropertiesFactory fromFilenameExtension(String aFilePath) {
            for (ResourcePropertiesFactory eFactory : this._factories) {
                String[] eExtensions = eFactory.getFilenameSuffixes();
                if (eExtensions == null) continue;
                for (String eExtension : eExtensions) {
                    if (!aFilePath.endsWith(eExtension)) continue;
                    return eFactory;
                }
            }
            return null;
        }

        private ResourceProperties toPropertiesFromFilePath(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
            Exception theCause;
            block17: {
                theCause = null;
                File theFile = new File(aFilePath);
                if (theFile.exists()) {
                    try {
                        ResourcePropertiesFactory theFactory = this.fromFilenameExtension(theFile.getAbsolutePath());
                        if (theFactory != null) {
                            return theFactory.toProperties(theFile, ConfigLocator.ABSOLUTE);
                        }
                    }
                    catch (IOException | ParseException e) {
                        if (theCause != null) break block17;
                        theCause = e;
                    }
                } else {
                    File eFile;
                    for (ResourcePropertiesFactory eFactory : this._factories) {
                        for (String eExtension : eFactory.getFilenameSuffixes()) {
                            eFile = new File(aFilePath + eExtension);
                            if (!eFile.exists()) continue;
                            try {
                                return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                            }
                            catch (IOException | ParseException e) {
                                if (theCause != null) continue;
                                theCause = e;
                            }
                        }
                    }
                    if (aConfigLocator != null && aConfigLocator != ConfigLocator.ABSOLUTE) {
                        for (File eDir : aConfigLocator.getFolders()) {
                            for (ResourcePropertiesFactory eFactory : this._factories) {
                                for (String eExtension : eFactory.getFilenameSuffixes()) {
                                    eFile = new File(eDir, aFilePath + eExtension);
                                    if (!eFile.exists()) continue;
                                    try {
                                        return eFactory.toProperties(eFile, ConfigLocator.ABSOLUTE);
                                    }
                                    catch (IOException | ParseException e) {
                                        if (theCause != null) continue;
                                        theCause = e;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (theCause instanceof IOException) {
                throw (IOException)theCause;
            }
            if (theCause instanceof ParseException) {
                throw (ParseException)theCause;
            }
            throw new IOException("No configuration file with name (scheme) <" + aFilePath + "> found, where the suffix may by one of the following: " + Arrays.toString(this.getFilenameSuffixes()));
        }

        public static byte[] toByteArray(InputStream aInputStream) throws IOException {
            int eRead;
            ByteArrayOutputStream theBuffer = new ByteArrayOutputStream();
            byte[] theData = new byte[16384];
            while ((eRead = aInputStream.read(theData, 0, theData.length)) != -1) {
                theBuffer.write(theData, 0, eRead);
            }
            theBuffer.flush();
            return theBuffer.toByteArray();
        }
    }
}

