/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.properties;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.refcodes.data.Delimiter;
import org.refcodes.properties.AbstractPropertiesDecorator;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesImpl;
import org.refcodes.struct.AmbiguousKeyRuntimeException;

public class NormalizedPropertiesDecorator
extends AbstractPropertiesDecorator<Properties> {
    private final char[] _delimiters;

    public NormalizedPropertiesDecorator(Properties aProperties) {
        super(aProperties);
        this._delimiters = new char[]{Delimiter.NAMESPACE.getChar()};
    }

    public NormalizedPropertiesDecorator(Properties aProperties, char[] aDelimiters) {
        super(aProperties);
        this._delimiters = aDelimiters;
    }

    @Override
    public boolean containsKey(Object aKey) {
        boolean isContainsKey = super.containsKey(aKey);
        if (aKey != null) {
            String theKey = aKey.toString();
            Object theDelimiters = "";
            for (char eDelimiter : this._delimiters) {
                if (((String)theDelimiters).length() > 0) {
                    theDelimiters = (String)theDelimiters + ", ";
                }
                theDelimiters = (String)theDelimiters + "'" + eDelimiter + "'";
                String eKey = NormalizedPropertiesDecorator.fromNormalized(theKey, this.getDelimiter(), eDelimiter);
                if (super.containsKey((Object)eKey)) {
                    if (isContainsKey) {
                        throw new AmbiguousKeyRuntimeException("There are multiple keys matching the provided key <" + aKey + "> in your underlyng properties after replacing the delimiter <" + this.getDelimiter() + "> with one or more of your provided delimiters. The superflous original key is <" + eKey + "> after appliying <" + eDelimiter + "> to the provided key <" + aKey + "> (delimiters processed so far: " + (String)theDelimiters + ").", eKey);
                    }
                    isContainsKey = true;
                }
                if (super.containsKey((Object)(eDelimiter + eKey))) {
                    if (isContainsKey) {
                        throw new AmbiguousKeyRuntimeException("There are multiple keys matching the provided key <" + aKey + "> in your underlyng properties after replacing the delimiter <" + this.getDelimiter() + "> with one or more of your provided delimiters. The superflous original key is <" + eDelimiter + eKey + "> after appliying <" + eDelimiter + "> to the provided key <" + aKey + "> (delimiters processed so far: " + (String)theDelimiters + ").", eKey);
                    }
                    isContainsKey = true;
                }
                if (eKey.length() <= 0 || eKey.charAt(0) != eDelimiter || !super.containsKey((Object)eKey.substring(1))) continue;
                if (isContainsKey) {
                    throw new AmbiguousKeyRuntimeException("There are multiple keys matching the provided key <" + aKey + "> in your underlyng properties after replacing the delimiter <" + this.getDelimiter() + "> with one or more of your provided delimiters. The superflous original key is <" + eKey.substring(1) + "> after appliying <" + eDelimiter + "> to the provided key <" + aKey + "> (delimiters processed so far: " + (String)theDelimiters + ").", eKey);
                }
                isContainsKey = true;
            }
        }
        return isContainsKey;
    }

    @Override
    public String get(Object aKey) {
        String theValue = super.get(aKey);
        if (aKey != null) {
            String theKey = aKey.toString();
            Object theDelimiters = "";
            for (char eDelimiter : this._delimiters) {
                String eValue3;
                String eValue2;
                if (((String)theDelimiters).length() > 0) {
                    theDelimiters = (String)theDelimiters + ", ";
                }
                theDelimiters = (String)theDelimiters + "'" + eDelimiter + "'";
                String eKey = NormalizedPropertiesDecorator.fromNormalized(theKey, this.getDelimiter(), eDelimiter);
                String eValue1 = super.get((Object)eKey);
                if (eValue1 != null) {
                    if (theValue != null) {
                        throw new AmbiguousKeyRuntimeException("There are multiple keys matching the provided key <" + aKey + "> in your underlyng properties after replacing the delimiter <" + this.getDelimiter() + "> with one or more of your provided delimiters. The superflous original key is <" + eKey + "> after appliying <" + eDelimiter + "> to the provided key <" + aKey + "> (delimiters processed so far: " + (String)theDelimiters + ").", eKey);
                    }
                    theValue = eValue1;
                }
                if ((eValue2 = super.get((Object)(eDelimiter + eKey))) != null) {
                    if (theValue != null) {
                        throw new AmbiguousKeyRuntimeException("There are multiple keys matching the provided key <" + aKey + "> in your underlyng properties after replacing the delimiter <" + this.getDelimiter() + "> with one or more of your provided delimiters. The superflous original key is <" + eDelimiter + eKey + "> after appliying <" + eDelimiter + "> to the provided key <" + aKey + "> (delimiters processed so far: " + (String)theDelimiters + ").", eKey);
                    }
                    theValue = eValue2;
                }
                if (eKey.length() <= 0 || eKey.charAt(0) != eDelimiter || (eValue3 = super.get((Object)eKey.substring(1))) == null) continue;
                if (theValue != null) {
                    throw new AmbiguousKeyRuntimeException("There are multiple keys matching the provided key <" + aKey + "> in your underlyng properties after replacing the delimiter <" + this.getDelimiter() + "> with one or more of your provided delimiters. The superflous original key is <" + eKey.substring(1) + "> after appliying <" + eDelimiter + "> to the provided key <" + aKey + "> (delimiters processed so far: " + (String)theDelimiters + ").", eKey);
                }
                theValue = eValue3;
            }
        }
        return theValue;
    }

    @Override
    public Set<String> keySet() {
        Set<String> theKeys = super.keySet();
        HashSet<String> theProjectedKeys = new HashSet<String>();
        Iterator<String> iterator = theKeys.iterator();
        while (iterator.hasNext()) {
            String eKey;
            String eProjectedKey = eKey = iterator.next();
            if (theProjectedKeys.contains(eProjectedKey = NormalizedPropertiesDecorator.toNormalized(eProjectedKey, this.getDelimiter(), this._delimiters))) {
                throw new AmbiguousKeyRuntimeException("There are multiple keys matching the key <" + eKey + "> in your underlyng properties after converting the keys by replacing the delimiters provided <" + this.toDelimiters() + "> to the delimiter <" + this.getDelimiter() + ">.", eKey);
            }
            theProjectedKeys.add(eProjectedKey);
        }
        return theProjectedKeys;
    }

    @Override
    public Properties retrieveFrom(String aFromPath) {
        return new PropertiesImpl(this).retrieveFrom(aFromPath);
    }

    @Override
    public Properties retrieveTo(String aToPath) {
        return new PropertiesImpl(this).retrieveTo(aToPath);
    }

    protected String toDelimiters() {
        Object theDelimiters = "";
        for (char eDelimiter : this._delimiters) {
            if (((String)theDelimiters).length() > 0) {
                theDelimiters = (String)theDelimiters + ", ";
            }
            theDelimiters = (String)theDelimiters + "'" + eDelimiter + "'";
        }
        return theDelimiters;
    }

    protected static String fromNormalized(String aKey, char aFromDelimiter, char aToDelimiter) {
        if (aKey != null) {
            aKey = aKey.replace(aFromDelimiter, aToDelimiter);
            while (aKey.length() > 1 && aKey.charAt(0) == aToDelimiter) {
                aKey = aKey.substring(1);
            }
        }
        return aKey;
    }

    protected static String toNormalized(String aKey, char aToDelimiter, char ... aFromDelimiters) {
        for (char eDelimiter : aFromDelimiters) {
            while (aKey.length() > 1 && (aKey.charAt(0) == eDelimiter || aKey.charAt(0) == aToDelimiter)) {
                aKey = aKey.substring(1);
            }
            aKey = aKey.replace(eDelimiter, aToDelimiter);
        }
        return aToDelimiter + aKey;
    }
}

