/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.observer;

import java.util.UUID;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.mixin.ChannelAccessor;
import org.refcodes.mixin.GroupAccessor;
import org.refcodes.mixin.MetaDataAccessor;
import org.refcodes.mixin.UniversalIdAccessor;
import org.refcodes.observer.PublisherTypeAccessor;

public class EventMetaData
implements UniversalIdAccessor,
AliasAccessor,
GroupAccessor,
ChannelAccessor,
PublisherTypeAccessor {
    protected String _alias;
    protected String _channel;
    protected String _group;
    protected String _uid;
    protected Class<?> _publisherType;

    private EventMetaData(Builder builder) {
        this._alias = builder.alias;
        this._channel = builder.channel;
        this._group = builder.group;
        this._uid = builder.uid;
        this._publisherType = builder.publisherType;
    }

    public EventMetaData() {
        this._uid = UUID.randomUUID().toString();
    }

    public EventMetaData(Class<?> aPublisherType) {
        this._uid = UUID.randomUUID().toString();
        this._publisherType = aPublisherType;
    }

    public EventMetaData(EventMetaData aMetaData) {
        this._alias = aMetaData.getAlias();
        this._group = aMetaData.getGroup();
        this._channel = aMetaData.getChannel();
        this._uid = aMetaData.getUniversalId();
        this._publisherType = aMetaData.getPublisherType();
    }

    public EventMetaData(String aChannel) {
        this._channel = aChannel;
        this._uid = UUID.randomUUID().toString();
    }

    public EventMetaData(String aChannel, Class<?> aPublisherType) {
        this._channel = aChannel;
        this._publisherType = aPublisherType;
        this._uid = UUID.randomUUID().toString();
    }

    public EventMetaData(String aAlias, String aGroup) {
        this._alias = aAlias;
        this._group = aGroup;
        this._uid = UUID.randomUUID().toString();
    }

    public EventMetaData(String aAlias, String aGroup, String aChannel) {
        this._alias = aAlias;
        this._group = aGroup;
        this._channel = aChannel;
        this._uid = UUID.randomUUID().toString();
    }

    public EventMetaData(String aAlias, String aGroup, String aChannel, Class<?> aPublisherType) {
        this._alias = aAlias;
        this._group = aGroup;
        this._channel = aChannel;
        this._publisherType = aPublisherType;
        this._uid = UUID.randomUUID().toString();
    }

    public EventMetaData(String aAlias, String aGroup, String aChannel, String aUid, Class<?> aPublisherType) {
        this._alias = aAlias;
        this._group = aGroup;
        this._channel = aChannel;
        this._uid = aUid;
        this._publisherType = aPublisherType;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public String getChannel() {
        return this._channel;
    }

    @Override
    public String getGroup() {
        return this._group;
    }

    @Override
    public Class<?> getPublisherType() {
        return this._publisherType;
    }

    @Override
    public String getUniversalId() {
        return this._uid;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [UID=" + this._uid + ", alias=" + this._alias + ", group=" + this._group + ", channel=" + this._channel + ", publisherType=" + (this._publisherType != null ? this._publisherType.getSimpleName() : null) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements AliasAccessor.AliasBuilder<Builder>,
    ChannelAccessor.ChannelBuilder<Builder>,
    GroupAccessor.GroupBuilder<Builder>,
    UniversalIdAccessor.UniversalIdBuilder<Builder>,
    PublisherTypeAccessor.PublisherTypeBuilder<Builder>,
    MetaDataAccessor.MetaDataBuilder<EventMetaData, Builder> {
        private String alias;
        private String channel;
        private String group;
        private String uid;
        private Class<?> publisherType;

        private Builder() {
        }

        @Override
        public Builder withAlias(String aAlias) {
            this.alias = aAlias;
            return this;
        }

        @Override
        public Builder withChannel(String aChannel) {
            this.channel = aChannel;
            return this;
        }

        @Override
        public Builder withGroup(String aGroup) {
            this.group = aGroup;
            return this;
        }

        @Override
        public Builder withUniversalId(String aUid) {
            this.uid = aUid;
            return this;
        }

        @Override
        public Builder withPublisherType(Class<?> aPublisherType) {
            this.publisherType = aPublisherType;
            return this;
        }

        @Override
        public Builder withMetaData(EventMetaData aEventMetaData) {
            if (aEventMetaData.getAlias() != null) {
                this.alias = aEventMetaData.getAlias();
            }
            if (aEventMetaData.getChannel() != null) {
                this.channel = aEventMetaData.getChannel();
            }
            if (aEventMetaData.getGroup() != null) {
                this.group = aEventMetaData.getGroup();
            }
            if (aEventMetaData.getPublisherType() != null) {
                this.publisherType = aEventMetaData.getPublisherType();
            }
            if (aEventMetaData.getUniversalId() != null) {
                this.uid = aEventMetaData.getUniversalId();
            }
            return this;
        }

        public EventMetaData build() {
            return new EventMetaData(this);
        }
    }
}

