/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.exception.BugException;
import org.refcodes.numerical.NumericalUtility;

public enum Endianess {
    LITTLE,
    BIG;


    public byte[] toBytes(long aValue, int aLength) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case BIG -> NumericalUtility.toBigEndianBytes(aValue, aLength);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue, aLength);
        };
    }

    public byte[] toBytes(long aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toBytes(int aValue, int aLength) {
        return switch (this) {
            case BIG -> NumericalUtility.toBigEndianBytes(aValue, aLength);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue, aLength);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toBytes(int aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toBytes(short aValue, int aLength) {
        return switch (this) {
            case BIG -> NumericalUtility.toBigEndianBytes(aValue, aLength);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue, aLength);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toBytes(short aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toBytes(float aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toBytes(double aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toUnsignedBytes(long aValue, int aLength) {
        return switch (this) {
            case BIG -> NumericalUtility.toUnsignedBigEndianBytes(aValue, aLength);
            case LITTLE -> NumericalUtility.toUnsignedLittleEndianBytes(aValue, aLength);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toUnsignedBytes(long aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toUnsignedBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toUnsignedLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toUnsignedBytes(int aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toUnsignedBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toUnsignedLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public byte[] toUnsignedBytes(short aValue) {
        return switch (this) {
            case BIG -> NumericalUtility.toUnsignedBigEndianBytes(aValue);
            case LITTLE -> NumericalUtility.toUnsignedLittleEndianBytes(aValue);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public long toLong(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toLongFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toLongFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public long toUnsignedLong(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toUnsignedLongFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toUnsignedLongFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public int toInteger(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toIntFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toIntFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public int toUnsignedInteger(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toUnsignedIntFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toUnsignedIntFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public short toShort(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toShortFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toShortFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public short toUnsignedShort(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toUnsignedShortFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toUnsignedShortFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public float toFloat(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toFloatFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toFloatFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }

    public double toDouble(byte[] aBytes) {
        return switch (this) {
            case BIG -> NumericalUtility.toDoubleFromBigEndianBytes(aBytes);
            case LITTLE -> NumericalUtility.toDoubleFromLittleEndianBytes(aBytes);
            default -> throw new BugException("The enumeration value <" + this + "> has not been implemented yet!");
        };
    }
}

