/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import org.refcodes.mixin.ValueAccessor;

public class BitwiseOperationBuilder
implements ValueAccessor.ValueProperty<Integer>,
ValueAccessor.ValueBuilder<Integer, BitwiseOperationBuilder> {
    private Integer _value = 0;

    @Override
    public Integer getValue() {
        return this._value;
    }

    @Override
    public void setValue(Integer aValue) {
        this._value = aValue;
    }

    public BitwiseOperationBuilder withAnd(Integer aOperand) {
        this._value = BitwiseOperationBuilder.toBitwiseAND(this._value, aOperand);
        return this;
    }

    public BitwiseOperationBuilder withOr(Integer aOperand) {
        this._value = BitwiseOperationBuilder.toBitwiseOR(this._value, aOperand);
        return this;
    }

    public BitwiseOperationBuilder withXor(Integer aOperand) {
        this._value = BitwiseOperationBuilder.toBitwiseXOR(this._value, aOperand);
        return this;
    }

    public BitwiseOperationBuilder withNot() {
        this._value = BitwiseOperationBuilder.toBitwiseNOT(this._value);
        return this;
    }

    public boolean isMaskable(int aMask) {
        return BitwiseOperationBuilder.isMaskable(this._value, aMask);
    }

    public boolean isTrueAt(int aPosition) {
        return BitwiseOperationBuilder.isTrueAt(this._value, aPosition);
    }

    @Override
    public BitwiseOperationBuilder withValue(Integer aValue) {
        this.setValue(aValue);
        return this;
    }

    public static boolean isTrueAt(int aValue, int aPos) {
        String bitString = Integer.toBinaryString(aValue);
        int bitStringLength = bitString.length();
        if (aPos < 0 || aPos > bitStringLength - 1) {
            return false;
        }
        return bitString.charAt(bitStringLength - 1 - aPos) == '1';
    }

    public static boolean isMaskable(int aValue, int aMask) {
        String[] bitStrings = BitwiseOperationBuilder.toBitStrings(aValue, aMask);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            if (bitStrings[1].charAt(i) != '1' || bitStrings[0].charAt(i) != '0') continue;
            return false;
        }
        return true;
    }

    protected static int toBitwiseAND(int aValueA, int aValueB) {
        Object result = "";
        String[] bitStrings = BitwiseOperationBuilder.toBitStrings(aValueA, aValueB);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            result = bitStrings[0].charAt(i) == '1' && bitStrings[1].charAt(i) == '1' ? (String)result + "1" : (String)result + "0";
        }
        return Integer.parseInt((String)result, 2);
    }

    protected static int toBitwiseNOT(int aValue) {
        Object result = "";
        String bitString = Integer.toBinaryString(aValue);
        int strLenght = bitString.length();
        for (int i = 0; i < strLenght; ++i) {
            result = (String)result + (bitString.charAt(i) == '1' ? "0" : "1");
        }
        return Integer.parseInt((String)result, 2);
    }

    protected static int toBitwiseOR(int aValueA, int aValueB) {
        Object result = "";
        String[] bitStrings = BitwiseOperationBuilder.toBitStrings(aValueA, aValueB);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            result = bitStrings[0].charAt(i) == '1' || bitStrings[1].charAt(i) == '1' ? (String)result + "1" : (String)result + "0";
        }
        return Integer.parseInt((String)result, 2);
    }

    protected static int toBitwiseXOR(int aValueA, int aValueB) {
        Object result = "";
        String[] bitStrings = BitwiseOperationBuilder.toBitStrings(aValueA, aValueB);
        for (int i = 0; i < bitStrings[0].length(); ++i) {
            result = bitStrings[0].charAt(i) == '1' ^ bitStrings[1].charAt(i) == '1' ? (String)result + "1" : (String)result + "0";
        }
        return Integer.parseInt((String)result, 2);
    }

    protected static String[] toBitStrings(int aValueA, int aValueB) {
        Object theBitStringB;
        Object theBitStringA;
        block3: {
            block2: {
                theBitStringA = Integer.toBinaryString(aValueA);
                theBitStringB = Integer.toBinaryString(aValueB);
                if (((String)theBitStringA).length() <= ((String)theBitStringB).length()) break block2;
                while (((String)theBitStringB).length() < ((String)theBitStringA).length()) {
                    theBitStringB = "0" + (String)theBitStringB;
                }
                break block3;
            }
            if (((String)theBitStringA).length() >= ((String)theBitStringB).length()) break block3;
            while (((String)theBitStringA).length() < ((String)theBitStringB).length()) {
                theBitStringA = "0" + (String)theBitStringA;
            }
        }
        return new String[]{theBitStringA, theBitStringB};
    }
}

