/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.mixin;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.refcodes.mixin.Schema;

public abstract class AbstractSchema
extends HashMap<String, Object>
implements Schema {
    private static final long serialVersionUID = 1L;
    private static final String INDENT = "  ";
    private Schema[] _children = null;

    public AbstractSchema(Class<?> aType, String aDescription) {
        this.put("TYPE", aType);
        this.put("DESCRIPTION", aDescription);
    }

    public AbstractSchema(String aAlias, Class<?> aType) {
        this.put("TYPE", aType);
        this.put("ALIAS", aAlias);
    }

    public AbstractSchema(String aAlias, Class<?> aType, String aDescription) {
        this.put("TYPE", aType);
        this.put("ALIAS", aAlias);
        this.put("DESCRIPTION", aDescription);
    }

    public AbstractSchema(Class<?> aType, String aDescription, Schema ... aChildren) {
        this._children = aChildren;
        this.put("TYPE", aType);
        this.put("DESCRIPTION", aDescription);
    }

    public AbstractSchema(String aAlias, Class<?> aType, String aDescription, Schema ... aChildren) {
        this._children = aChildren;
        this.put("TYPE", aType);
        this.put("ALIAS", aAlias);
        this.put("DESCRIPTION", aDescription);
    }

    public AbstractSchema(Schema aSchema) {
        super(aSchema);
        this._children = aSchema.getChildren();
        this.put("TYPE", aSchema.getType());
        this.put("ALIAS", aSchema.getAlias());
        this.put("DESCRIPTION", aSchema.getDescription());
    }

    public AbstractSchema(Class<?> aType, Schema aSchema) {
        this._children = aSchema.getChildren();
        this.putAll(aSchema);
        this.put("TYPE", aType);
        this.put("ALIAS", aSchema.getAlias());
        this.put("DESCRIPTION", aSchema.getDescription());
    }

    public AbstractSchema(Schema aSchema, Schema ... aChildren) {
        super(aSchema);
        this._children = aChildren;
        this.put("TYPE", aSchema.getType());
        this.put("ALIAS", aSchema.getAlias());
        this.put("DESCRIPTION", aSchema.getDescription());
    }

    @Override
    public Schema[] getChildren() {
        return this._children;
    }

    @Override
    public String toString() {
        return this.toString(this, 0);
    }

    protected String toString(Object aValue) {
        if (aValue != null && aValue.getClass().isArray()) {
            Object theValue = "{ ";
            int theLength = Array.getLength(aValue);
            for (int i = 0; i < theLength; ++i) {
                theValue = (String)theValue + this.toString(Array.get(aValue, i));
                if (i >= theLength - 1) continue;
                theValue = (String)theValue + ", ";
            }
            return (String)theValue + " }";
        }
        if (aValue instanceof String || aValue != null && aValue.getClass().isEnum()) {
            return "\"" + aValue + "\"";
        }
        if (aValue instanceof Character) {
            return "'" + aValue + "'";
        }
        if (aValue instanceof Byte) {
            return AbstractSchema.toHexString((Byte)aValue);
        }
        if (aValue instanceof Class) {
            return "\"" + ((Class)aValue).getName() + "\"";
        }
        if (aValue instanceof Exception) {
            return "\"" + aValue + "\"";
        }
        return aValue != null ? aValue.toString() : null;
    }

    private String toString(Schema aSchema, int aIndent) {
        Object theIndent = "";
        for (int i = 0; i < aIndent; ++i) {
            theIndent = (String)theIndent + INDENT;
        }
        if (aSchema != null) {
            StringBuilder theBuffer = new StringBuilder();
            theBuffer.append((String)theIndent);
            theBuffer.append(aSchema.getType().getSimpleName());
            theBuffer.append(": {");
            ArrayList theKeys = new ArrayList(aSchema.keySet());
            Collections.sort(theKeys);
            for (String eKey : theKeys) {
                String eStrValue = "";
                Object eValue = aSchema.get(eKey);
                eStrValue = this.toString(eValue);
                AbstractSchema.appendAttribute(INDENT + eKey + ": " + eStrValue, theBuffer, (String)theIndent);
            }
            if (aSchema.getChildren() != null) {
                for (int i = 0; i < aSchema.getChildren().length; ++i) {
                    if (theBuffer.charAt(theBuffer.length() - 1) == '\"' || theBuffer.charAt(theBuffer.length() - 1) == '}') {
                        theBuffer.append(',');
                    }
                    theBuffer.append(System.lineSeparator());
                    theBuffer.append(this.toString(aSchema.getChildren()[i], aIndent + 1));
                }
            }
            if (theBuffer.charAt(theBuffer.length() - 1) != '{') {
                theBuffer.append(System.lineSeparator());
                theBuffer.append((String)theIndent);
            }
            theBuffer.append("}");
            return theBuffer.toString();
        }
        return (String)theIndent + "null";
    }

    private static String toHexString(byte aByte) {
        StringBuilder theBuffer = new StringBuilder();
        theBuffer.append("0x");
        theBuffer.append(Character.forDigit(aByte >> 4 & 0xF, 16));
        theBuffer.append(Character.forDigit(aByte & 0xF, 16));
        return theBuffer.toString();
    }

    private static void appendAttribute(String aText, StringBuilder aBuffer, String aIndent) {
        if (aBuffer.charAt(aBuffer.length() - 1) != '{') {
            aBuffer.append(',');
        }
        aBuffer.append(System.lineSeparator());
        aBuffer.append(aIndent);
        aBuffer.append(aText);
    }
}

