/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.matcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.refcodes.data.Delimiter;
import org.refcodes.matcher.AbstractWildcardMatcher;
import org.refcodes.matcher.MatcherSchema;
import org.refcodes.matcher.WildcardMatcher;
import org.refcodes.mixin.DelimiterAccessor;
import org.refcodes.mixin.WildcardSubstitutes;

public class PathMatcher
extends AbstractWildcardMatcher<String>
implements WildcardMatcher,
DelimiterAccessor {
    private static final char OPEN_CURLY = '{';
    private static final char DOLLAR = '$';
    private static final char[] ESCAPE_INSIDE_CHARACTER_CLASS = new char[]{'^', '-', ']', '\\'};
    private static final char[] ESCAPE_OUTSIDE_CHARACTER_CLASS = new char[]{'.', '^', '$', '*', '+', '?', '(', ')', '[', '{', '\\', '|'};
    private static final String DELIMITER = "DELIMITER";
    private static final String PATH_PATTERN = "PATH_PATTERN";
    private Pattern _matchee;
    private String _pathPattern = null;
    private String[] _wildcardNames = null;
    private char _delimiter;

    public PathMatcher(String aPathPattern) {
        this(aPathPattern, Delimiter.PATH.getChar());
    }

    public PathMatcher(String aPathPattern, char aDelimiter) {
        super("Matches a path against an ant path pattern (ANT).");
        if (aDelimiter == '?' || aDelimiter == '*' || aDelimiter == '|') {
            throw new IllegalArgumentException("Your delimiter '" + aDelimiter + "' must not be one of the following chars: '?', '*', '|'.");
        }
        this._delimiter = aDelimiter;
        this._pathPattern = aPathPattern;
        String theRegex = this.toRegex(aPathPattern, aDelimiter);
        this._matchee = Pattern.compile(theRegex);
    }

    @Override
    public String[] getWildcardNames() {
        return this._wildcardNames;
    }

    public String getPathPattern() {
        return this._pathPattern;
    }

    @Override
    public boolean isMatching(String aPath) {
        return this._matchee.matcher(aPath).matches();
    }

    @Override
    public WildcardSubstitutes toWildcardSubstitutes(String aPath) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        String[] theWildcardReplacements = theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
        HashMap<String, String> theNamedWildcardSubstitutes = null;
        if (this._wildcardNames != null) {
            theNamedWildcardSubstitutes = new HashMap<String, String>();
            for (String eName : this._wildcardNames) {
                theNamedWildcardSubstitutes.put(eName, theMatcher.group(eName));
            }
        }
        return new AbstractWildcardMatcher.WildcardMatcherSubstitutes(theWildcardReplacements, theNamedWildcardSubstitutes);
    }

    @Override
    public String[] toWildcardReplacements(String aPath) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i = 0; i < theMatcher.groupCount(); ++i) {
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacementAt(String aPath, int aIndex) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndex < theMatcher.groupCount()) {
            return theMatcher.group(aIndex + 1);
        }
        throw new IllegalArgumentException("Your provided index <" + aIndex + "> exceeds the number if wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".");
    }

    @Override
    public String[] toWildcardReplacementsAt(String aPath, int ... aIndexes) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aIndexes == null || aIndexes.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (int i : aIndexes) {
            if (i >= theMatcher.groupCount()) {
                throw new IllegalArgumentException("Your provided index <" + i + "> exceeds the number of wildcards <" + theMatcher.groupCount() + "> defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".");
            }
            theWildcardSubstitutes.add(theMatcher.group(i + 1));
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    @Override
    public String toWildcardReplacement(String aPath, String aWildcardName) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        try {
            return theMatcher.group(aWildcardName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Your provided name <" + aWildcardName + "> is not defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".", e);
        }
    }

    @Override
    public String[] toWildcardReplacements(String aPath, String ... aWildcardNames) {
        Matcher theMatcher = this._matchee.matcher(aPath);
        if (!theMatcher.matches()) {
            return null;
        }
        if (aWildcardNames == null || aWildcardNames.length == 0) {
            return new String[0];
        }
        ArrayList<String> theWildcardSubstitutes = new ArrayList<String>();
        for (String eWildcardName : aWildcardNames) {
            try {
                theWildcardSubstitutes.add(theMatcher.group(eWildcardName));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Your provided name <" + eWildcardName + "> is not defined in your pattern \"" + this.getPathPattern() + "\" for current path \"" + aPath + "\".", e);
            }
        }
        return theWildcardSubstitutes.toArray(new String[theWildcardSubstitutes.size()]);
    }

    public String toPattern() {
        return this._matchee.pattern();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._matchee == null ? 0 : this._matchee.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathMatcher other = (PathMatcher)obj;
        return !(this._matchee == null ? other._matchee != null : !this._matchee.equals(other._matchee));
    }

    @Override
    public char getDelimiter() {
        return this._delimiter;
    }

    @Override
    public MatcherSchema toSchema() {
        MatcherSchema theSchema = super.toSchema();
        theSchema.put("REGEX_PATTERN", this._matchee);
        theSchema.put(DELIMITER, Character.valueOf(this._delimiter));
        theSchema.put(PATH_PATTERN, this._pathPattern);
        theSchema.put("WILDCARD_NAMES", this._wildcardNames);
        return theSchema;
    }

    private String toRegex(String aPathPattern, char aDelimiter) {
        Object eTail;
        String eHead;
        Object WILDCARD_QUESTION_MARK;
        int i;
        aPathPattern = this.toEscapedReservedChars(aPathPattern);
        String WILDCARD_NAME_PATTERN = "(?<=\\$\\{).*?(?=\\}\\=)";
        int WILDCARD_NAME_PREFIX_LENGTH = 2;
        int WILDCARD_NAME_SUFFIX_LENGTH = 2;
        String SIMPLE_NAME_PATTERN = "(?<=\\$\\{).*?(?=\\})";
        int SIMPLE_NAME_PREFIX_LENGTH = 2;
        boolean SIMPLE_NAME_SUFFIX_LENGTH = true;
        Object theDelimiter = this.toEscapedInsiceCharacterClass(aDelimiter);
        if (aDelimiter == Delimiter.DOS_PATH.getChar()) {
            theDelimiter = (String)theDelimiter + (String)theDelimiter;
        }
        String WILDCARD_ASTERISK = "([^" + (String)theDelimiter + "]*)";
        String WILDCARD_DOUBOLE_ASTERISK = "(.*)";
        String REGEX_DELIMITER = this.toEscapedOutsiceCharacterClass(aDelimiter);
        Object REGEX_SAFE_DELIMITER = REGEX_DELIMITER;
        if (aDelimiter == Delimiter.DOS_PATH.getChar()) {
            REGEX_SAFE_DELIMITER = (String)REGEX_SAFE_DELIMITER + (String)REGEX_SAFE_DELIMITER;
        }
        String REGEX_SAFE_DOT = "\\.";
        Object theRegex = aPathPattern;
        theRegex = aPathPattern.replaceAll(REGEX_DELIMITER, (String)REGEX_SAFE_DELIMITER);
        theRegex = ((String)theRegex).replaceAll("\\.", "\\.");
        theRegex = ((String)theRegex).replaceAll("(?<!\\*)\\*(?!\\*)", WILDCARD_ASTERISK);
        theRegex = ((String)theRegex).replaceAll("\\*\\*", "(.*)");
        int theMaxQuestionMarks = 0;
        for (i = 0; i < aPathPattern.length(); ++i) {
            if (aPathPattern.charAt(i) != '?') continue;
            ++theMaxQuestionMarks;
        }
        for (i = theMaxQuestionMarks; i > 0; --i) {
            WILDCARD_QUESTION_MARK = "(";
            Object QUESTION_MARK = "";
            for (int j = 0; j < i; ++j) {
                WILDCARD_QUESTION_MARK = (String)WILDCARD_QUESTION_MARK + "\\\\w";
                QUESTION_MARK = (String)QUESTION_MARK + "\\?";
            }
            WILDCARD_QUESTION_MARK = (String)WILDCARD_QUESTION_MARK + ")";
            theRegex = ((String)theRegex).replaceAll((String)QUESTION_MARK, (String)WILDCARD_QUESTION_MARK);
        }
        WILDCARD_QUESTION_MARK = "(\\\\w";
        String theQuestionMark = ((String)WILDCARD_QUESTION_MARK).replaceAll("(\\\\)\\\\", "$1");
        String theAsterisk = WILDCARD_ASTERISK.replaceAll("\\\\", "");
        if (aDelimiter == Delimiter.DOS_PATH.getChar()) {
            theAsterisk = WILDCARD_ASTERISK.replaceAll("\\\\\\\\", "\\\\");
        }
        String theDoubleAsterisk = "(.*)".replaceAll("(\\\\)\\\\", "$1");
        ArrayList<String> theWildcardNames = new ArrayList<String>();
        Pattern theJokerPattern = Pattern.compile("(?<=\\$\\{).*?(?=\\}\\=)");
        Matcher eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        while (eJokerMatcher.find()) {
            String eTruncated = ((String)theRegex).substring(eJokerMatcher.end() + 2);
            if (!(eTruncated.startsWith(theAsterisk) || eTruncated.startsWith(theDoubleAsterisk) || eTruncated.startsWith(theQuestionMark))) {
                throw new IllegalArgumentException("Your wildcard name (such as \"" + ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.start()) + "\") in pattern <" + aPathPattern + "> must prefix a wildcard such as \"" + theAsterisk + "\" or \"" + theDoubleAsterisk + "\" or \"" + theQuestionMark + "!");
            }
            String eName = ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.end());
            theWildcardNames.add(eName);
            eHead = ((String)theRegex).substring(0, eJokerMatcher.start() - 2);
            eTail = ((String)theRegex).substring(eJokerMatcher.end() + 2);
            eTail = ((String)eTail).substring(0, 1) + "?<" + eName + ">" + ((String)eTail).substring(1);
            theRegex = eHead + (String)eTail;
            eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        }
        theJokerPattern = Pattern.compile("(?<=\\$\\{).*?(?=\\})");
        eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        while (eJokerMatcher.find()) {
            String eName = ((String)theRegex).substring(eJokerMatcher.start(), eJokerMatcher.end());
            theWildcardNames.add(eName);
            eHead = ((String)theRegex).substring(0, eJokerMatcher.start() - 2);
            eTail = WILDCARD_ASTERISK + ((String)theRegex).substring(eJokerMatcher.end() + 1);
            eTail = ((String)eTail).substring(0, 1) + "?<" + eName + ">" + ((String)eTail).substring(1);
            theRegex = eHead + (String)eTail;
            eJokerMatcher = theJokerPattern.matcher((CharSequence)theRegex);
        }
        if (theWildcardNames.size() != 0) {
            this._wildcardNames = theWildcardNames.toArray(new String[theWildcardNames.size()]);
        }
        return theRegex;
    }

    private String toEscapedReservedChars(String aPathPattern) {
        aPathPattern = this.toEscapeDollar(aPathPattern);
        aPathPattern = this.toEscapeOpenCurly(aPathPattern);
        return aPathPattern;
    }

    private String toEscapeDollar(String aPathPattern) {
        int index = ((String)aPathPattern).indexOf(36);
        while (index != -1 && (((String)aPathPattern).length() == 1 || index == ((String)aPathPattern).length() - 1 || index < ((String)aPathPattern).length() - 1 && ((String)aPathPattern).charAt(index + 1) != '{')) {
            if (index == 0) {
                aPathPattern = this.toEscapedOutsiceCharacterClass('$') + ((String)aPathPattern).substring(index + 1);
                ++index;
            } else {
                aPathPattern = ((String)aPathPattern).substring(0, index) + this.toEscapedOutsiceCharacterClass('$') + ((String)aPathPattern).substring(index + 1);
                ++index;
            }
            String tmp = ((String)aPathPattern).substring(index + 1);
            int tmpIndex = index;
            index = tmp.indexOf(36);
            if (index == -1) continue;
            index += tmpIndex + 1;
        }
        return aPathPattern;
    }

    private String toEscapeOpenCurly(String aPathPattern) {
        int index = ((String)aPathPattern).indexOf(123);
        while (index != -1 && index == 0 || index > 0 && ((String)aPathPattern).charAt(index - 1) != '$') {
            if (index == 0) {
                aPathPattern = this.toEscapedOutsiceCharacterClass('{') + ((String)aPathPattern).substring(1);
                ++index;
            } else {
                aPathPattern = ((String)aPathPattern).substring(0, index) + this.toEscapedOutsiceCharacterClass('{') + ((String)aPathPattern).substring(index + 1);
                ++index;
            }
            String tmp = ((String)aPathPattern).substring(index + 1);
            int tmpIndex = index;
            index = tmp.indexOf(123);
            if (index == -1) continue;
            index += tmpIndex + 1;
        }
        return aPathPattern;
    }

    private String toEscapedInsiceCharacterClass(char aChar) {
        for (char aESCAPE_INSIDE_CHARACTER_CLASS : ESCAPE_INSIDE_CHARACTER_CLASS) {
            if (aESCAPE_INSIDE_CHARACTER_CLASS != aChar) continue;
            return "\\" + aChar;
        }
        return "" + aChar;
    }

    private String toEscapedOutsiceCharacterClass(char aChar) {
        for (char aESCAPE_OUTSIDE_CHARACTER_CLASS : ESCAPE_OUTSIDE_CHARACTER_CLASS) {
            if (aESCAPE_OUTSIDE_CHARACTER_CLASS != aChar) continue;
            return "\\" + aChar;
        }
        return "" + aChar;
    }
}

