/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.refcodes.data.Delimiter;
import org.refcodes.logger.LoggerInstantiationRuntimeException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactory;
import org.refcodes.logger.RuntimeLoggerImpl;
import org.refcodes.logger.SystemLogger;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.ext.application.ApplicationProperties;
import org.refcodes.runtime.Execution;

public class RuntimeLoggerFactoryImpl
implements RuntimeLoggerFactory {
    private static final String NAME_PROPERTY = "name";
    private static final String CONFIG_LOCATOR = "runtimelogger";
    private static final RuntimeLoggerImpl FALLBACK_RUNTIME_LOGGER = new RuntimeLoggerImpl(new SystemLogger());
    private static final String SKIP_LOGGER_CONFIG_FILE_LIB = "org.apache.commons.configuration.DefaultFileSystem";
    private static final Map<String, Properties> CONFIG_TO_PROPERTIES = new WeakHashMap<String, Properties>();
    private final ConcurrentHashMap<String, RuntimeLogger> _nameToRuntimeLoggerMap = new ConcurrentHashMap();

    protected RuntimeLoggerFactoryImpl() {
    }

    @Override
    public RuntimeLogger create() {
        String className = Execution.getCallerStackTraceElement(RuntimeLoggerFactoryImpl.class.getPackage().getName()).getClassName();
        return this.create(className, (Map<String, String>)null);
    }

    @Override
    public RuntimeLogger create(Map<String, String> aProperties) {
        String className = Execution.getCallerStackTraceElement(RuntimeLoggerFactoryImpl.class).getClassName();
        return this.create(className, aProperties);
    }

    @Override
    public RuntimeLogger create(String aIdentifier) {
        return this.create(aIdentifier, (Map<String, String>)null);
    }

    @Override
    public RuntimeLogger create(String aIdentifier, Map<String, String> aProperties) {
        if (aIdentifier == null) {
            throw new IllegalArgumentException("The identifier must not be null; please provide a valid identifier.");
        }
        RuntimeLogger theRuntimeLogger = this._nameToRuntimeLoggerMap.get(aIdentifier);
        if (theRuntimeLogger != null) {
            return theRuntimeLogger;
        }
        ArrayList<String> theNames = new ArrayList<String>();
        RuntimeLogger theRootLogger = this._nameToRuntimeLoggerMap.get("root");
        if (theRootLogger == null) {
            try {
                theRootLogger = RuntimeLoggerFactoryImpl.fromConfigurationFile("root", CONFIG_LOCATOR);
            }
            catch (LoggerInstantiationRuntimeException e) {
                SystemLogger theLogger = new SystemLogger();
                theRootLogger = new RuntimeLoggerImpl(theLogger);
                theRootLogger.warn("Using fallback logger as the <runtimelogger.*> file does neither contain a valid runtime logger configuration for the namespace <" + aIdentifier + "> (or its children) nor for the root logger: " + e.getMessage());
            }
            if (theRootLogger == null) {
                throw new LoggerInstantiationRuntimeException("The <{0}(.*)> file does neither contain a valid runtime logger configuration for the namespace <{1}> (or its children) nor for the root logger!", CONFIG_LOCATOR, aIdentifier);
            }
            this._nameToRuntimeLoggerMap.putIfAbsent("root", theRootLogger);
        }
        String eIdentifier = aIdentifier.replace(Delimiter.INNER_CLASS.getChar(), Delimiter.PACKAGE_HIERARCHY.getChar());
        int i = aIdentifier.length();
        while (i > 0) {
            eIdentifier = eIdentifier.substring(0, i);
            theNames.add(eIdentifier);
            theRuntimeLogger = this._nameToRuntimeLoggerMap.get(eIdentifier);
            if (theRuntimeLogger != null) break;
            try {
                theRuntimeLogger = RuntimeLoggerFactoryImpl.fromConfigurationFile(eIdentifier, CONFIG_LOCATOR);
                break;
            }
            catch (LoggerInstantiationRuntimeException loggerInstantiationRuntimeException) {
                i = eIdentifier.lastIndexOf(Delimiter.NAMESPACE.getChar());
            }
        }
        if (theRuntimeLogger == null) {
            if (SKIP_LOGGER_CONFIG_FILE_LIB.equals(aIdentifier)) {
                return FALLBACK_RUNTIME_LOGGER;
            }
            if (!"root".equals(aIdentifier)) {
                theRuntimeLogger = theRootLogger;
            }
        }
        for (String eName : theNames) {
            this._nameToRuntimeLoggerMap.putIfAbsent(eName, theRuntimeLogger);
        }
        RuntimeLogger theRaceWinner = this._nameToRuntimeLoggerMap.get(aIdentifier);
        return theRaceWinner != null ? theRaceWinner : theRuntimeLogger;
    }

    public static RuntimeLogger fromConfigurationFile(String aNamespace, String aConfigFileName) {
        try {
            Properties theProperties = CONFIG_TO_PROPERTIES.get(aConfigFileName);
            if (theProperties == null) {
                theProperties = new ApplicationProperties().withResourceClass(aConfigFileName);
                CONFIG_TO_PROPERTIES.put(aConfigFileName, theProperties);
            }
            String thePath = aNamespace.replace(Delimiter.PACKAGE_HIERARCHY.getChar(), Delimiter.PATH.getChar());
            Properties theRootProperties = theProperties.retrieveFrom("root");
            if ("root".equals(aNamespace)) {
                theProperties = theRootProperties;
            } else {
                PropertiesBuilderImpl theNewProperties = new PropertiesBuilderImpl(theProperties.retrieveFrom(thePath));
                Iterator e = theNewProperties.keySet().iterator();
                while (e.hasNext()) {
                    String[] ePathElements = theNewProperties.toPathElements((String)e.next());
                    if (ePathElements != null && ePathElements.length != 0 && CONFIG_LOCATOR.equals(ePathElements[0])) continue;
                    e.remove();
                }
                if (!theNewProperties.isEmpty()) {
                    for (String eKey : theRootProperties.keySet()) {
                        if (theNewProperties.containsKey((Object)eKey)) continue;
                        theNewProperties.put(eKey, (String)theRootProperties.get((Object)eKey));
                    }
                }
                theProperties = theNewProperties;
            }
            RuntimeLogger theRuntimeLogger = theProperties.toType(CONFIG_LOCATOR, RuntimeLogger.class);
            if (theRuntimeLogger instanceof NameAccessor.NameMutator) {
                String theName = (String)theProperties.get(CONFIG_LOCATOR, NAME_PROPERTY);
                if (theName == null || theName.isEmpty()) {
                    ((NameAccessor.NameMutator)((Object)theRuntimeLogger)).setName(aNamespace);
                } else {
                    ((NameAccessor.NameMutator)((Object)theRuntimeLogger)).setName(theName);
                }
            }
            return theRuntimeLogger;
        }
        catch (Exception e) {
            throw new LoggerInstantiationRuntimeException("Cannot create logger from configuration file <{0}> with namespace (for package) <{1}>!", aConfigFileName, aNamespace, e);
        }
    }
}

