/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import org.refcodes.data.AnsiEscapeCode;
import org.refcodes.factory.TypeFactory;
import org.refcodes.logger.LogPriority;
import org.refcodes.textual.ColumnSetupMetrics;
import org.refcodes.textual.ColumnSetupMetricsImpl;
import org.refcodes.textual.ColumnWidthType;
import org.refcodes.textual.EscapeCodeFactory;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.MoreTextMode;
import org.refcodes.textual.SplitTextMode;
import org.refcodes.textual.TextFormatMode;

public enum ColumnLayout {
    NONE(ColumnLayout::toBasicColumnMetrics),
    SUPERUSER(ColumnLayout::toSuperuserColumnMetrics),
    GRANDPA(ColumnLayout::toGrandpaColumnMetrics),
    BASIC(ColumnLayout::toBasicColumnMetrics),
    DEVELOPER(ColumnLayout::toDeveloperColumnMetrics),
    HACKER(ColumnLayout::toHackerColumnMetrics),
    DEVOPS(ColumnLayout::toDevopsColumnMetrics),
    ENDUSER(ColumnLayout::toEnduserColumnMetrics),
    ANALYST(ColumnLayout::toAnalystColumnMetrics);

    private static final String EXCEPTION = "Exception";
    private static final String MESSAGE = "Message";
    private static final String METHOD = "Method";
    private static final String CODE_LINE = "@";
    private static final String CLASS = "Class";
    private static final String REQUEST = "Request";
    private static final String SESSION = "Session";
    private static final String THREAD = "Thread";
    private static final String PRIORITY = "Level";
    private static final String DATE = "Date";
    private static final String LINE_NUMBER = "#";
    private static final String ANSI_LINE_NUMBER;
    private static final String ANSI_DATE;
    private static final String ANSI_THREAD;
    private static final String ANSI_CORRELATION_ID;
    private static final String ANSI_MESSAGE;
    private static final String ANSI_EXCEPTION;
    private static final String ANSI_CLASS;
    private static final String ANSI_METHOD;
    private static final String ANSI_PRIORITY_WARN;
    private static final String ANSI_PRIORITY_NOTICE;
    private static final String ANSI_PRIORITY_INFO;
    private static final String ANSI_PRIORITY_PANIC;
    private static final String ANSI_PRIORITY_ALERT;
    private static final String ANSI_PRIORITY_CRITICAL;
    private static final String ANSI_PRIORITY_ERROR;
    private static final String ANSI_PRIORITY_DEBUG;
    private static final String ANSI_PRIORITY_TRACE;
    private static final String ANSI_HEADER;
    private TypeFactory<ColumnSetupMetrics[]> _columnSetupMetricsSupplier;
    private static EscapeCodeFactory LOG_PRIORITY_ESC_CODE_FACTORY;

    private ColumnLayout(TypeFactory<ColumnSetupMetrics[]> aColumnSetupMetricsSupplier) {
        this._columnSetupMetricsSupplier = aColumnSetupMetricsSupplier;
    }

    public ColumnSetupMetrics[] toColumnSetupMetrics() {
        return (ColumnSetupMetrics[])this._columnSetupMetricsSupplier.create();
    }

    public static ColumnLayout toColumnLayout(String aValue) {
        aValue = aValue != null ? aValue.replaceAll("-", "").replaceAll("_", "") : aValue;
        for (ColumnLayout eValue : ColumnLayout.values()) {
            if (!eValue.name().replaceAll("-", "").replaceAll("_", "").equalsIgnoreCase(aValue)) continue;
            return eValue;
        }
        return null;
    }

    private static final ColumnSetupMetrics[] toSuperuserColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_LINE_NUMBER).withRowMoreTextMode(MoreTextMode.NONE).withName(LINE_NUMBER), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName(THREAD), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName(SESSION), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName(REQUEST), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName(CLASS), new ColumnSetupMetricsImpl(4, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName(CODE_LINE), new ColumnSetupMetricsImpl(30, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowMoreTextMode(MoreTextMode.LEFT).withName(METHOD), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    private static final ColumnSetupMetrics[] toBasicColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl(5, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_LINE_NUMBER).withRowMoreTextMode(MoreTextMode.NONE).withName(LINE_NUMBER), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName(THREAD), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    private static final ColumnSetupMetrics[] toGrandpaColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.LEFT).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName(THREAD), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(7, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.NONE).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    private static final ColumnSetupMetrics[] toDeveloperColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName(THREAD), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(3, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName(CLASS), new ColumnSetupMetricsImpl(4, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName(CODE_LINE), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowMoreTextMode(MoreTextMode.LEFT).withName(METHOD), new ColumnSetupMetricsImpl(7, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    private static final ColumnSetupMetrics[] toHackerColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName(THREAD), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(3, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName(CLASS), new ColumnSetupMetricsImpl(4, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName(CODE_LINE), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowMoreTextMode(MoreTextMode.LEFT).withName(METHOD), new ColumnSetupMetricsImpl(7, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    private static final ColumnSetupMetrics[] toDevopsColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowMoreTextMode(MoreTextMode.LEFT).withName(THREAD), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName(SESSION), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowMoreTextMode(MoreTextMode.LEFT).withName(REQUEST), new ColumnSetupMetricsImpl(3, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowMoreTextMode(MoreTextMode.LEFT).withName(CLASS), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowMoreTextMode(MoreTextMode.LEFT).withName(METHOD), new ColumnSetupMetricsImpl(7, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.LEFT).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    private static final ColumnSetupMetrics[] toEnduserColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl().withHide(), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_SPACE).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    private static final ColumnSetupMetrics[] toAnalystColumnMetrics() {
        return new ColumnSetupMetrics[]{new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_LINE_NUMBER).withRowMoreTextMode(MoreTextMode.NONE).withName(LINE_NUMBER), new ColumnSetupMetricsImpl(19, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_DATE).withRowMoreTextMode(MoreTextMode.NONE).withName(DATE), new ColumnSetupMetricsImpl(7, ColumnWidthType.ABSOLUTE).withTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCodeFactory(LOG_PRIORITY_ESC_CODE_FACTORY).withRowMoreTextMode(MoreTextMode.NONE).withName(PRIORITY), new ColumnSetupMetricsImpl(10, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_THREAD).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName(THREAD), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName(SESSION), new ColumnSetupMetricsImpl(8, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.CENTER).withRowEscapeCode(ANSI_CORRELATION_ID).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName(REQUEST), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_CLASS).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName(CLASS), new ColumnSetupMetricsImpl(4, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.RIGHT).withRowEscapeCode(ANSI_CLASS).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName(CODE_LINE), new ColumnSetupMetricsImpl(30, ColumnWidthType.ABSOLUTE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_METHOD).withRowSplitTextMode(SplitTextMode.AT_FIXED_WIDTH).withName(METHOD), new ColumnSetupMetricsImpl(2, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_MESSAGE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(MESSAGE), new ColumnSetupMetricsImpl(1, ColumnWidthType.RELATIVE).withHeaderTextFormatMode(TextFormatMode.CELL).withHeaderHorizAlignTextMode(HorizAlignTextMode.CENTER).withHeaderEscapeCode(ANSI_HEADER).withHeaderMoreTextMode(MoreTextMode.RIGHT).withRowHorizAlignTextMode(HorizAlignTextMode.LEFT).withRowEscapeCode(ANSI_EXCEPTION).withRowMoreTextMode(MoreTextMode.NONE).withRowSplitTextMode(SplitTextMode.AT_FIRST_END_OF_LINE).withName(EXCEPTION)};
    }

    static {
        ANSI_LINE_NUMBER = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_MAGENTA, AnsiEscapeCode.DEFAULT_BACKGROUND_COLOR);
        ANSI_DATE = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_WHITE);
        ANSI_THREAD = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_CYAN);
        ANSI_CORRELATION_ID = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_CYAN, AnsiEscapeCode.DEFAULT_BACKGROUND_COLOR);
        ANSI_MESSAGE = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.DEFAULT_BACKGROUND_COLOR);
        ANSI_EXCEPTION = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BRIGHT_RED);
        ANSI_CLASS = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.DEFAULT_BACKGROUND_COLOR);
        ANSI_METHOD = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BLUE, AnsiEscapeCode.BOLD);
        ANSI_PRIORITY_WARN = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_RED, AnsiEscapeCode.BOLD);
        ANSI_PRIORITY_NOTICE = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_MAGENTA, AnsiEscapeCode.BOLD);
        ANSI_PRIORITY_INFO = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_GREEN, AnsiEscapeCode.BOLD);
        ANSI_PRIORITY_PANIC = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BRIGHT_WHITE, AnsiEscapeCode.BOLD, AnsiEscapeCode.BG_BRIGHT_RED);
        ANSI_PRIORITY_ALERT = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BRIGHT_YELLOW, AnsiEscapeCode.BOLD, AnsiEscapeCode.BG_BRIGHT_RED);
        ANSI_PRIORITY_CRITICAL = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BRIGHT_YELLOW, AnsiEscapeCode.BOLD, AnsiEscapeCode.BG_BRIGHT_MAGENTA);
        ANSI_PRIORITY_ERROR = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BRIGHT_RED, AnsiEscapeCode.BOLD);
        ANSI_PRIORITY_DEBUG = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_BRIGHT_YELLOW, AnsiEscapeCode.BOLD, AnsiEscapeCode.BG_BRIGHT_BLUE);
        ANSI_PRIORITY_TRACE = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.FG_WHITE, AnsiEscapeCode.BOLD);
        ANSI_HEADER = AnsiEscapeCode.toEscapeSequence(AnsiEscapeCode.DEFAULT_FOREGROUND_COLOR, AnsiEscapeCode.BOLD, AnsiEscapeCode.DEFAULT_BACKGROUND_COLOR);
        LOG_PRIORITY_ESC_CODE_FACTORY = new EscapeCodeFactory(){

            @Override
            public String create(Object aIdentifier) {
                if (aIdentifier != null) {
                    String theIdentifier;
                    String string = theIdentifier = aIdentifier instanceof String ? (String)aIdentifier : aIdentifier.toString();
                    if (LogPriority.PANIC.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_PANIC;
                    }
                    if (LogPriority.ALERT.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_ALERT;
                    }
                    if (LogPriority.CRITICAL.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_CRITICAL;
                    }
                    if (LogPriority.ERROR.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_ERROR;
                    }
                    if (LogPriority.WARN.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_WARN;
                    }
                    if (LogPriority.NOTICE.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_NOTICE;
                    }
                    if (LogPriority.INFO.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_INFO;
                    }
                    if (LogPriority.DEBUG.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_DEBUG;
                    }
                    if (LogPriority.TRACE.name().equals(theIdentifier)) {
                        return ANSI_PRIORITY_TRACE;
                    }
                }
                return null;
            }
        };
    }
}

