/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.controlflow.InvocationStrategy;
import org.refcodes.criteria.BadCriteriaException;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.CriteriaUtility;
import org.refcodes.criteria.ExpressionQueryFactory;
import org.refcodes.exception.BugException;
import org.refcodes.logger.AbstractPartedLogger;
import org.refcodes.logger.LoggerFactory;
import org.refcodes.logger.LoggerUtility;
import org.refcodes.logger.QueryLogger;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.Header;
import org.refcodes.tabular.Records;
import org.refcodes.textual.VerboseTextBuilder;

abstract class AbstractPartedQueryLogger<L extends QueryLogger<T>, T, P extends T>
extends AbstractPartedLogger<L, T, P>
implements QueryLogger<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractPartedQueryLogger.class.getName());
    private static final InvocationStrategy RETRIEVAL_STRATEGY = InvocationStrategy.ROUND_ROBIN;

    public AbstractPartedQueryLogger(Column<P> aPartitionColumn, LoggerFactory<L> aLoggerFactory, boolean isPartitionAutoInitialize) {
        super(aPartitionColumn, aLoggerFactory, isPartitionAutoInitialize);
    }

    public AbstractPartedQueryLogger(Column<P> aPartitionColumn, String aDefaultLoggerName, LoggerFactory<L> aLoggerFactory, boolean isPartitionAutoInitialize) {
        super(aPartitionColumn, aDefaultLoggerName, aLoggerFactory, isPartitionAutoInitialize);
    }

    @Override
    public Records<T> findLogs() {
        try {
            return this.findLogs(null, null, -1);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(int aLimit) {
        try {
            return this.findLogs(null, null, aLimit);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria) {
        try {
            return this.findLogs(aCriteria, null, -1);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(Header<T> aHeader, int aLimit) {
        try {
            return this.findLogs(null, aHeader, aLimit);
        }
        catch (BadCriteriaException e) {
            throw new BugException("We must not get this exception <" + e.getClass().getName() + "> as no criteria has been provided: ", e);
        }
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, int aLimit) throws BadCriteriaException {
        return this.findLogs(aCriteria, null, aLimit);
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, Header<T> aHeader) throws BadCriteriaException {
        return this.findLogs(aCriteria, aHeader, -1);
    }

    @Override
    public Records<T> findLogs(Criteria aCriteria, Header<T> aHeader, int aLimit) throws BadCriteriaException {
        Set<P> thePartitions = this.getPartitions(aCriteria);
        if (thePartitions.size() == 1) {
            P ePartition = thePartitions.iterator().next();
            QueryLogger theLogger = (QueryLogger)this.getPartitionLogger(ePartition);
            if (theLogger != null) {
                aCriteria = CriteriaUtility.doRemovePartitionCriteria(aCriteria, (String)this.getPartitionColumn().getKey(), thePartitions);
                return theLogger.findLogs(aCriteria, aHeader, aLimit);
            }
            LOGGER.log(Level.WARNING, "No logger found for partition \"" + this.getPartitionUid(ePartition) + "\": Now querying all partitions (fallback)!");
        } else if (thePartitions.size() == 0 && this.getFallbackLogger() != null) {
            LOGGER.log(Level.FINE, "No partition found for provided criteria, now querying default logger instance to find logs in question!");
            return ((QueryLogger)this.getFallbackLogger()).findLogs(aCriteria, aHeader, aLimit);
        }
        Collection<L> theLoggers = this.getPartitionLoggers(thePartitions);
        return LoggerUtility.findLogs(aCriteria, aHeader, aLimit, theLoggers, RETRIEVAL_STRATEGY);
    }

    protected Collection<L> getPartitionLoggers(Set<P> aPartitions) {
        Collection theLoggers;
        if (aPartitions.isEmpty()) {
            theLoggers = this.getLoggers();
            LOGGER.log(Level.WARNING, "None partitions at all detected for the query (criteria): Now querying all partitions (fallback)!");
        } else {
            theLoggers = new HashSet();
            if (aPartitions.size() != 1) {
                for (P ePartition : aPartitions) {
                    QueryLogger ePartitionLogger = (QueryLogger)this.getPartitionLogger(ePartition);
                    if (ePartitionLogger != null) {
                        theLoggers.add(ePartitionLogger);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Determined not exisiting partition " + this.getPartitionUid(ePartition) + " to be addressed for the query (criteria), no logger instance present for that partition! Now querying all partitions (fallback)!");
                }
            }
            if (theLoggers.isEmpty() || theLoggers.size() != aPartitions.size()) {
                theLoggers = this.getLoggers();
                LOGGER.log(Level.WARNING, "None existing partitions detected (partitions with no logger) for the query (criteria): Now querying all partitions (fallback)!");
            }
        }
        return theLoggers;
    }

    private Set<P> getPartitions(Criteria aCriteria) throws BadCriteriaException {
        Set thePartitions = CriteriaUtility.getPartitions(aCriteria, (String)this.getPartitionColumn().getKey(), this.getPartitionColumn().getType());
        if (LOGGER.isLoggable(Level.FINE)) {
            String theQuery;
            if (aCriteria == null) {
                theQuery = "(null)";
            } else {
                ExpressionQueryFactory theExpressionQueryFactory = new ExpressionQueryFactory();
                theQuery = theExpressionQueryFactory.fromCriteria(aCriteria);
            }
            LOGGER.log(Level.FINE, "Partitions " + new VerboseTextBuilder().withElements(thePartitions).toString() + " determined for (raw) query is: \"" + theQuery + "\"");
        }
        if (thePartitions.size() > 1) {
            LOGGER.log(Level.WARNING, "Determined <" + thePartitions.size() + "> partitions to be addresses by the query (criteria), the number of partitions to be targeted at is greater than one, probably you have a bad partitioning (partitioning) or query (criteria) strategy!");
        }
        return thePartitions;
    }
}

