/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.refcodes.component.Destroyable;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.RetryCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.exception.Trap;
import org.refcodes.logger.IllegalRecordRuntimeException;
import org.refcodes.logger.Logger;
import org.refcodes.logger.UnexpectedLogRuntimeException;
import org.refcodes.tabular.Record;

abstract class AbstractLoggerComposite<L extends Logger<T>, T>
implements Logger<T>,
Destroyable {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(AbstractLoggerComposite.class.getName());
    private static final int LOGGERS_MULTIPLIER = 1000;
    private LinkedBlockingQueue<Record<? extends T>> _logLineQueue;
    private final List<L> _loggers = new ArrayList<L>();
    private boolean _isDestroyed = false;

    @SafeVarargs
    public AbstractLoggerComposite(L ... aLoggers) {
        this(ControlFlowUtility.createCachedExecutorService(true), (Logger[])aLoggers);
    }

    @SafeVarargs
    public AbstractLoggerComposite(ExecutorService aExecutorService, L ... aLoggers) {
        if (aLoggers == null) {
            throw new IllegalArgumentException("Unable to construct the composite logger as there must at least one logger instance provided!");
        }
        this._logLineQueue = new LinkedBlockingQueue(aLoggers.length * 1000);
        this._loggers.addAll(Arrays.asList(aLoggers));
        LogDaemon eDaemon = null;
        for (L eLogger : aLoggers) {
            eDaemon = new LogDaemon(this, eLogger);
            aExecutorService.execute(eDaemon);
        }
    }

    @Override
    public void log(Record<? extends T> aRecord) {
        RetryCounter theRetryCounter = new RetryCounter(IoRetryCount.MAX.getValue());
        try {
            while (!this._logLineQueue.offer(aRecord, SleepLoopTime.MAX.getTimeMillis(), TimeUnit.MILLISECONDS) && theRetryCounter.nextRetry()) {
                LOGGER.log(Level.WARNING, "Trying to offer (add) a log line to the log line queue, though the queue is full, this is retry # <" + theRetryCounter.getRetryCount() + ">, aborting after <" + theRetryCounter.getRetryNumber() + "> retries. Retrying now after a delay of <" + SleepLoopTime.MAX.getTimeMillis() / 1000 + "> seconds...");
                if (theRetryCounter.hasNextRetry()) continue;
                throw new UnexpectedLogRuntimeException("Unable to process the log line after <" + theRetryCounter.getRetryNumber() + "> retries, aborting retries, dismissing log line \"" + aRecord.toString() + "\"!", aRecord);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void destroy() {
        this._isDestroyed = true;
        RetryCounter theRetryCounter = new RetryCounter(RetryCount.MAX.getValue(), (long)SleepLoopTime.NORM.getTimeMillis());
        while (theRetryCounter.hasNextRetry() && !this._logLineQueue.isEmpty()) {
            LOGGER.log(Level.WARNING, "The logline queue is not empty, waiting <" + theRetryCounter.getNextRetryDelayMillis() + "> ms for next retry number <" + theRetryCounter.getRetryCount() + "> (of <" + theRetryCounter.getRetryNumber() + "> altogether).");
            theRetryCounter.nextRetry();
        }
        int theLogLineQueueSize = this._logLineQueue.size();
        if (theLogLineQueueSize != 0) {
            LOGGER.log(Level.WARNING, "The logline queue was not empty (with size <" + theLogLineQueueSize + ">) upon destroying this component.");
        }
    }

    protected Collection<L> getLoggers() {
        return this._loggers;
    }

    private static class LogDaemon
    implements Runnable {
        private final L _logger;
        final /* synthetic */ AbstractLoggerComposite this$0;

        public LogDaemon(L aLogger) {
            this.this$0 = var1_1;
            this._logger = aLogger;
        }

        @Override
        public void run() {
            Record eRecord = null;
            while (!this.this$0._logLineQueue.isEmpty() || !this.this$0._isDestroyed) {
                try {
                    eRecord = this.this$0._logLineQueue.take();
                    this._logger.log(eRecord);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (IllegalRecordRuntimeException e) {
                    LOGGER.log(Level.WARNING, "As of an illegal record, the daemon is unable to log the log line \"" + eRecord + "\" as of: " + Trap.asMessage(e), e);
                }
                catch (UnexpectedLogRuntimeException e) {
                    LOGGER.log(Level.WARNING, "As of an unexpected log exception, the daemon is unable to log the log line \"" + eRecord + "\" as of: " + Trap.asMessage(e), e);
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "As of an unrecognized exception, the daemon is unable to log the log line \"" + eRecord + "\" as of: " + Trap.asMessage(e), e);
                }
            }
        }
    }
}

