/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class SerializableObjectInputStream
extends ObjectInputStream {
    public SerializableObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass aClass) throws ClassNotFoundException, IOException {
        try {
            return super.resolveClass(aClass);
        }
        catch (ClassNotFoundException aException) {
            if ("boolean".equals(aClass.getName())) {
                return Boolean.TYPE;
            }
            if ("byte".equals(aClass.getName())) {
                return Byte.TYPE;
            }
            if ("char".equals(aClass.getName())) {
                return Character.TYPE;
            }
            if ("double".equals(aClass.getName())) {
                return Double.TYPE;
            }
            if ("float".equals(aClass.getName())) {
                return Float.TYPE;
            }
            if ("int".equals(aClass.getName())) {
                return Integer.TYPE;
            }
            if ("long".equals(aClass.getName())) {
                return Long.TYPE;
            }
            if ("short".equals(aClass.getName())) {
                return Short.TYPE;
            }
            if ("void".equals(aClass.getName())) {
                return Void.TYPE;
            }
            throw aException;
        }
    }
}

