/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.OutputStream;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.io.AbstractShortsTransmitter;
import org.refcodes.io.ConnectionShortsTransmitter;

public class OutputStreamConnectionShortsTransmitter
extends AbstractShortsTransmitter
implements ConnectionShortsTransmitter<OutputStream> {
    private OutputStream _outputStream = null;

    @Override
    public synchronized void open(OutputStream aOutputStream) throws IOException {
        if (this.isOpened()) {
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._outputStream = aOutputStream;
            this._outputStream.flush();
        }
        catch (IOException aException) {
            throw new IOException("Unable to open the I/O stream receiver as of a causing exception.", aException);
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    @Override
    public boolean isOpenable(OutputStream aOutputStream) {
        return aOutputStream == null ? false : !this.isOpened();
    }

    @Override
    public void flush() throws IOException {
        try {
            this._outputStream.flush();
        }
        catch (IOException e) {
            throw new IOException("Unable to flush underlying output stream <" + this._outputStream + ">.", e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        try {
            this._outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitShort(short aShort) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aShort + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        OutputStream outputStream = this._outputStream;
        synchronized (outputStream) {
            try {
                this._outputStream.write(aShort);
                this._outputStream.flush();
            }
            catch (IOException aException) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new IOException("Unable to close malfunctioning connection.", e);
                }
                throw new IOException(aException);
            }
        }
    }
}

