/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.Serializable;
import org.refcodes.io.AbstractDatagramsTransmitter;
import org.refcodes.io.ConnectionDatagramsTransmitter;
import org.refcodes.io.LoopbackDatagramsReceiver;

public class LoopbackDatagramsTransmitter<DATA extends Serializable>
extends AbstractDatagramsTransmitter<DATA>
implements ConnectionDatagramsTransmitter<DATA, LoopbackDatagramsReceiver<DATA>> {
    private LoopbackDatagramsReceiver<DATA> _loopbackReceiver;

    @Override
    public boolean isOpenable(LoopbackDatagramsReceiver<DATA> aLoopbackReceiver) {
        return !this.isOpened() && aLoopbackReceiver != null;
    }

    @Override
    public synchronized void open(LoopbackDatagramsReceiver<DATA> aLoopbackReceiver) throws IOException {
        if (this.isOpened()) {
            if (this._loopbackReceiver == aLoopbackReceiver && this._loopbackReceiver.isOpened()) {
                return;
            }
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        super.open();
        this._loopbackReceiver = aLoopbackReceiver;
        if (this._loopbackReceiver.isOpenable(this)) {
            this._loopbackReceiver.open(this);
        }
    }

    @Override
    public synchronized void transmit(DATA aDatagram) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagram(aDatagram);
    }

    @Override
    public void transmit(DATA[] aDatagrams, int aOffset, int aLength) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aDatagrams + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams((Serializable[])aDatagrams, aOffset, aLength);
    }

    @Override
    public void transmit(DATA[] aDatagrams) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aDatagrams + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackReceiver.pushDatagrams((Serializable[])aDatagrams);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this._loopbackReceiver != null && !this._loopbackReceiver.isClosed()) {
            this._loopbackReceiver.close();
            this._loopbackReceiver = null;
        }
    }
}

