/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.Serializable;
import org.refcodes.io.AbstractDatagramsReceiver;
import org.refcodes.io.ConnectionDatagramsTransceiver;

public class LoopbackDatagramsTransceiver<DATA extends Serializable>
extends AbstractDatagramsReceiver<DATA>
implements ConnectionDatagramsTransceiver<DATA, LoopbackDatagramsTransceiver<DATA>> {
    private LoopbackDatagramsTransceiver<DATA> _loopbackTransceiver = null;

    public LoopbackDatagramsTransceiver() {
    }

    public LoopbackDatagramsTransceiver(int aCapacity) {
        super(aCapacity);
    }

    @Override
    public boolean isOpenable(LoopbackDatagramsTransceiver<DATA> aLoopbackTransceiver) {
        return !this.isOpened() && aLoopbackTransceiver != null;
    }

    @Override
    public synchronized void open(LoopbackDatagramsTransceiver<DATA> aLoopbackTransceiver) throws IOException {
        if (this.isOpened()) {
            if (this._loopbackTransceiver == aLoopbackTransceiver && this._loopbackTransceiver.isOpened()) {
                return;
            }
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        super.open();
        this._loopbackTransceiver = aLoopbackTransceiver;
        if (this._loopbackTransceiver.isOpenable(this)) {
            this._loopbackTransceiver.open(this);
        }
    }

    @Override
    public void transmit(DATA aDatagram) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aDatagram.getClass().getName() + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this._loopbackTransceiver.pushDatagram(aDatagram);
    }

    @Override
    public void pushDatagram(DATA aDatagram) throws IOException {
        super.pushDatagram(aDatagram);
    }

    @Override
    public void flush() throws IOException {
        this._loopbackTransceiver.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        if (this._loopbackTransceiver != null && !this._loopbackTransceiver.isClosed()) {
            this._loopbackTransceiver.close();
            this._loopbackTransceiver = null;
        }
    }
}

