/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.InputStream;

public class FilterInputStream
extends InputStream {
    private final InputStream _inputStream;
    private final byte[] _filterBytes;

    public FilterInputStream(InputStream aInputStream, byte ... aFilterBytes) {
        this._inputStream = aInputStream;
        this._filterBytes = aFilterBytes;
    }

    public FilterInputStream(InputStream aInputStream, char ... aFilterAsciiChars) {
        this._inputStream = aInputStream;
        this._filterBytes = new byte[aFilterAsciiChars.length];
        for (int i = 0; i < aFilterAsciiChars.length; ++i) {
            char eCharValue = aFilterAsciiChars[i];
            if (eCharValue > '\u00ff') {
                throw new IllegalArgumentException("The character '" + aFilterAsciiChars[i] + "' (value = <" + eCharValue + ">) is greater than <255> and not an ASCII (8-Bit) character!");
            }
            this._filterBytes[i] = (byte)eCharValue;
        }
    }

    @Override
    public int read() throws IOException {
        int eRead = this._inputStream.read();
        while (eRead != -1 && this.isFilterByte(eRead)) {
            eRead = this._inputStream.read();
        }
        return eRead;
    }

    @Override
    public int available() throws IOException {
        return this._inputStream.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this._inputStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this._inputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this._inputStream.markSupported();
    }

    private boolean isFilterByte(int aRead) {
        for (byte _filterByte : this._filterBytes) {
            if (_filterByte != (byte)aRead) continue;
            return true;
        }
        return false;
    }
}

