/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.DatagramReceiver;
import org.refcodes.io.DatagramsDestination;

public interface DatagramsReceiver<DATA extends Serializable>
extends DatagramReceiver<DATA>,
DatagramsDestination<DATA> {
    @Override
    default public DATA[] receiveAll() throws IOException {
        ArrayList theData = new ArrayList();
        while (this.hasAvailable()) {
            theData.add(this.receive());
        }
        return theData.toArray((Serializable[])new Object[theData.size()]);
    }

    @Override
    default public DATA[] receive(int aLength) throws IOException {
        int i;
        Serializable[] theBlock = (Serializable[])new Object[aLength];
        for (i = 0; this.hasAvailable() && i < aLength; ++i) {
            theBlock[i] = this.receive();
        }
        if (i == 0) {
            while (!this.hasAvailable()) {
                try {
                    Thread.sleep(SleepLoopTime.NORM.getTimeMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (this.hasAvailable() && i < aLength) {
                    theBlock[i] = this.receive();
                    ++i;
                }
            }
        }
        if (i == aLength) {
            return theBlock;
        }
        return Arrays.copyOfRange(theBlock, 0, i);
    }
}

