/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.IOException;
import java.util.List;
import org.refcodes.io.AbstractBytesReceiver;
import org.refcodes.struct.ByteArrayAccessor;

public class ByteArrayReceiver
extends AbstractBytesReceiver
implements ByteArrayAccessor {
    public ByteArrayReceiver(byte[] aDatagrams) {
        super(aDatagrams.length);
        try {
            this.open();
            this.pushDatagrams(aDatagrams);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayReceiver(List<Byte> aDatagrams) {
        this(ByteArrayReceiver.toPrimitiveType(aDatagrams.toArray(new Byte[aDatagrams.size()])));
    }

    @Override
    public byte[] getBytes() {
        return ByteArrayReceiver.toPrimitiveType(this._datagramQueue.toArray(new Byte[this._datagramQueue.size()]));
    }

    private static byte[] toPrimitiveType(Byte[] aBytes) {
        if (aBytes == null) {
            return null;
        }
        byte[] thePrimitives = new byte[aBytes.length];
        for (int i = 0; i < aBytes.length; ++i) {
            thePrimitives[i] = aBytes[i];
        }
        return thePrimitives;
    }
}

