/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.refcodes.io.AbstractInputStreamByteReceiver;
import org.refcodes.io.BidirectionalStreamConnectionByteTransceiver;

public class BidirectionalStreamConnectionByteTransceiverImpl
extends AbstractInputStreamByteReceiver
implements BidirectionalStreamConnectionByteTransceiver {
    private ObjectOutputStream _objectOutputStream = null;

    @Override
    public boolean isOpenable(InputStream aInputStream, OutputStream aOutputStream) {
        if (aOutputStream == null) {
            return false;
        }
        return this.isOpenable(aInputStream);
    }

    @Override
    public void open(InputStream aInputStream, OutputStream aOutputStream) throws IOException {
        this.open(aOutputStream);
        this.open(aInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitByte(byte aByte) throws IOException {
        if (!this.isOpened()) {
            throw new IOException("Unable to write datagram <" + aByte + "> as the connection is NOT OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        ObjectOutputStream objectOutputStream = this._objectOutputStream;
        synchronized (objectOutputStream) {
            try {
                this._objectOutputStream.writeObject(aByte);
                this._objectOutputStream.flush();
            }
            catch (IOException aException) {
                if (this.isClosed()) {
                    return;
                }
                try {
                    this.close();
                }
                catch (IOException e) {
                    throw new IOException("Unable to close malfunctioning stream.", e);
                }
                throw new IOException(aException);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this._objectOutputStream.flush();
        }
        catch (IOException e) {
            throw new IOException("Unable to flush transceiver's output stream <" + this._objectOutputStream + ">.", e);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        block2: {
            super.close();
            try {
                this._objectOutputStream.close();
            }
            catch (IOException aException) {
                if (BidirectionalStreamConnectionByteTransceiverImpl.isThrownAsOfAlreadyClosed(aException)) break block2;
                throw new IOException("Unable to close stream <" + this._objectOutputStream + ">.", aException);
            }
        }
    }

    protected synchronized void open(OutputStream aOutputStream) throws IOException {
        if (this.isOpened()) {
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        try {
            this._objectOutputStream = aOutputStream instanceof ObjectOutputStream ? (ObjectOutputStream)aOutputStream : (!(aOutputStream instanceof BufferedOutputStream) ? new ObjectOutputStream(new BufferedOutputStream(aOutputStream)) : new ObjectOutputStream(aOutputStream));
            this._objectOutputStream.flush();
        }
        catch (IOException aException) {
            throw new IOException("Unable to open the I/O stream receiver as of a causing exception.", aException);
        }
    }
}

