/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.controlflow.ControlFlowUtility;
import org.refcodes.controlflow.RetryTimeout;
import org.refcodes.data.DaemonLoopSleepTime;
import org.refcodes.data.RetryLoopCount;
import org.refcodes.exception.Trap;
import org.refcodes.io.AbstractDatagramsReceiver;
import org.refcodes.io.SerializableObjectInputStream;
import org.refcodes.mixin.Disposable;

public abstract class AbstractPrefetchInputStreamReceiver<DATA extends Serializable>
extends AbstractDatagramsReceiver<DATA> {
    private static final Logger LOGGER = Logger.getLogger(AbstractPrefetchInputStreamReceiver.class.getName());
    private ObjectInputStream _objectInputStream = null;
    private ExecutorService _executorService;
    private IoStreamReceiverDaemon _ioStreamReceiverDaemon = null;
    private boolean _isDaemonAlive = false;

    public AbstractPrefetchInputStreamReceiver() {
        this(1024, null);
    }

    public AbstractPrefetchInputStreamReceiver(ExecutorService aExecutorService) {
        this(1024, aExecutorService);
    }

    public AbstractPrefetchInputStreamReceiver(int aQueueCapacity) {
        this(aQueueCapacity, null);
    }

    public AbstractPrefetchInputStreamReceiver(int aQueueCapacity, ExecutorService aExecutorService) {
        this._executorService = aExecutorService == null ? ControlFlowUtility.createCachedExecutorService(true) : ControlFlowUtility.toManagedExecutorService(aExecutorService);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed()) {
            super.close();
            if (this._ioStreamReceiverDaemon != null) {
                this._ioStreamReceiverDaemon.dispose();
                this._ioStreamReceiverDaemon = null;
            }
            try {
                if (this._objectInputStream != null) {
                    this._objectInputStream.close();
                }
            }
            catch (IOException e) {
                throw new IOException("Unable to close receiver (connection status is <" + this.getConnectionStatus() + ">).", e);
            }
        }
    }

    protected synchronized void open(InputStream aInputStream) throws IOException {
        block5: {
            if (this.isOpened()) {
                throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
            }
            try {
                this._objectInputStream = !(aInputStream instanceof BufferedInputStream) ? new SerializableObjectInputStream(new BufferedInputStream(aInputStream)) : new SerializableObjectInputStream(aInputStream);
            }
            catch (IOException aException) {
                if (AbstractPrefetchInputStreamReceiver.isThrownAsOfAlreadyClosed(aException)) break block5;
                throw new IOException("Unable to open the I/O stream receiver as of a causing exception.", aException);
            }
        }
        this._ioStreamReceiverDaemon = new IoStreamReceiverDaemon();
        this.setConnectionStatus(ConnectionStatus.OPENED);
        this._executorService.execute(this._ioStreamReceiverDaemon);
        if (!this._isDaemonAlive) {
            RetryTimeout theRetryTimeout = new RetryTimeout((long)DaemonLoopSleepTime.NORM.getTimeMillis(), RetryLoopCount.NORM_NUM_RETRY_LOOPS.getValue());
            while (!this._isDaemonAlive) {
                theRetryTimeout.nextRetry();
            }
        }
    }

    protected boolean isOpenable(InputStream aInputStream) {
        return aInputStream == null ? false : !this.isOpened();
    }

    private class IoStreamReceiverDaemon
    implements Runnable,
    Disposable {
        private boolean _isDisposed = false;

        private IoStreamReceiverDaemon() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object eObject = null;
                AbstractPrefetchInputStreamReceiver.this._isDaemonAlive = true;
                while (!this._isDisposed && AbstractPrefetchInputStreamReceiver.this.isOpened()) {
                    try {
                        eObject = AbstractPrefetchInputStreamReceiver.this._objectInputStream.readObject();
                        AbstractPrefetchInputStreamReceiver.this.pushDatagram((Serializable)eObject);
                    }
                    catch (ClassCastException | ClassNotFoundException aException) {
                        LOGGER.log(Level.WARNING, "Unable to read datagram from sender as of a causing exception; connection status is " + AbstractPrefetchInputStreamReceiver.this.getConnectionStatus(), aException);
                    }
                }
            }
            catch (IOException aException) {
                AbstractPrefetchInputStreamReceiver abstractPrefetchInputStreamReceiver = AbstractPrefetchInputStreamReceiver.this;
                synchronized (abstractPrefetchInputStreamReceiver) {
                    if (AbstractPrefetchInputStreamReceiver.this.isOpened()) {
                        try {
                            if (!(aException instanceof EOFException)) {
                                LOGGER.log(Level.WARNING, "Unable to read datagram from sender as of a causing exception; connection status is " + AbstractPrefetchInputStreamReceiver.this.getConnectionStatus(), aException);
                            }
                            AbstractPrefetchInputStreamReceiver.this.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.WARNING, "Unable to close malfunctioning connection as of: " + Trap.asMessage(e), e);
                        }
                    }
                }
            }
            finally {
                AbstractPrefetchInputStreamReceiver.this._isDaemonAlive = false;
            }
        }

        @Override
        public void dispose() {
            this._isDisposed = true;
        }
    }
}

