/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.io.BytesReceiver;

public abstract class AbstractInputStreamByteReceiver
extends AbstractConnectableAutomaton
implements BytesReceiver {
    private final LinkedList<Byte> _datagramQueue = new LinkedList();
    private InputStream _inputStream = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        if (this.isClosed()) {
            return 0;
        }
        if (!this._datagramQueue.isEmpty()) {
            return this._datagramQueue.size();
        }
        try {
            int theWord = this._inputStream.read();
            if (theWord == -1) {
                this.close();
                LinkedList<Byte> linkedList = this._datagramQueue;
                synchronized (linkedList) {
                    this._datagramQueue.notifyAll();
                }
                return 0;
            }
            this._datagramQueue.add((byte)(theWord & 0xFF));
            return this._datagramQueue.size();
        }
        catch (IOException ioe) {
            if (this.isClosed()) {
                return 0;
            }
            LinkedList<Byte> linkedList = this._datagramQueue;
            synchronized (linkedList) {
                this._datagramQueue.notifyAll();
            }
            try {
                if (AbstractInputStreamByteReceiver.isThrownAsOfAlreadyClosed(ioe)) {
                    super.close();
                } else {
                    this.close();
                }
            }
            catch (IOException e) {
                throw new IOException("Unable to test datagram availability (connection status is <" + this.getConnectionStatus() + ">).", e);
            }
            throw new IOException("Unable to test datagram availability (connection status is <" + this.getConnectionStatus() + ">).", ioe);
        }
    }

    @Override
    public byte receiveByte() throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + this.getConnectionStatus() + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        if (!this.hasAvailable()) {
            throw new IOException("Connection is closed and no (more) data is available!");
        }
        Byte theDatagram = this._datagramQueue.poll();
        while (theDatagram == null) {
            if (!this.hasAvailable()) {
                throw new IOException("Connection is closed and no (more) data is available (connection status is <" + this.getConnectionStatus() + ">).");
            }
            try {
                Thread.sleep(SleepLoopTime.MIN.getTimeMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            theDatagram = this._datagramQueue.poll();
        }
        return theDatagram;
    }

    @Override
    public synchronized void close() throws IOException {
        block3: {
            if (!this.isClosed()) {
                super.close();
                try {
                    this._inputStream.close();
                }
                catch (IOException e) {
                    if (AbstractInputStreamByteReceiver.isThrownAsOfAlreadyClosed(e)) break block3;
                    throw new IOException("Unable to close receiver (connection status is <" + this.getConnectionStatus() + ">).", e);
                }
            }
        }
    }

    protected synchronized void open(InputStream aInputStream) throws IOException {
        if (this.isOpened()) {
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is <" + this.getConnectionStatus() + ">.");
        }
        this._inputStream = aInputStream;
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    protected boolean isOpenable(InputStream aInputStream) {
        return aInputStream == null ? false : !this.isOpened();
    }
}

