/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.io;

import java.io.EOFException;
import java.io.IOException;
import org.refcodes.component.AbstractConnectableAutomaton;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.io.AbstractBytesDestination;
import org.refcodes.io.BytesReceiver;

public abstract class AbstractBytesReceiver
extends AbstractBytesDestination
implements BytesReceiver {
    protected ConnectableAutomaton _automaton = new ConnectableAutomaton();

    public AbstractBytesReceiver() {
    }

    public AbstractBytesReceiver(int aCapacity) {
        super(aCapacity);
    }

    @Override
    public byte receiveByte() throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + this.getConnectionStatus() + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + this.getConnectionStatus() + ").");
        }
        return super.receiveByte();
    }

    @Override
    public byte[] receiveAllBytes() throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + this.getConnectionStatus() + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + this.getConnectionStatus() + ").");
        }
        return super.receiveAllBytes();
    }

    @Override
    public byte[] receiveBytes(int aLength) throws IOException {
        if (this._datagramQueue.isEmpty() && this.isClosed()) {
            throw new EOFException("Connection is closed and no (more) data is available (connection status is <" + this.getConnectionStatus() + ">).");
        }
        if (this._datagramQueue.isEmpty() && !this.isOpened()) {
            throw new IOException("Unable to read datagram  as the connection is NOT OPEN (connection status is " + this.getConnectionStatus() + ").");
        }
        return super.receiveBytes(aLength);
    }

    @Override
    public int available() throws IOException {
        return this._datagramQueue.size();
    }

    @Override
    public void close() throws IOException {
        if (this.isOpened()) {
            this._automaton.close();
        }
    }

    @Override
    public boolean isOpened() {
        return this._automaton.isOpened();
    }

    @Override
    public boolean isClosable() {
        return this._automaton.isClosable();
    }

    @Override
    public boolean isClosed() {
        return this._automaton.isClosed();
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._automaton.getConnectionStatus();
    }

    protected void open() throws IOException {
        this._automaton.open();
    }

    protected void setConnectionStatus(ConnectionStatus aConnectionStatus) {
        this._automaton.setConnectionStatus(aConnectionStatus);
    }

    protected boolean isOpenable() {
        return this._automaton.isOpenable();
    }

    protected static class ConnectableAutomaton
    extends AbstractConnectableAutomaton {
        protected ConnectableAutomaton() {
        }

        @Override
        public boolean isOpenable() {
            return super.isOpenable();
        }

        @Override
        public void open() throws IOException {
            super.open();
        }

        @Override
        public void setConnectionStatus(ConnectionStatus aConnectionStatus) {
            super.setConnectionStatus(aConnectionStatus);
        }
    }
}

