/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.awt.Color;
import org.refcodes.graphical.GraphicalUtility;
import org.refcodes.graphical.RgbColor;

public class RgbColorImpl
implements RgbColor {
    private int _alphaPortion = 0;
    private int _redPortion = 0;
    private int _greenPortion = 0;
    private int _bluePortion = 0;

    public RgbColorImpl() {
    }

    public RgbColorImpl(int aAlphaPortion, int aRedPortion, int aGreenPortion, int aBluePortion) {
        this._alphaPortion = aAlphaPortion;
        this._redPortion = aRedPortion;
        this._greenPortion = aGreenPortion;
        this._bluePortion = aBluePortion;
    }

    public RgbColorImpl(int aRgbValue) {
        this.setRgbValue(aRgbValue);
    }

    public RgbColorImpl(Color aAwtColor) {
        this(aAwtColor.getAlpha(), aAwtColor.getRed(), aAwtColor.getGreen(), aAwtColor.getBlue());
    }

    @Override
    public int getAlpha() {
        return this._alphaPortion;
    }

    @Override
    public int getRed() {
        return this._redPortion;
    }

    @Override
    public int getGreen() {
        return this._greenPortion;
    }

    @Override
    public int getBlue() {
        return this._bluePortion;
    }

    @Override
    public int toRgbValue() {
        return GraphicalUtility.toRgb(this._alphaPortion, this._redPortion, this._greenPortion, this._bluePortion);
    }

    @Override
    public void setRgbValue(int aRgbValue) {
        this._alphaPortion = GraphicalUtility.toAlpha(aRgbValue);
        this._redPortion = GraphicalUtility.toRed(aRgbValue);
        this._greenPortion = GraphicalUtility.toGreen(aRgbValue);
        this._bluePortion = GraphicalUtility.toBlue(aRgbValue);
    }

    @Override
    public void setAlphaPortion(int aAlphaPortion) {
        this._alphaPortion = aAlphaPortion;
    }

    @Override
    public void setRedPortion(int aRedPortion) {
        this._redPortion = aRedPortion;
    }

    @Override
    public void setGreenPortion(int aGreenPortion) {
        this._greenPortion = aGreenPortion;
    }

    @Override
    public void setBluePortion(int aBluePortion) {
        this._bluePortion = aBluePortion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._alphaPortion;
        result = 31 * result + this._bluePortion;
        result = 31 * result + this._greenPortion;
        result = 31 * result + this._redPortion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RgbColorImpl other = (RgbColorImpl)obj;
        if (this._alphaPortion != other._alphaPortion) {
            return false;
        }
        if (this._bluePortion != other._bluePortion) {
            return false;
        }
        if (this._greenPortion != other._greenPortion) {
            return false;
        }
        return this._redPortion == other._redPortion;
    }
}

