/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.generator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.refcodes.data.CharSet;
import org.refcodes.generator.AlphabetCounterMetrics;
import org.refcodes.generator.IdCounter;

public class AlphabetCounter
extends AlphabetCounterMetrics
implements IdCounter {
    private int _base = -1;
    private int[] _counter;
    private final Map<Character, Integer> _indexOf = new HashMap<Character, Integer>();
    private final Map<Integer, Character> _charAt = new HashMap<Integer, Character>();
    private int _nextWordIndex = 0;
    private int _readerIndex = 0;
    private String _nextReaderWord = null;
    private String _currentReaderWord = null;
    private BufferedReader[] _wordReaders = null;

    public AlphabetCounter(File ... aWordsFiles) throws IOException {
        this((String)null, aWordsFiles);
    }

    public AlphabetCounter(String aStartValue, File ... aWordsFiles) throws IOException {
        this.init(aStartValue, aWordsFiles);
    }

    public AlphabetCounter(InputStream ... aWordsStreams) throws IOException {
        this((String)null, aWordsStreams);
    }

    public AlphabetCounter(String aStartValue, InputStream ... aWordsStreams) throws IOException {
        this.init(aStartValue, null, null, aWordsStreams, 0, -1, null);
    }

    public AlphabetCounter(String aExpression) throws ParseException {
        AlphabetCounterMetrics theMetrics = new AlphabetCounterMetrics(aExpression);
        this.init(theMetrics.getStartValue(), theMetrics.getWords(), theMetrics.getWordsFiles(), theMetrics.getWordsStreams(), theMetrics.getMinLength(), theMetrics.getMaxLength(), theMetrics.getAlphabet());
    }

    public AlphabetCounter(String ... aWords) {
        this((String)null, aWords);
    }

    public AlphabetCounter(String aStartValue, String ... aWords) {
        super(aStartValue, aWords);
        if (aStartValue != null) {
            this._nextWordIndex = Arrays.asList(aWords).indexOf(aStartValue);
        }
        this._base = this._words.length;
    }

    public AlphabetCounter(char ... aAlphabet) {
        this(Character.toString(aAlphabet[0]), aAlphabet);
    }

    public AlphabetCounter(Collection<Character> aAlphabet) {
        this(AlphabetCounter.toCharArray(aAlphabet));
    }

    public AlphabetCounter(CharSet aAlphabet) {
        this(aAlphabet.getCharSet());
    }

    public AlphabetCounter(String aStartValue, Collection<Character> aAlphabet) {
        this(aStartValue, AlphabetCounter.toCharArray(aAlphabet));
    }

    public AlphabetCounter(String aStartValue, CharSet aAlphabet) {
        this(aStartValue, aAlphabet.getCharSet());
    }

    public AlphabetCounter(String aStartValue, char ... aAlphabet) {
        this(aStartValue, 1, aAlphabet);
    }

    public AlphabetCounter(int aMinLength, char ... aAlphabet) {
        this(null, aMinLength, -1, aAlphabet);
    }

    public AlphabetCounter(int aMinLength, Collection<Character> aAlphabet) {
        this(null, aMinLength, -1, AlphabetCounter.toCharArray(aAlphabet));
    }

    public AlphabetCounter(int aMinLength, CharSet aAlphabet) {
        this(null, aMinLength, -1, aAlphabet.getCharSet());
    }

    public AlphabetCounter(String aStartValue, Collection<Character> aAlphabet, int aMinLength) {
        this(aStartValue, aMinLength, -1, AlphabetCounter.toCharArray(aAlphabet));
    }

    public AlphabetCounter(String aStartValue, CharSet aAlphabet, int aMinLength) {
        this(aStartValue, aMinLength, -1, aAlphabet.getCharSet());
    }

    public AlphabetCounter(String aStartValue, int aMinLength, char ... aAlphabet) {
        this(aStartValue, aMinLength, -1, aAlphabet);
    }

    public AlphabetCounter(int aMinLength, int aMaxLength, char ... aAlphabet) {
        this(null, aMinLength, aMaxLength, aAlphabet);
    }

    public AlphabetCounter(int aMinLength, int aMaxLength, Collection<Character> aAlphabet) {
        this(null, aMinLength, aMaxLength, AlphabetCounter.toCharArray(aAlphabet));
    }

    public AlphabetCounter(int aMinLength, int aMaxLength, CharSet aAlphabet) {
        this(null, aMinLength, aMaxLength, aAlphabet.getCharSet());
    }

    public AlphabetCounter(String aStartValue, int aMinLength, int aMaxLength, Collection<Character> aAlphabet) {
        this(aStartValue, aMinLength, aMaxLength, AlphabetCounter.toCharArray(aAlphabet));
    }

    public AlphabetCounter(String aStartValue, int aMinLength, int aMaxLength, CharSet aAlphabet) {
        this(aStartValue, aMinLength, aMaxLength, aAlphabet.getCharSet());
    }

    public AlphabetCounter(AlphabetCounterMetrics aAlphabetCounterMetrics) {
        this.init(aAlphabetCounterMetrics.getStartValue(), aAlphabetCounterMetrics.getWords(), aAlphabetCounterMetrics.getWordsFiles(), aAlphabetCounterMetrics.getWordsStreams(), aAlphabetCounterMetrics.getMinLength(), aAlphabetCounterMetrics.getMaxLength(), aAlphabetCounterMetrics.getAlphabet());
    }

    public AlphabetCounter(String aStartValue, int aMinLength, int aMaxLength, char ... aAlphabet) {
        this.init(aStartValue, null, null, null, aMinLength, aMaxLength, aAlphabet);
    }

    private void init(String aStartValue, File[] aWordsFiles) throws FileNotFoundException {
        this._startValue = aStartValue;
        this._wordsFiles = aWordsFiles;
        if (aWordsFiles != null && aWordsFiles.length != 0) {
            for (int i = 0; i < aWordsFiles.length; ++i) {
                this._wordsStreams[i] = new FileInputStream(aWordsFiles[i]);
                this._wordReaders[i] = new BufferedReader(new InputStreamReader(this._wordsStreams[i]));
            }
        }
        this.seekStartPosition(aStartValue);
    }

    private void init(String aStartValue, String[] aWords, File[] aWordsFiles, InputStream[] aWordsStreams, int aMinLength, int aMaxLength, char ... aAlphabet) {
        int i;
        if (!(aWords != null || aWordsStreams != null || aAlphabet != null && aAlphabet.length != 0 || aStartValue != null && ((String)aStartValue).length() == aMinLength && ((String)aStartValue).length() == aMaxLength)) {
            throw new IllegalArgumentException("The provided alphabet <" + (aAlphabet != null ? Arrays.toString(aAlphabet) : null) + "> must at least contain one character!");
        }
        if (aMinLength < 0) {
            throw new IllegalArgumentException("The provided min length <" + aMinLength + "> must be greater or equal to <0>!");
        }
        this._alphabet = aAlphabet;
        this._minLength = aMinLength;
        this._maxLength = aMaxLength;
        this._words = aWords;
        if ((aStartValue == null || ((String)aStartValue).isEmpty()) && aWords == null) {
            aStartValue = "";
            for (i = 0; i < aMinLength; ++i) {
                aStartValue = (String)aStartValue + Character.toString(aAlphabet[0]);
            }
        }
        this._startValue = aStartValue;
        if (aWords != null && aStartValue != null) {
            AlphabetCounter.validateStartValue((String)aStartValue, aWords);
            this._nextWordIndex = Arrays.asList(aWords).indexOf(aStartValue);
        }
        if (aAlphabet != null) {
            for (i = 0; i < aAlphabet.length; ++i) {
                this._indexOf.put(Character.valueOf(aAlphabet[i]), i);
                this._charAt.put(i, Character.valueOf(aAlphabet[i]));
            }
            AlphabetCounterMetrics.validateStartValue((String)aStartValue, aMinLength, aMaxLength, aAlphabet);
        }
        if (aWordsFiles != null && aWordsFiles.length != 0) {
            this._wordsFiles = aWordsFiles;
        }
        if (aWordsStreams != null && aWordsStreams.length != 0) {
            this._wordsStreams = aWordsStreams;
            this._wordReaders = new BufferedReader[aWordsStreams.length];
            for (i = 0; i < aWordsStreams.length; ++i) {
                this._wordReaders[i] = new BufferedReader(new InputStreamReader(aWordsStreams[i]));
            }
            this.seekStartPosition((String)aStartValue);
        }
        if (aAlphabet != null) {
            this._base = aAlphabet.length;
            this._counter = new int[this._startValue.length()];
            for (i = 0; i < this._counter.length; ++i) {
                this._counter[i] = this._indexOf.get(Character.valueOf(this._startValue.charAt(i)));
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this._wordReaders != null) {
            if (this._nextReaderWord != null) {
                return true;
            }
            if (this._readerIndex >= this._wordReaders.length) {
                return false;
            }
            BufferedReader theReader = this._wordReaders[this._readerIndex];
            try {
                this._nextReaderWord = theReader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this._nextReaderWord == null) {
                ++this._readerIndex;
                if (this._readerIndex >= this._wordReaders.length) {
                    return false;
                }
                theReader = this._wordReaders[this._readerIndex];
                try {
                    this._nextReaderWord = theReader.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this._currentReaderWord = this._nextReaderWord;
            return this._nextReaderWord != null;
        }
        if (this._words != null) {
            return this._nextWordIndex < this._words.length;
        }
        if (this._alphabet != null) {
            if (this._maxLength == -1 || this._nextWordIndex == 0 || this._counter.length < this._maxLength) {
                return true;
            }
            for (int a_counter : this._counter) {
                if (a_counter >= this._base - 1) continue;
                return true;
            }
            return false;
        }
        return this._nextWordIndex == 0;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("The next element would exceed the " + (this._words != null ? "total number of provided words <" + this._words.length + ">" : "maximum specified length <" + this._maxLength + ">") + "!");
        }
        String theNextReaderWord = this._nextReaderWord;
        if (theNextReaderWord != null) {
            this._nextReaderWord = null;
            return theNextReaderWord;
        }
        if (this._words != null) {
            return this._words[this._nextWordIndex++];
        }
        if (this._nextWordIndex == 0) {
            this._nextWordIndex = -1;
            return this.toString();
        }
        for (int i = this._counter.length - 1; i >= 0; --i) {
            if (this._counter[i] < this._base - 1) {
                int n = i;
                this._counter[n] = this._counter[n] + 1;
                return this.toString();
            }
            this._counter[i] = 0;
        }
        if (this._maxLength == -1 || this._counter.length < this._maxLength) {
            int[] theCounter = Arrays.copyOf(this._counter, this._counter.length + 1);
            theCounter[theCounter.length - 1] = 0;
            this._counter = theCounter;
        }
        return this.toString();
    }

    @Override
    public char[] getAlphabet() {
        return this._alphabet;
    }

    @Override
    public void reset() {
        this._nextWordIndex = 0;
        if (this._alphabet != null) {
            int[] theCounter = new int[this._minLength];
            for (int i = 0; i < theCounter.length; ++i) {
                theCounter[i] = 0;
            }
            this._counter = theCounter;
        }
        if (this._wordsStreams != null) {
            int i;
            this._readerIndex = 0;
            this._nextReaderWord = null;
            this._currentReaderWord = null;
            for (i = 0; i < this._wordsStreams.length; ++i) {
                InputStream inputStream = this._wordsStreams[i];
                if (inputStream instanceof FileInputStream) {
                    FileInputStream eFileInputStream = (FileInputStream)inputStream;
                    try {
                        eFileInputStream.getChannel().position(0L);
                        continue;
                    }
                    catch (IOException e) {
                        throw new UnsupportedOperationException("The provided file input stream of type <" + this._wordsStreams[i].getClass().getName() + "> " + (String)(this._wordsFiles != null && this._wordsFiles.length == this._wordsStreams.length ? "for file <" + this._wordsFiles[i].getAbsolutePath() + "> " : " ") + "does not support reseting back to position <0>!", e);
                    }
                }
                throw new UnsupportedOperationException("The provided input stream of type <" + this._wordsStreams[i].getClass() + "> does not support reseting!");
            }
            this._wordReaders = new BufferedReader[this._wordsStreams.length];
            for (i = 0; i < this._wordsStreams.length; ++i) {
                this._wordReaders[i] = new BufferedReader(new InputStreamReader(this._wordsStreams[i]));
            }
        }
    }

    @Override
    public String toAlphabetExpression() {
        if (this._words != null) {
            return AlphabetCounter.toAlphabetExpression(this.toString(), this._words);
        }
        if (this._wordsFiles != null) {
            return AlphabetCounter.toAlphabetExpression(this.toString(), this._wordsFiles);
        }
        if (this._wordsStreams != null) {
            throw new UnsupportedOperationException("Cannot create an alphabet expression from streams with no (as far as can be seen) file references!");
        }
        return AlphabetCounter.toAlphabetExpression(this.toString(), this._minLength, this._maxLength, this._alphabet);
    }

    @Override
    public String toString() {
        if (this._words != null) {
            return this._words[this._nextWordIndex < this._words.length ? this._nextWordIndex : this._words.length - 1];
        }
        if (this._wordsStreams != null) {
            return this._currentReaderWord;
        }
        if (this._alphabet == null) {
            return this._startValue;
        }
        StringBuilder theBuffer = new StringBuilder();
        for (int a_counter : this._counter) {
            theBuffer.append(this._charAt.get(a_counter));
        }
        return theBuffer.toString();
    }

    private static char[] toCharArray(Collection<Character> aAlphabet) {
        char[] theAlphabet = new char[aAlphabet.size()];
        int index = 0;
        Iterator<Character> iterator = aAlphabet.iterator();
        while (iterator.hasNext()) {
            char eChar;
            theAlphabet[index] = eChar = iterator.next().charValue();
            ++index;
        }
        return theAlphabet;
    }

    private void seekStartPosition(String aStartValue) {
        if (this._wordsStreams != null && this._wordsStreams.length != 0 && aStartValue != null && aStartValue.length() != 0) {
            while (this.hasNext() && !aStartValue.equals(this._nextReaderWord)) {
                this.next();
            }
        }
    }
}

