/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.refcodes.factory.InstantiationRuntimeException;
import org.refcodes.factory.TypeFactory;

public class ClassTypeFactory<T>
implements TypeFactory<T> {
    private final Class<T> _class;

    public ClassTypeFactory(Class<T> aClass) {
        if (!ClassTypeFactory.hasEmptyConstructor(aClass)) {
            throw new NoSuchMethodError("The given class <" + aClass.getName() + "> has no empty constructor, cannot create instances from it!");
        }
        if (aClass.isInterface()) {
            throw new IllegalArgumentException("The given interface <" + aClass.getName() + "> cannot be used by this factory as no instances can be created from an interface (please pass a class type)!");
        }
        this._class = aClass;
    }

    @Override
    public T create() {
        try {
            return this._class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InstantiationRuntimeException("Cannot create an instance for class <" + this._class.getName() + ">!", e);
        }
    }

    @Override
    public Class<T> getType() {
        return this._class;
    }

    private static boolean hasEmptyConstructor(Class<?> aClass) {
        for (Constructor<?> constructor : aClass.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }
}

