/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import java.math.BigDecimal;

public enum MemoryUnit {
    BYTE("Byte", new BigDecimal(1)),
    KILOBYTE("KByte", new BigDecimal(1024)),
    MEGABYTE("MByte", new BigDecimal(1024).multiply(new BigDecimal(1024))),
    GIGABYTE("GByte", new BigDecimal(1024).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024))),
    TERABYTE("TByte", new BigDecimal(1024).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024))),
    PETABYTE("PByte", new BigDecimal(1024).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024))),
    EXABYTE("EByte", new BigDecimal(1024).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024))),
    ZETTABYTE("ZByte", new BigDecimal(1024).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024))),
    YOTTABYTE("YByte", new BigDecimal(1024).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)).multiply(new BigDecimal(1024)));

    private String _unit;
    private BigDecimal _bytes;

    private MemoryUnit(String aUnit, BigDecimal aBytes) {
        this._unit = aUnit;
        this._bytes = aBytes;
    }

    public String getUnit() {
        return this._unit;
    }

    public BigDecimal getBytes() {
        return this._bytes;
    }

    public BigDecimal toBytes(double aUnitValue) {
        return this._bytes.multiply(new BigDecimal(aUnitValue));
    }

    public BigDecimal toBytes(BigDecimal aUnitValue) {
        return this._bytes.multiply(aUnitValue);
    }

    public BigDecimal toBytes(long aUnitValue) {
        return this._bytes.multiply(new BigDecimal(aUnitValue));
    }

    public BigDecimal fromBytes(long aBytes) {
        return new BigDecimal(aBytes).divide(this._bytes);
    }

    public BigDecimal fromBytes(BigDecimal aBytes) {
        return aBytes.divide(this._bytes);
    }

    public static MemoryUnit toSuitableUnit(long aBytes) {
        return MemoryUnit.toSuitableUnit(new BigDecimal(aBytes));
    }

    public static MemoryUnit toSuitableUnit(BigDecimal aBytes) {
        MemoryUnit eBestUnit = BYTE;
        for (MemoryUnit eUnit : MemoryUnit.values()) {
            if (aBytes.divide(eUnit.getBytes()).longValue() < 1L) {
                return eBestUnit;
            }
            eBestUnit = eUnit;
        }
        return eBestUnit;
    }
}

