/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.criteria;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.NumberNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.CriteriaFactory;
import org.refcodes.criteria.CriteriaNode;
import org.refcodes.criteria.CriteriaSugar;
import org.refcodes.data.CharSet;
import org.refcodes.data.QuotationMark;
import org.refcodes.data.Wildcard;
import org.refcodes.struct.Property;
import org.refcodes.struct.PropertyImpl;
import org.refcodes.textual.EscapeTextBuilder;
import org.refcodes.textual.EscapeTextMode;
import org.refcodes.textual.ReplaceTextBuilder;

public class ExpressionCriteriaFactory
implements CriteriaFactory<String> {
    private static final Pattern PATTERN = Pattern.compile("(?:^|\\s)" + QuotationMark.SINGLE_QUOTE.getChar() + "([^" + QuotationMark.SINGLE_QUOTE.getChar() + "]*?)" + QuotationMark.SINGLE_QUOTE.getChar() + "(?:$|\\s)", 8);
    private static final String EQUAL_WITH = "Set";
    private static final String NOT_EQUAL_WITH = "Unequal";
    private static final String LESS_OR_EQUAL_THAN = "LessEqual";
    private static final String LESS_THAN = "Less";
    private static final String GREATER_OR_EQUAL_THAN = "GreaterEqual";
    private static final String GREATER_THAN = "Greater";
    private static final String AND = "AND";
    private static final String OR = "OR";
    private static final String NOT = "NOT";
    private static final String INTERSECT = "INTERSECTION";
    private static final String NODE = "Times";
    private static final String SINGLE_QUOTE_TOKEN = "XXXSINGLEQUOTEXXX";
    private static final Property[] ESCAPE_SPECIAL_CHARS = new Property[]{new PropertyImpl(" ", "XXXSPACEXXX"), new PropertyImpl("-", "XXXMINUSXXX"), new PropertyImpl("+", "XXXPLUSXXX"), new PropertyImpl("*", "XXXASTERISKXXX"), new PropertyImpl("/", "XXXSLASHXXX"), new PropertyImpl("~", "XXXTILDEXXX"), new PropertyImpl("#", "XXXHASHXXX"), new PropertyImpl("_", "XXXUNDERSCOREXXX"), new PropertyImpl("=", "XXXEQUALXXX"), new PropertyImpl(">", "XXXGREATERXXX"), new PropertyImpl("<", "XXXLESSXXX"), new PropertyImpl("'", "XXXSINGLEQUOTEXXX")};
    private static final Property[] ESCAPE_NUMBERS = new Property[]{new PropertyImpl("1", "XXX1XXX"), new PropertyImpl("2", "XXX2XXX"), new PropertyImpl("3", "XXX3XXX"), new PropertyImpl("4", "XXX4XXX"), new PropertyImpl("5", "XXX5XXX"), new PropertyImpl("6", "XXX6XXX"), new PropertyImpl("7", "XXX7XXX"), new PropertyImpl("8", "XXX8XXX"), new PropertyImpl("9", "XXX9XXX"), new PropertyImpl("0", "XXX0XXX"), new PropertyImpl(".", "XXXDOTXXX"), new PropertyImpl(",", "XXXCOMMAXXX")};

    @Override
    public Criteria fromQuery(String aQuery) throws ParseException {
        aQuery = this.toNormalized(aQuery);
        aQuery = this.toEscaped(aQuery);
        if (Wildcard.QUERY.getValue().equals(aQuery)) {
            return null;
        }
        Parser theParser = new Parser();
        try {
            ASTNode theNode = theParser.parse(aQuery);
            if (theNode instanceof FunctionNode) {
                return this.toCriteria((FunctionNode)theNode);
            }
        }
        catch (SyntaxError e) {
            throw new ParseException(aQuery, e.getStartOffset());
        }
        throw new ParseException(aQuery, 0);
    }

    private Criteria toCriteria(FunctionNode aFunctionNode) throws ParseException {
        if (aFunctionNode.size() == 3) {
            if (aFunctionNode.get(0) instanceof SymbolNode && aFunctionNode.get(1) instanceof SymbolNode && aFunctionNode.get(2) instanceof SymbolNode) {
                return this.toCriteria((SymbolNode)aFunctionNode.get(0), (SymbolNode)aFunctionNode.get(1), aFunctionNode.get(2));
            }
            if (aFunctionNode.get(0) instanceof SymbolNode && aFunctionNode.get(1) instanceof SymbolNode && aFunctionNode.get(2) instanceof NumberNode) {
                return this.toCriteria((SymbolNode)aFunctionNode.get(0), (SymbolNode)aFunctionNode.get(1), aFunctionNode.get(2));
            }
            if (aFunctionNode.get(0) instanceof SymbolNode && aFunctionNode.get(1) instanceof FunctionNode && aFunctionNode.get(2) instanceof SymbolNode) {
                return this.toCriteria((SymbolNode)aFunctionNode.get(0), (FunctionNode)aFunctionNode.get(1), (SymbolNode)aFunctionNode.get(2));
            }
            if (aFunctionNode.get(0) instanceof SymbolNode && aFunctionNode.get(1) instanceof FunctionNode && aFunctionNode.get(2) instanceof FunctionNode) {
                return this.toCriteria((SymbolNode)aFunctionNode.get(0), (FunctionNode)aFunctionNode.get(1), (FunctionNode)aFunctionNode.get(2));
            }
            if (aFunctionNode.get(0) instanceof SymbolNode && aFunctionNode.get(1) instanceof SymbolNode && aFunctionNode.get(2) instanceof FunctionNode) {
                return this.toCriteria((SymbolNode)aFunctionNode.get(0), (SymbolNode)aFunctionNode.get(1), (FunctionNode)aFunctionNode.get(2));
            }
        }
        throw new ParseException(aFunctionNode.getString(), 0);
    }

    private Criteria toCriteria(SymbolNode aSymbolNodeA, SymbolNode aSymbolNodeB, ASTNode aSymbolNodeC) throws ParseException {
        String theUnEscapedKey = this.toUnEscapedKey(aSymbolNodeB.getString());
        Object theUnEscapedValue = this.toUnEscapedValue(aSymbolNodeC.getString());
        if (aSymbolNodeA.getString().equalsIgnoreCase(EQUAL_WITH)) {
            return CriteriaSugar.equalWith(theUnEscapedKey, theUnEscapedValue);
        }
        if (aSymbolNodeA.getString().equalsIgnoreCase(NOT_EQUAL_WITH)) {
            return CriteriaSugar.notEqualWith(theUnEscapedKey, theUnEscapedValue);
        }
        if (aSymbolNodeA.getString().equalsIgnoreCase(GREATER_THAN)) {
            return CriteriaSugar.greaterThan(theUnEscapedKey, theUnEscapedValue);
        }
        if (aSymbolNodeA.getString().equalsIgnoreCase(GREATER_OR_EQUAL_THAN)) {
            return CriteriaSugar.greaterOrEqualThan(theUnEscapedKey, theUnEscapedValue);
        }
        if (aSymbolNodeA.getString().equalsIgnoreCase(LESS_THAN)) {
            return CriteriaSugar.lessThan(theUnEscapedKey, theUnEscapedValue);
        }
        if (aSymbolNodeA.getString().equalsIgnoreCase(LESS_OR_EQUAL_THAN)) {
            return CriteriaSugar.lessOrEqualThan(theUnEscapedKey, theUnEscapedValue);
        }
        throw new ParseException(this.toUnEscapedKey("Unable to parse: " + aSymbolNodeA.getString()) + "\", \"" + theUnEscapedKey + "\" and/or \"" + theUnEscapedValue + "\"", 0);
    }

    private Criteria toCriteria(SymbolNode aSymbolNodeA, FunctionNode aFunctionNodeB, SymbolNode aSymbolNodeC) throws ParseException {
        if (aSymbolNodeA.getString().equalsIgnoreCase(NODE)) {
            Criteria theCriteria = this.toCriteria(aFunctionNodeB);
            if (aSymbolNodeC.getString().equalsIgnoreCase(OR)) {
                return CriteriaSugar.or(theCriteria);
            }
            if (aSymbolNodeC.getString().equalsIgnoreCase(AND)) {
                return CriteriaSugar.and(theCriteria);
            }
            if (aSymbolNodeC.getString().equalsIgnoreCase(INTERSECT)) {
                return CriteriaSugar.intersectWith(theCriteria);
            }
            if (aSymbolNodeC.getString().equalsIgnoreCase(NOT)) {
                return CriteriaSugar.not(theCriteria);
            }
        }
        throw new ParseException("Unable to parse: \"" + aSymbolNodeA.getString() + "\", \"" + aFunctionNodeB.getString() + "\" and/or \"" + aSymbolNodeC.getString() + "\"", 0);
    }

    private Criteria toCriteria(SymbolNode aSymbolNodeA, SymbolNode aSymbolNodeB, FunctionNode aFunctionNodeC) throws ParseException {
        if (aSymbolNodeA.getString().equalsIgnoreCase(NODE)) {
            Criteria theCriteria = this.toCriteria(aFunctionNodeC);
            if (aSymbolNodeB.getString().equalsIgnoreCase(NOT)) {
                return CriteriaSugar.not(theCriteria);
            }
        }
        throw new ParseException("Unable to parse: \"" + aSymbolNodeA.getString() + "\", \"" + aSymbolNodeB.getString() + "\" and/or \"" + aFunctionNodeC.getString() + "\"", 0);
    }

    private Criteria toCriteria(SymbolNode aSymbolNodeA, FunctionNode aFunctionNodeB, FunctionNode aFunctionNodeC) throws ParseException {
        if (aSymbolNodeA.getString().equalsIgnoreCase(NODE)) {
            Criteria theCriteriaB = this.toCriteria(aFunctionNodeB);
            Criteria theCriteriaC = this.toCriteria(aFunctionNodeC);
            if (theCriteriaB instanceof CriteriaNode) {
                CriteriaNode theCriteriaNode = (CriteriaNode)theCriteriaB;
                theCriteriaNode.addChild(theCriteriaC);
                return theCriteriaNode;
            }
        }
        throw new ParseException("Unable to parse: \"" + aSymbolNodeA.getString() + "\", \"" + aFunctionNodeB.getString() + "\" and/or \"" + aFunctionNodeC.getString() + "\"", 0);
    }

    private String toNormalized(String aText) {
        for (int i = 0; i < CharSet.QUOTES.getCharSet().length; ++i) {
            aText = aText.replaceAll("" + CharSet.QUOTES.getCharSet()[i], "" + QuotationMark.SINGLE_QUOTE.getChar());
        }
        return aText;
    }

    private String toEscaped(String aText) {
        Matcher theMatcher = PATTERN.matcher(aText);
        while (theMatcher.find()) {
            String eSubText;
            String eEscapedSubText = eSubText = theMatcher.group(1);
            eEscapedSubText = ((EscapeTextBuilder)new EscapeTextBuilder().withEscapeTextMode(EscapeTextMode.ESCAPE).withText(new String[]{eEscapedSubText})).withEscapeProperties(ESCAPE_SPECIAL_CHARS).toString();
            aText = ((ReplaceTextBuilder)new ReplaceTextBuilder().withText(new String[]{aText})).withFindText(QuotationMark.SINGLE_QUOTE.getChar() + eSubText + QuotationMark.SINGLE_QUOTE.getChar()).withReplaceText(SINGLE_QUOTE_TOKEN + eEscapedSubText + SINGLE_QUOTE_TOKEN).toString();
        }
        aText = ((EscapeTextBuilder)new EscapeTextBuilder().withEscapeTextMode(EscapeTextMode.ESCAPE).withText(new String[]{aText})).withEscapeProperties(ESCAPE_NUMBERS).toString();
        return aText;
    }

    private String toUnEscapedKey(String aText) {
        aText = ((EscapeTextBuilder)new EscapeTextBuilder().withEscapeTextMode(EscapeTextMode.UNESCAPE).withText(new String[]{aText})).withEscapeProperties(ESCAPE_NUMBERS).toString();
        aText = ((EscapeTextBuilder)new EscapeTextBuilder().withEscapeTextMode(EscapeTextMode.UNESCAPE).withText(new String[]{aText})).withEscapeProperties(ESCAPE_SPECIAL_CHARS).toString();
        return aText;
    }

    private Object toUnEscapedValue(String aText) {
        aText = ((EscapeTextBuilder)new EscapeTextBuilder().withEscapeTextMode(EscapeTextMode.UNESCAPE).withText(new String[]{aText})).withEscapeProperties(ESCAPE_NUMBERS).toString();
        aText = ((EscapeTextBuilder)new EscapeTextBuilder().withEscapeTextMode(EscapeTextMode.UNESCAPE).withText(new String[]{aText})).withEscapeProperties(ESCAPE_SPECIAL_CHARS).toString();
        try {
            Long theLong = Long.valueOf(aText);
            return theLong;
        }
        catch (NumberFormatException e1) {
            try {
                Double theDouble = Double.valueOf(aText);
                return theDouble;
            }
            catch (NumberFormatException e2) {
                if (aText.startsWith("" + QuotationMark.SINGLE_QUOTE.getChar())) {
                    aText = aText.substring(1);
                }
                if (aText.endsWith("" + QuotationMark.SINGLE_QUOTE.getChar())) {
                    aText = aText.substring(0, aText.length() - 1);
                }
                return aText;
            }
        }
    }
}

