/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class TweakableThreadFactory
implements ThreadFactory {
    private Boolean _isDaemon = null;
    private int _priority = -1;

    public TweakableThreadFactory(int aPriority, boolean isDaemon) {
        this._isDaemon = isDaemon;
        this._priority = aPriority;
    }

    public TweakableThreadFactory(int aPriority) {
        this._priority = aPriority;
    }

    public TweakableThreadFactory(boolean isDaemon) {
        this._isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(Runnable aRunnable) {
        Thread theThread = Executors.defaultThreadFactory().newThread(aRunnable);
        if (this._isDaemon != null) {
            theThread.setDaemon(this._isDaemon);
        }
        if (this._priority != -1) {
            theThread.setPriority(this._priority);
        }
        return theThread;
    }
}

