/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.controlflow;

import java.io.Serializable;
import org.refcodes.controlflow.Coupler;
import org.refcodes.mixin.IndexAccessor;
import org.refcodes.mixin.LengthAccessor;
import org.refcodes.mixin.OffsetAccessor;

public class Scope
implements Coupler,
OffsetAccessor,
LengthAccessor,
IndexAccessor {
    private int _index;
    private int _offset;
    private int _length;

    public Scope(int aOffset, int aLength) {
        this(aOffset, aLength, 0);
    }

    public Scope(int aOffset) {
        this(aOffset, -1, 0);
    }

    private Scope(int aOffset, int aLength, int aIndex) {
        if (aOffset < 0) {
            throw new IllegalArgumentException("The offset <" + aOffset + "> must not be negative.");
        }
        if (aLength < -1) {
            throw new IllegalArgumentException("The length <" + aLength + "> must either be positive or -1 for infinite length.");
        }
        if (aIndex < 0) {
            throw new IllegalArgumentException("The index <" + aIndex + "> must not be negative.");
        }
        this._offset = aOffset;
        this._length = aLength;
        this._index = aIndex;
    }

    @Override
    public boolean hasNext() {
        return this._length == -1 || this._index < this._offset + this._length;
    }

    @Override
    public Coupler next() {
        if (this.hasNext()) {
            return new Scope(this._offset, this._length, this._index + 1);
        }
        throw new IllegalStateException("The scope with offset <" + this._offset + "> anf length <" + this._length + ">  has no successor for the current index <" + this._index + ">.");
    }

    @Override
    public boolean isValid() {
        return this._offset <= this._index && (this._length == -1 || this._index < this._offset + this._length);
    }

    @Override
    public long getIndex() {
        return this._index;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    public int getOffset() {
        return this._offset;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [offset=" + this._offset + ", length=" + (Serializable)(this._length == -1 ? "\u221e" : Integer.valueOf(this._length)) + ", index = " + this._index + "]";
    }
}

