/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import java.io.IOException;
import org.refcodes.component.AbstractConnectable;
import org.refcodes.component.ConnectableComponent;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.controlflow.ControlFlowUtility;

public abstract class AbstractConnectableAutomaton
extends AbstractConnectable
implements ConnectableComponent.ConnectableAutomaton {
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;

    @Override
    public boolean isOpened() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public boolean isClosable() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public void close() throws IOException {
        ControlFlowUtility.throwIllegalStateException(!this.isOpened() && !this.isClosed());
        this.setConnectionStatus(ConnectionStatus.CLOSED);
    }

    @Override
    public boolean isClosed() {
        return this._connectionStatus == ConnectionStatus.CLOSED;
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    protected boolean isOpenable() {
        return !this.isOpened();
    }

    protected void open() throws IOException {
        if (this.isOpened()) {
            throw new IOException("Unable to open the connection is is is ALREADY OPEN; connection status is " + this.getConnectionStatus() + ".");
        }
        this.setConnectionStatus(ConnectionStatus.OPENED);
    }

    protected void setConnectionStatus(ConnectionStatus aConnectionStatus) {
        this._connectionStatus = aConnectionStatus;
    }
}

