/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.archetype;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import org.refcodes.data.Delimiter;
import org.refcodes.io.FileUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.properties.Properties;
import org.refcodes.properties.TomlProperties;
import org.refcodes.properties.TomlPropertiesBuilder;
import org.refcodes.runtime.Execution;

public class C2Helper {
    private static final String DEFAULT_INSTANCE_ALIAS = "lock";
    private RuntimeLogger LOGGER;
    private String _instanceAlias;
    private Class<?> _resourceLocator;

    public C2Helper(String aInstanceAlias, Class<?> aResourceLocator, boolean isVerbose, boolean isForce, RuntimeLogger aLogger) throws IOException {
        this.LOGGER = aLogger != null ? aLogger : RuntimeLoggerFactorySingleton.createRuntimeLogger();
        this._resourceLocator = this.toResourceLocator(aResourceLocator);
        this._instanceAlias = this.toInstanceAlias(aInstanceAlias);
        if (isForce) {
            this.deleteLockFile(isVerbose);
        }
    }

    private C2Helper(Builder builder) throws IOException {
        this(builder.instanceAlias, builder.resourceLocator, builder.isVerbose, builder.isForce, builder.logger);
    }

    public void deleteLockFile(boolean isVerbose) throws IOException {
        File theLockFile = FileUtility.openTempFile(this.getLockFileName());
        if (theLockFile.exists() && theLockFile.isFile()) {
            if (isVerbose) {
                this.LOGGER.info("Deleting C2-lockfile <" + theLockFile.getAbsolutePath() + "> ...");
            }
            theLockFile.delete();
        }
    }

    public String getInstanceAlias() {
        return this._instanceAlias;
    }

    public String getLockFileName() {
        return this._resourceLocator.getPackageName() + Delimiter.PACKAGE_HIERARCHY.getChar() + this._instanceAlias;
    }

    public Properties readLockFile(boolean isVerbose) throws IOException, ParseException {
        File theLockFile = FileUtility.openTempFile(this.getLockFileName());
        if (theLockFile.exists() && theLockFile.isFile()) {
            if (isVerbose) {
                this.LOGGER.info("Reading C2-lockfile <" + theLockFile.getAbsolutePath() + "> ...");
            }
            return new TomlProperties(theLockFile);
        }
        return null;
    }

    public void writeLockFile(Properties aProperties, boolean isVerbose) throws IOException {
        File theLockFile = FileUtility.createTempFile(this.getLockFileName(), true);
        if (isVerbose) {
            this.LOGGER.info("Writing C2-lockfile <" + theLockFile.getAbsolutePath() + "> ...");
        }
        new TomlPropertiesBuilder(aProperties).saveTo(theLockFile);
    }

    private String toInstanceAlias(String aInstanceAlias) {
        return aInstanceAlias != null ? aInstanceAlias : (this._resourceLocator != this.getClass() ? this._resourceLocator.getSimpleName() : DEFAULT_INSTANCE_ALIAS);
    }

    private Class<?> toResourceLocator(Class<?> aResourceLocator) {
        if (aResourceLocator == null && (aResourceLocator = Execution.getMainClass()) == null && (aResourceLocator = Execution.getCallerType(Builder.class)) == null && (aResourceLocator = Execution.getCallerType(this.getClass())) == null) {
            aResourceLocator = this.getClass();
        }
        return aResourceLocator;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private RuntimeLogger logger = null;
        private String instanceAlias = null;
        private Class<?> resourceLocator = null;
        private boolean isVerbose = true;
        private boolean isForce = false;

        private Builder() {
        }

        public C2Helper build() throws IOException {
            return new C2Helper(this);
        }

        public Builder withForce(boolean isForce) {
            this.isForce = isForce;
            return this;
        }

        public Builder withInstanceAlias(String aInstanceAlias) {
            this.instanceAlias = aInstanceAlias;
            return this;
        }

        public Builder withLogger(RuntimeLogger aLogger) {
            this.logger = aLogger;
            return this;
        }

        public Builder withResourceClass(Class<?> aResourceLocator) {
            this.resourceLocator = aResourceLocator;
            return this;
        }

        public Builder withVerbose(boolean isVerbose) {
            this.isVerbose = isVerbose;
            return this;
        }
    }
}

