/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.archetype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.ArgsFilter;
import org.refcodes.cli.ArgsProcessorBuilder;
import org.refcodes.cli.ArgsProvidierBuilder;
import org.refcodes.cli.Example;
import org.refcodes.cli.Operand;
import org.refcodes.cli.SyntaxMetrics;
import org.refcodes.cli.SyntaxNotation;
import org.refcodes.cli.Term;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.properties.ResourceLoaderBuilder;
import org.refcodes.runtime.ConfigLocator;
import org.refcodes.runtime.Execution;
import org.refcodes.textual.Font;
import org.refcodes.textual.TextBoxGrid;
import org.refcodes.textual.TextBoxStyle;

abstract class AbstractCliBuilder<B extends AbstractCliBuilder<B, R>, R>
implements ArgsProcessorBuilder<AbstractCliBuilder<B, R>>,
ResourceLoaderBuilder<AbstractCliBuilder<B, R>>,
ArgsProvidierBuilder<AbstractCliBuilder<B, R>> {
    protected Character shortOptionPrefix;
    protected String longOptionPrefix;
    protected String name = null;
    protected String passwordPrompt = null;
    protected String emptyArgsMessage = null;
    protected String[] args = null;
    protected Term argsSyntax = null;
    protected Font bannerFont = null;
    protected char[] bannerFontPalette = null;
    protected String copyright = null;
    protected String description = null;
    protected Collection<Example> examples = new ArrayList<Example>();
    protected String license = null;
    protected RuntimeLogger logger = null;
    protected String title = null;
    protected boolean verboseFallback = false;
    protected Consumer<Integer> shutDownHook = null;
    protected Integer consoleWidth = null;
    protected Integer maxConsoleWidth = null;
    protected Boolean escCodesEnabled = null;
    protected TextBoxGrid textBoxGrid = null;
    protected String lineBreak = null;
    protected String descriptionEscCode = null;
    protected String commandEscCode = null;
    protected String bannerEscCode = null;
    protected String bannerBorderEscCode = null;
    protected String resetEscCode = null;
    protected String optionEscCode = null;
    protected String argumentEscCode = null;
    protected SyntaxMetrics syntaxMetrics = null;
    protected File file = null;
    protected ConfigLocator configLocator = ConfigLocator.DEFAULT;
    protected char[] delimiters = null;
    protected InputStream inputStream = null;
    protected Class<?> resourceClass = null;
    protected String filePath = null;
    protected URL url = null;
    protected String lineSeparatorEscCode;
    protected Character separatorLnChar;
    protected CliHelper.ArgsParseMessageMode argsParseMessageMode = CliHelper.ArgsParseMessageMode.HEURISTIC;
    protected PrintStream standardOut;
    protected PrintStream errorOut;

    protected AbstractCliBuilder() {
    }

    public abstract R build();

    @Override
    public B withAddExample(Example aExamples) {
        this.examples.add(aExamples);
        return (B)this;
    }

    @Override
    public B withAddExample(String aDescription, Operand<?> ... aOperands) {
        this.withAddExample(new Example(aDescription, aOperands));
        return (B)this;
    }

    @Override
    public B withArgs(List<String> aArgs) {
        this.args = aArgs.toArray(new String[aArgs.size()]);
        return (B)this;
    }

    @Override
    public B withArgs(List<String> aArgs, ArgsFilter aArgsFilter) {
        return (B)this.withArgs((List)aArgsFilter.toFiltered(aArgs));
    }

    @Override
    public B withArgs(List<String> aArgs, Pattern aFilterExp) {
        return (B)this.withArgs(ArgsFilter.toFiltered(aArgs.toArray(new String[aArgs.size()]), aFilterExp));
    }

    @Override
    public B withArgs(String[] aArgs) {
        this.args = aArgs;
        return (B)this;
    }

    @Override
    public B withArgs(String[] aArgs, ArgsFilter aArgsFilter) {
        return (B)this.withArgs(aArgsFilter.toFiltered(aArgs));
    }

    @Override
    public B withArgs(String[] aArgs, Pattern aFilterExp) {
        return (B)this.withArgs(ArgsFilter.toFiltered(aArgs, aFilterExp));
    }

    public B withArgsParseMessageMode(CliHelper.ArgsParseMessageMode aArgsParseMessageMode) {
        this.argsParseMessageMode = aArgsParseMessageMode;
        return (B)this;
    }

    @Override
    public B withArgsSyntax(Term aArgsSyntax) {
        this.argsSyntax = aArgsSyntax;
        return (B)this;
    }

    @Override
    public B withArgumentEscapeCode(String aArgumentEscCode) {
        this.argumentEscCode = aArgumentEscCode;
        return (B)this;
    }

    @Override
    public B withBannerBorderEscapeCode(String aBannerBorderEscCode) {
        this.bannerBorderEscCode = aBannerBorderEscCode;
        return (B)this;
    }

    @Override
    public B withBannerEscapeCode(String aBannerEscCode) {
        this.bannerEscCode = aBannerEscCode;
        return (B)this;
    }

    @Override
    public B withBannerFont(Font aBannerFont) {
        this.bannerFont = aBannerFont;
        return (B)this;
    }

    @Override
    public B withBannerFontPalette(AsciiColorPalette aBannerFontPalette) {
        this.bannerFontPalette = aBannerFontPalette.getPalette();
        return (B)this;
    }

    @Override
    public B withBannerFontPalette(char[] aBannerFontPalette) {
        this.bannerFontPalette = aBannerFontPalette;
        return (B)this;
    }

    @Override
    public B withCommandEscapeCode(String aCommandEscCode) {
        this.commandEscCode = aCommandEscCode;
        return (B)this;
    }

    public B withConfigLocator(ConfigLocator aConfigLocator) {
        this.configLocator = aConfigLocator;
        return (B)this;
    }

    @Override
    public B withConsoleWidth(int aConsoleWidth) {
        this.consoleWidth = aConsoleWidth;
        return (B)this;
    }

    @Override
    public B withCopyright(String aCopyright) {
        this.copyright = aCopyright;
        return (B)this;
    }

    @Override
    public B withDescription(String aDescription) {
        this.description = aDescription;
        return (B)this;
    }

    @Override
    public B withDescriptionEscapeCode(String aDescriptionEscCode) {
        this.descriptionEscCode = aDescriptionEscCode;
        return (B)this;
    }

    public B withEmptyArgsMessage(String aEmptyArgsMessage) {
        this.emptyArgsMessage = aEmptyArgsMessage;
        return (B)this;
    }

    @Override
    public B withErrorOut(PrintStream aErrorOut) {
        this.errorOut = aErrorOut;
        return (B)this;
    }

    @Override
    public B withEscapeCodesEnabled(boolean isEscCodesEnabled) {
        this.escCodesEnabled = isEscCodesEnabled;
        return (B)this;
    }

    @Override
    public B withExamples(Collection<Example> aExamples) {
        this.examples.addAll(aExamples);
        return (B)this;
    }

    @Override
    public B withExamples(Example[] aExamples) {
        this.examples = Arrays.asList(aExamples);
        return (B)this;
    }

    @Override
    public B withFile(File aFile) throws IOException, ParseException {
        return (B)this.withFile(aFile, ConfigLocator.ALL);
    }

    @Override
    public B withFile(File aFile, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this.file = aFile;
        this.configLocator = aConfigLocator;
        this.inputStream = null;
        this.resourceClass = null;
        this.filePath = null;
        this.url = null;
        return (B)this;
    }

    public B withFilePath(String aFilePath) {
        this.filePath = aFilePath;
        return (B)this;
    }

    @Override
    public B withInputStream(InputStream aInputStream) throws IOException, ParseException {
        this.inputStream = aInputStream;
        return (B)this;
    }

    @Override
    public B withLicense(String aLicense) {
        this.license = aLicense;
        return (B)this;
    }

    @Override
    public B withLineBreak(String aLineBreak) {
        this.lineBreak = aLineBreak;
        return (B)this;
    }

    @Override
    public B withLineSeparatorEscapeCode(String aLineSeparatorEscCode) {
        this.lineSeparatorEscCode = aLineSeparatorEscCode;
        return (B)this;
    }

    public B withLogger(RuntimeLogger aLogger) {
        this.logger = aLogger;
        return (B)this;
    }

    @Override
    public B withLongOptionPrefix(String aLongOptionPrefix) {
        this.longOptionPrefix = aLongOptionPrefix;
        return (B)this;
    }

    @Override
    public B withMaxConsoleWidth(int aMaxConsoleWidth) {
        this.maxConsoleWidth = aMaxConsoleWidth;
        return (B)this;
    }

    @Override
    public B withName(String aName) {
        this.name = aName;
        return (B)this;
    }

    @Override
    public B withOptionEscapeCode(String aOptionEscCode) {
        this.optionEscCode = aOptionEscCode;
        return (B)this;
    }

    public B withPasswordPrompt(String aPasswordPrompt) {
        this.passwordPrompt = aPasswordPrompt;
        return (B)this;
    }

    @Override
    public B withResetEscapeCode(String aResetEscCode) {
        this.resetEscCode = aResetEscCode;
        return (B)this;
    }

    public B withResourceClass(Class<?> aResourceClass) {
        this.resourceClass = aResourceClass;
        return (B)this;
    }

    @Override
    public B withResourceClass(Class<?> aResourceClass, String aFilePath) throws IOException, ParseException {
        return (B)this.withResourceClass((Class)aResourceClass, aFilePath, ConfigLocator.ALL);
    }

    @Override
    public B withResourceClass(Class<?> aResourceClass, String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        this.file = null;
        this.configLocator = aConfigLocator;
        this.inputStream = null;
        this.resourceClass = aResourceClass;
        this.filePath = aFilePath;
        this.url = null;
        return (B)this;
    }

    @Override
    public B withResourceClass(String aFilePath) throws IOException, ParseException {
        return (B)this.withResourceClass(Execution.getMainClass(), aFilePath, ConfigLocator.ALL);
    }

    @Override
    public B withResourceClass(String aFilePath, ConfigLocator aConfigLocator) throws IOException, ParseException {
        return (B)this.withResourceClass((Class)null, aFilePath, aConfigLocator);
    }

    @Override
    public B withSeparatorLnChar(char aSeparatorLnChar) {
        this.separatorLnChar = Character.valueOf(aSeparatorLnChar);
        return (B)this;
    }

    @Override
    public B withShortOptionPrefix(Character aShortOptionPrefix) {
        this.shortOptionPrefix = aShortOptionPrefix;
        return (B)this;
    }

    public B withShutDownHook(Consumer<Integer> aShutDownHook) {
        this.shutDownHook = aShutDownHook;
        return (B)this;
    }

    @Override
    public B withStandardOut(PrintStream aStandardOut) {
        this.standardOut = aStandardOut;
        return (B)this;
    }

    @Override
    public B withSyntaxMetrics(SyntaxMetrics aSyntaxMetrics) {
        this.syntaxMetrics = aSyntaxMetrics;
        return (B)this;
    }

    @Override
    public B withSyntaxMetrics(SyntaxNotation aSyntaxNotation) {
        return (B)this.withSyntaxMetrics((SyntaxMetrics)aSyntaxNotation);
    }

    @Override
    public B withTextBoxGrid(TextBoxGrid aTextBoxGrid) {
        this.textBoxGrid = aTextBoxGrid;
        return (B)this;
    }

    @Override
    public B withTextBoxGrid(TextBoxStyle aTextBoxStyle) {
        this.textBoxGrid = aTextBoxStyle;
        return (B)this;
    }

    @Override
    public B withTitle(String aTitle) {
        this.title = aTitle;
        return (B)this;
    }

    @Override
    public B withUrl(URL aUrl) throws IOException, ParseException {
        this.file = null;
        this.configLocator = null;
        this.inputStream = null;
        this.resourceClass = null;
        this.filePath = null;
        this.url = aUrl;
        return (B)this;
    }

    public B withVerboseFallback(boolean aVerboseFallback) {
        this.verboseFallback = aVerboseFallback;
        return (B)this;
    }
}

