/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.server.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.eval.ComplexEvaluator;
import org.matheclipse.parser.client.eval.DoubleEvaluator;
import org.matheclipse.parser.client.math.Complex;
import org.matheclipse.parser.client.math.MathException;
import org.refcodes.exception.Trap;
import org.refcodes.runtime.SystemProperty;

public class Console {
    private File fFile;
    private boolean fComplexEvaluatorMode = false;

    public static void main(String[] args) {
        Console.printUsage();
        Console console = new Console();
        String expr = null;
        console.setArgs(args);
        File file = console.getFile();
        if (file != null) {
            try (BufferedReader f = new BufferedReader(new FileReader(file));){
                String line;
                StringBuilder buff = new StringBuilder(1024);
                while ((line = f.readLine()) != null) {
                    buff.append(line);
                    buff.append("\n");
                }
                System.out.println(console.interpreter(buff.toString()));
            }
            catch (IOException ioe) {
                String msg = "Cannot read from the specified file. Make sure the path exists and you have read permission.";
                System.out.println("Cannot read from the specified file. Make sure the path exists and you have read permission.");
                return;
            }
        }
        block10: while (true) {
            try {
                while (true) {
                    if ((expr = console.readString(System.out, ">>> ")) == null) {
                        continue;
                    }
                    if (expr.length() >= 4 && "exit".equals(expr.toLowerCase().substring(0, 4))) break block10;
                    if (expr.length() >= 6 && "double".equals(expr.toLowerCase().substring(0, 6))) {
                        console.fComplexEvaluatorMode = false;
                        System.out.println("Double evaluation mode (switch to other mode with keyword 'complex')");
                        continue;
                    }
                    if (expr.length() >= 7 && "complex".equals(expr.toLowerCase().substring(0, 7))) {
                        console.fComplexEvaluatorMode = true;
                        System.out.println("Complex evaluation mode (switch to other mode with keyword 'double')");
                        continue;
                    }
                    System.out.println(console.interpreter(expr));
                }
            }
            catch (Exception e) {
                System.out.println(Trap.asMessage(e));
                continue;
            }
            break;
        }
    }

    private static void printUsage() {
        String lineSeparator = SystemProperty.LINE_SEPARATOR.getValue();
        StringBuilder msg = new StringBuilder();
        msg.append(Console.class.getCanonicalName() + " [options]" + lineSeparator);
        msg.append(lineSeparator);
        msg.append("Options: " + lineSeparator);
        msg.append("  -d or -double                use Double evaluation mode" + lineSeparator);
        msg.append("  -c or -complex               use Complex evaluation mode" + lineSeparator);
        msg.append("  -h or -help                  print this aMessage" + lineSeparator);
        msg.append("  -f or -file <filename>       use given file as input" + lineSeparator);
        msg.append("To stop the program type: " + lineSeparator);
        msg.append("exit<RETURN-KEY>" + lineSeparator);
        msg.append("To switch between the evaluation modes type: " + lineSeparator);
        msg.append("complex<RETURN-KEY> or" + lineSeparator);
        msg.append("double<RETURN-KEY>" + lineSeparator);
        msg.append("To continue an input line type '\\' at the end of the line." + lineSeparator);
        msg.append("****+****+****+****+****+****+****+****+****+****+****+****+");
        System.out.println(msg.toString());
    }

    private void setArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-double".equals(arg) || "-d".equals(arg)) {
                this.fComplexEvaluatorMode = false;
                return;
            }
            if ("-complex".equals(arg) || "-c".equals(arg)) {
                this.fComplexEvaluatorMode = true;
                return;
            }
            if ("-help".equals(arg) || "-h".equals(arg)) {
                Console.printUsage();
                return;
            }
            if ("-file".equals(arg) || "-f".equals(arg)) {
                try {
                    this.fFile = new File(args[i + 1]);
                    ++i;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    String msg = "You must specify a file when using the -file argument";
                    System.out.println("You must specify a file when using the -file argument");
                    return;
                }
            }
            if (!arg.startsWith("-")) continue;
            String msg = "Unknown arg: " + arg;
            System.out.println(msg);
            Console.printUsage();
            return;
        }
    }

    public String interpreter(String strEval) {
        try {
            if (this.fComplexEvaluatorMode) {
                Parser p = new Parser();
                ASTNode obj = p.parse(strEval);
                ComplexEvaluator engine = new ComplexEvaluator();
                if (obj instanceof FunctionNode) {
                    obj = engine.optimizeFunction((FunctionNode)obj);
                }
                Complex c = (Complex)engine.evaluateNode(obj);
                return ComplexEvaluator.toString(c);
            }
            DoubleEvaluator engine = new DoubleEvaluator();
            double d = engine.evaluate(strEval);
            return Double.toString(d);
        }
        catch (MathException e) {
            System.err.println();
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public void printPrompt(PrintStream out, String prompt) {
        out.print(prompt);
        out.flush();
    }

    public String readString(PrintStream out) {
        StringBuilder input = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean done = false;
        try {
            while (!done) {
                String s = in.readLine();
                if (s == null) continue;
                if (s.length() > 0 && s.charAt(s.length() - 1) != '\\') {
                    input.append(s);
                    done = true;
                    continue;
                }
                if (s.length() > 1) {
                    input.append(s.substring(0, s.length() - 1));
                    continue;
                }
                input.append(" ");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return input.toString();
    }

    public String readString(PrintStream out, String prompt) {
        this.printPrompt(out, prompt);
        return this.readString(out);
    }

    public void setFile(File file) {
        this.fFile = file;
    }

    public File getFile() {
        return this.fFile;
    }
}

