/*
 * Decompiled with CFR 0.152.
 */
package club.funcodes.httpecho;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.util.List;
import java.util.regex.Pattern;
import org.refcodes.archetype.CliHelper;
import org.refcodes.cli.CasesCondition;
import org.refcodes.cli.CliSugar;
import org.refcodes.cli.DebugFlag;
import org.refcodes.cli.EnumOption;
import org.refcodes.cli.Example;
import org.refcodes.cli.Flag;
import org.refcodes.cli.HelpFlag;
import org.refcodes.cli.IntOption;
import org.refcodes.cli.NoneOperand;
import org.refcodes.cli.StringOption;
import org.refcodes.cli.SysInfoFlag;
import org.refcodes.cli.VerboseFlag;
import org.refcodes.data.AsciiColorPalette;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.net.PortManagerSingleton;
import org.refcodes.properties.JavaPropertiesBuilder;
import org.refcodes.properties.JsonPropertiesBuilder;
import org.refcodes.properties.Properties;
import org.refcodes.properties.PropertiesBuilderImpl;
import org.refcodes.properties.ResourcePropertiesFactory;
import org.refcodes.properties.TomlPropertiesBuilder;
import org.refcodes.properties.XmlPropertiesBuilder;
import org.refcodes.properties.YamlPropertiesBuilder;
import org.refcodes.rest.HttpRestServerSugar;
import org.refcodes.textual.Font;
import org.refcodes.textual.FontFamily;
import org.refcodes.textual.FontStyle;
import org.refcodes.textual.VerboseTextBuilder;
import org.refcodes.time.DateFormat;
import org.refcodes.web.HttpFields;

public class Main {
    private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String NAME = "httpecho";
    private static final String TITLE = "HTTP\u2b95ECHO";
    private static final String DESCRIPTION = "Small HTTP-Echo server echoing incoming HTTP-Requests back to the client and to the console (see [https://www.metacodes.pro/manpages/httpecho_manpage]).";
    private static final String LICENSE_NOTE = "Licensed under GNU General Public License, v3.0 and Apache License, v2.0";
    private static final String COPYRIGHT = "Copyright (c) by CLUB.FUNCODES | See [https://www.metacodes.pro/manpages/httpecho_manpage]";
    private static final char[] BANNER_PALETTE = AsciiColorPalette.MAX_LEVEL_GRAY.getPalette();
    private static final Font BANNER_FONT = new Font(FontFamily.DIALOG, FontStyle.BOLD);
    private static final String HTTP_REQUEST_SECTION = "httpRequest";
    private static final String META_DATA_SECTION = "metaData";
    private static final String SERVER_SECTION = "server";

    public static void main(String[] args) {
        NoneOperand theNoneArg = CliSugar.none("Starts with the default configuration.");
        IntOption thePortArg = CliSugar.intOption(Character.valueOf('p'), "port", "port", "Sets the port for the server.");
        IntOption theMaxConnsArg = CliSugar.intOption(Character.valueOf('c'), "connections", "connections", "Sets the number of max. connections.");
        Flag theHeaderFlag = CliSugar.flag(Character.valueOf('H'), "header", "header", "Echo the HTTP-Header: When specified, then URL-Path, URL-Query and HTTP-Body are only echoed when the according switches are set.");
        Flag theBodyFlag = CliSugar.flag(Character.valueOf('B'), "body", "body", "Echo the HTTP-Body: When specified, then URL-Path, URL-Query and HTTP-Header are only echoed when the according switches are set.");
        Flag thePathFlag = CliSugar.flag(Character.valueOf('P'), "path", "path", "Echo the URL-Path: When specified, then URL-Query, HTTP-Header and HTTP-Body are only echoed when the according switches are set.");
        Flag theQueryFlag = CliSugar.flag(Character.valueOf('Q'), "query", "query", "Echo the URL-Query: When specified, then URL-Path, HTTP-Header and HTTP-Body are only echoed when the according switches are set.");
        Flag theDateFlag = CliSugar.flag(Character.valueOf('D'), "date", "date", "Include the current local date when echoing an HTTP-Request.");
        Flag theEchoFlag = CliSugar.flag(Character.valueOf('e'), "echo", "echo", "Echo the HTTP-Request back as HTTP-Response.");
        EnumOption<Notation> theNotationArg = CliSugar.enumOption(null, "notation", Notation.class, "notation", "The output notation such as: " + new VerboseTextBuilder().toString((Object[])Notation.values()));
        StringOption theUrlArg = CliSugar.stringOption(Character.valueOf('u'), "url-pattern", "urlPattern", "The ant-like pattern supporting wildcards (\"*\", \"**\", \"?\") for the URL to observe. You might need to escape a trailing slash '/' with a backslash '\\', e.g. \"\\/my\\/url\\/**\".");
        VerboseFlag theVerboseFlag = CliSugar.verboseFlag();
        SysInfoFlag theSysInfoFlag = CliSugar.sysInfoFlag(false);
        HelpFlag theHelpFlag = CliSugar.helpFlag();
        DebugFlag theDebugFlag = CliSugar.debugFlag();
        CasesCondition theArgsSyntax = CliSugar.cases(CliSugar.xor(theNoneArg, CliSugar.any(thePortArg, theMaxConnsArg, theDateFlag, theEchoFlag, thePathFlag, theQueryFlag, theHeaderFlag, theBodyFlag, theUrlArg, theNotationArg, theVerboseFlag, theDebugFlag)), CliSugar.xor(theHelpFlag, CliSugar.and(theSysInfoFlag, CliSugar.any(theVerboseFlag))));
        Example[] theExamples = CliSugar.examples(CliSugar.example("Echos HTTP messages from port", thePortArg, theVerboseFlag), CliSugar.example("Echos HTTP messages to HTTP-Response from port", thePortArg, theEchoFlag, theVerboseFlag), CliSugar.example("Echos just the HTTP body from port", thePortArg, theHeaderFlag, theVerboseFlag), CliSugar.example("Echos just the HTTP body from port", thePortArg, theBodyFlag, theVerboseFlag), CliSugar.example("Echos just the HTTP path and query from port", thePortArg, thePathFlag, theQueryFlag, theVerboseFlag), CliSugar.example("Echos HTTP messages from port using specific notation", thePortArg, theNotationArg, theVerboseFlag), CliSugar.example("Include local date when echoing HTTP messages from port", thePortArg, theDateFlag, theVerboseFlag), CliSugar.example("To show the help text", theHelpFlag), CliSugar.example("To print the system info", theSysInfoFlag));
        CliHelper theCliHelper = ((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)((CliHelper.Builder)CliHelper.builder().withArgs(args)).withArgsSyntax(theArgsSyntax)).withExamples(theExamples)).withResourceClass((Class)Main.class)).withName(NAME)).withTitle(TITLE)).withDescription(DESCRIPTION)).withLicense(LICENSE_NOTE)).withCopyright(COPYRIGHT)).withBannerFont(BANNER_FONT)).withBannerFontPalette(BANNER_PALETTE)).withLogger(LOGGER)).build();
        boolean isVerbose = theVerboseFlag.isEnabled();
        try {
            boolean isBody;
            boolean isHeader;
            boolean isQuery;
            boolean isPath;
            Notation theNotation = theNotationArg.getValueOr(Notation.JSON);
            int theMaxConnections = theMaxConnsArg.getValue() != null ? (Integer)theMaxConnsArg.getValue() : -1;
            String theUrlPattern = theUrlArg.getValueOr("**").replaceAll(Pattern.quote("\\/"), "/");
            boolean isDate = theDateFlag.isEnabled();
            boolean isEcho = theEchoFlag.isEnabled();
            if (!(thePathFlag.isEnabled() || theQueryFlag.isEnabled() || theHeaderFlag.isEnabled() || theBodyFlag.isEnabled())) {
                isPath = true;
                isQuery = true;
                isHeader = true;
                isBody = true;
            } else {
                isPath = thePathFlag.isEnabled();
                isQuery = theQueryFlag.isEnabled();
                isHeader = theHeaderFlag.isEnabled();
                isBody = theBodyFlag.isEnabled();
            }
            HttpRestServerSugar.onRequest(theUrlPattern, (req, res) -> {
                PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
                ByteArrayOutputStream theReqBody = new ByteArrayOutputStream();
                try {
                    req.getHttpInputStream().transferTo(theReqBody);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (isDate) {
                    Main.echoMetaData(theProperties, "date", DateFormat.ISO_LOCAL_DATE_TIME.getFormatter().format(LocalDateTime.now()));
                }
                if (isPath) {
                    Main.echoLine(theProperties, "path", req.getUrl().getPath());
                }
                if (isQuery) {
                    Main.echoHttpFields(theProperties, "query", req.getUrl().getQueryFields());
                }
                if (isHeader) {
                    Main.echoHttpFields(theProperties, "header", req.getHeaderFields());
                }
                if (isBody) {
                    Main.echoInputStream(theProperties, "body", new ByteArrayInputStream(theReqBody.toByteArray()));
                }
                System.out.println(theNotation.notationFactory.toProperties(theProperties).toSerialized());
                if (isEcho) {
                    res.getHeaderFields().addAll(req.getHeaderFields());
                    res.setResponse(new ByteArrayInputStream(theReqBody.toByteArray()));
                }
            }).open();
            int thePort = thePortArg.getValueOr(PortManagerSingleton.getInstance().bindAnyPort());
            HttpRestServerSugar.open(thePort, theMaxConnections);
            if (isVerbose) {
                LOGGER.info("Port = <" + thePort + ">");
                LOGGER.info("URL pattern = \"" + theUrlPattern + "\"");
                LOGGER.info("Notation  = <" + theNotation.name() + ">");
                LOGGER.info("Include local date = <" + (isDate ? "YES" : "NO") + ">");
                LOGGER.info("Show PATH = <" + (isPath ? "YES" : "NO") + ">");
                LOGGER.info("Show QUERY = <" + (isQuery ? "YES" : "NO") + ">");
                LOGGER.info("Show HEADER = <" + (isHeader ? "YES" : "NO") + ">");
                LOGGER.info("Show BODY = <" + (isBody ? "YES" : "NO") + ">");
                LOGGER.info("Echo HTTP-Request to HTTP-Response = <" + (isEcho ? "YES" : "NO") + ">");
                LOGGER.printTail();
            } else {
                PropertiesBuilderImpl theProperties = new PropertiesBuilderImpl();
                theProperties.putInt("server/port", (Integer)thePort);
                theProperties.put("server/urlPattern", theUrlPattern);
                theProperties.put("server/notation", theNotation.name());
                theProperties.putBoolean("server/date", (Boolean)isDate);
                theProperties.putBoolean("server/path", (Boolean)isPath);
                theProperties.putBoolean("server/query", (Boolean)isQuery);
                theProperties.putBoolean("server/header", (Boolean)isHeader);
                theProperties.putBoolean("server/body", (Boolean)isBody);
                theProperties.putBoolean("server/echo", (Boolean)isEcho);
                System.out.println(theNotation.notationFactory.toProperties(theProperties).toSerialized());
            }
        }
        catch (Throwable e) {
            theCliHelper.exitOnException(e);
        }
    }

    private static void echoInputStream(Properties.PropertiesBuilder aProperties, String aSection, InputStream aInputStream) {
        if (aInputStream != null) {
            BufferedReader theBufferedReader = new BufferedReader(new InputStreamReader(aInputStream), 1);
            int index = 0;
            try {
                String eLine;
                while ((eLine = theBufferedReader.readLine()) != null) {
                    aProperties.putValueAt("httpRequest/" + aSection, index++, eLine);
                }
            }
            catch (IOException e) {
                System.err.println(e.getClass().getName() + ": " + e.getMessage());
            }
        }
    }

    private static void echoHttpFields(Properties.PropertiesBuilder aProperties, String aSection, HttpFields<?> aHttpFields) {
        if (aHttpFields != null && aHttpFields.size() != 0) {
            for (String eKey : aHttpFields.keySet()) {
                List eHeaderValue = (List)aHttpFields.get(eKey);
                if (eHeaderValue.size() == 1) {
                    aProperties.put("httpRequest/" + aSection + "/" + eKey, (String)eHeaderValue.get(0));
                    continue;
                }
                aProperties.putArray("httpRequest/" + aSection + "/" + eKey, eHeaderValue);
            }
        }
    }

    private static void echoLine(Properties.PropertiesBuilder aProperties, String aSection, String aLine) {
        if (aLine != null) {
            aProperties.put("httpRequest/" + aSection, aLine);
        }
    }

    private static void echoMetaData(Properties.PropertiesBuilder aProperties, String aSection, String aLine) {
        if (aLine != null) {
            aProperties.put("metaData/" + aSection, aLine);
        }
    }

    private static enum Notation {
        INI(new TomlPropertiesBuilder.TomlPropertiesBuilderFactory()),
        JAVA(new JavaPropertiesBuilder.JavaPropertiesBuilderFactory()),
        JSON(new JsonPropertiesBuilder.JsonPropertiesBuilderFactory()),
        TOML(new TomlPropertiesBuilder.TomlPropertiesBuilderFactory()),
        XML(new XmlPropertiesBuilder.XmlPropertiesBuilderFactory()),
        YAML(new YamlPropertiesBuilder.YamlPropertiesBuilderFactory());

        ResourcePropertiesFactory.ResourcePropertiesBuilderFactory notationFactory;

        private Notation(ResourcePropertiesFactory.ResourcePropertiesBuilderFactory aNotationFactory) {
            this.notationFactory = aNotationFactory;
        }
    }
}

