/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.numerical;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.CharSet;
import org.refcodes.data.Encoding;

public final class NumericalUtility {
    private static final int BYTE_MASK = 255;
    private static final int BYTES_PER_INT = 4;
    private static final int BYTES_PER_LONG = 8;
    private static final long BITS_PER_BYTE = 8L;
    private static final BigInteger UNSIGNED_LONG_MASK = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);

    private NumericalUtility() {
    }

    public static String toNumberBase(long aValue, int aToBase) {
        int[] theDigits = NumericalUtility.toDigits(aValue, aToBase);
        StringBuilder theBuilder = new StringBuilder();
        for (int eDigit : theDigits) {
            theBuilder.append(CharSet.ARABIC_BASE64.getCharSet()[eDigit]);
        }
        return theBuilder.toString();
    }

    public static long fromNumberBase(int aFromBase, String aDigits) {
        int[] theDigits = new int[aDigits.length()];
        for (int i = 0; i < theDigits.length; ++i) {
            theDigits[i] = NumericalUtility.toIndex(aDigits.charAt(i), CharSet.ARABIC_BASE64.getCharSet());
        }
        return NumericalUtility.fromDigits(aFromBase, theDigits);
    }

    public static String convertNumberBase(int aFromBase, String aDigits, int aToBase) {
        return NumericalUtility.toNumberBase(NumericalUtility.fromNumberBase(aFromBase, CharSet.ARABIC_BASE64.getCharSet(), aDigits), aToBase, CharSet.ARABIC_BASE64.getCharSet());
    }

    public static String toNumberBase(long aValue, int aToBase, char[] aToCharSet) {
        int[] theDigits = NumericalUtility.toDigits(aValue, aToBase);
        StringBuilder theBuilder = new StringBuilder();
        for (int eDigit : theDigits) {
            theBuilder.append(aToCharSet[eDigit]);
        }
        return theBuilder.toString();
    }

    public static long fromNumberBase(int aFromBase, char[] aFromCharSet, String aDigits) {
        int[] theDigits = new int[aDigits.length()];
        for (int i = 0; i < theDigits.length; ++i) {
            theDigits[i] = NumericalUtility.toIndex(aDigits.charAt(i), aFromCharSet);
        }
        return NumericalUtility.fromDigits(aFromBase, theDigits);
    }

    public static String convertNumberBase(int aFromBase, char[] aFromCharSet, String aDigits, int aToBase, char[] aToCharSet) {
        return NumericalUtility.toNumberBase(NumericalUtility.fromNumberBase(aFromBase, aFromCharSet, aDigits), aToBase, aToCharSet);
    }

    public static int[] toDigits(long aValue, int aToBase) {
        ArrayList<Integer> theDigits = new ArrayList<Integer>();
        while (aValue > 0L) {
            theDigits.add(0, (int)(aValue % (long)aToBase));
            aValue /= (long)aToBase;
        }
        return NumericalUtility.toPrimitiveArray(theDigits);
    }

    public static long fromDigits(int aFromBase, int[] aDigits) {
        long theNumber = 0L;
        for (int eDigit : aDigits) {
            theNumber = (long)aFromBase * theNumber + (long)eDigit;
        }
        return theNumber;
    }

    public static int[] convertDigits(int aFromBase, int[] aDigits, int aToBase) {
        return NumericalUtility.toDigits(NumericalUtility.fromDigits(aFromBase, aDigits), aToBase);
    }

    private static int[] toPrimitiveArray(List<Integer> aValues) {
        int[] theResult = new int[aValues.size()];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = aValues.get(i);
        }
        return theResult;
    }

    private static int toIndex(char aChar, char[] aCharSet) {
        for (int i = 0; i < aCharSet.length; ++i) {
            if (aCharSet[i] != aChar) continue;
            return i;
        }
        throw new IllegalArgumentException("The character <" + aChar + "> is not contained withon the char set <" + Arrays.toString(aCharSet) + ">!");
    }

    public static boolean isBitSetAt(long aValue, int aPosition) {
        return (aValue >> aPosition & 1L) == 1L;
    }

    public static byte setBitAt(byte aValue, int aPos, boolean aBit) {
        return (byte)(aBit ? aValue | 1 << aPos : aValue & ~(1 << aPos));
    }

    public static byte[] toBytes(String aString) {
        return NumericalUtility.toBytes(aString, false);
    }

    public static byte[] toBytes(String aString, boolean isHexString) {
        ArrayList<Byte> theBytes = new ArrayList<Byte>();
        StringBuilder theNormalized = new StringBuilder();
        for (int i = 0; i < aString.length(); ++i) {
            char eChar = aString.charAt(i);
            if (eChar == 'x' || eChar == 'X' || Character.isDigit(eChar) || eChar >= 'a' && eChar <= 'f' || eChar >= 'A' && eChar <= 'F' || eChar == '-') {
                theNormalized.append(eChar);
                continue;
            }
            if (eChar == ',' || eChar == ' ') {
                theNormalized.append(',');
                continue;
            }
            if (eChar == '{' || eChar == '}' || eChar == '[' || eChar == ']' || eChar == '(' || eChar == ')') continue;
            throw new IllegalArgumentException("Invalid character '" + eChar + "' at index <" + i + " of String \"" + aString + "\"!");
        }
        StringTokenizer theTokenizer = new StringTokenizer(theNormalized.toString(), ",", false);
        while (theTokenizer.hasMoreTokens()) {
            int eByte;
            String eToken = theTokenizer.nextToken();
            try {
                if (isHexString || eToken.startsWith("0x") || eToken.startsWith("0X")) {
                    if (eToken.startsWith("0x") || eToken.startsWith("0X")) {
                        eToken = eToken.substring(2);
                    }
                    eByte = Integer.valueOf(eToken, 16);
                } else {
                    eByte = Integer.valueOf(eToken);
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Value \"" + eToken + "\" of string \"" + aString + "\" cannot be parsed: " + e.getMessage());
            }
            if (eByte <= 255 && eByte >= -128) {
                theBytes.add((byte)eByte);
                continue;
            }
            throw new NumberFormatException("The value <" + eByte + "> (\"" + eToken + "\") of text \"" + aString + "\" is out of range (0-255) !");
        }
        byte[] theResult = new byte[theBytes.size()];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = (Byte)theBytes.get(i);
        }
        return theResult;
    }

    public static byte[] toBytes(long aLong) {
        byte[] theBytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            theBytes[7 - i] = (byte)(aLong >>> (int)((long)i * 8L));
        }
        return theBytes;
    }

    public static byte[] toBytes(int aInteger) {
        byte[] theBytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            theBytes[3 - i] = (byte)(aInteger >>> (int)((long)i * 8L));
        }
        return theBytes;
    }

    public static byte[] toBytes(boolean[] aBits) {
        byte[] theBytes = new byte[aBits.length / 8 + (aBits.length % 8 == 0 ? 0 : 1)];
        for (int i = 0; i < theBytes.length; ++i) {
            int index;
            for (int j = 0; j < 8 && (index = i * 8 + j) < aBits.length; ++j) {
                if (!aBits[index]) continue;
                int n = i;
                theBytes[n] = (byte)(theBytes[n] | 128 >> j);
            }
        }
        return theBytes;
    }

    public static boolean[] toBooleans(byte[] aBytes) {
        return NumericalUtility.toBooleans(aBytes, 0, aBytes.length * 8);
    }

    public static boolean[] toBooleans(byte[] aBytes, int aLength) {
        return NumericalUtility.toBooleans(aBytes, 0, aLength);
    }

    public static boolean[] toBooleans(byte[] aBytes, int aOffset, int aLength) {
        boolean[] theBooleans = new boolean[aLength];
        for (int i = 0; i < aLength; ++i) {
            int index;
            for (int j = 0; j < 8 && (index = i * 8 + j) < theBooleans.length && i + aOffset < aBytes.length; ++j) {
                theBooleans[index] = (aBytes[i + aOffset] & (byte)(128.0 / Math.pow(2.0, j))) != 0;
            }
        }
        return theBooleans;
    }

    public static long toLong(byte[] aBytes) {
        return NumericalUtility.toLong(aBytes, 0);
    }

    public static long toLong(byte[] aBytes, int aOffset) {
        long theWord = 0L;
        for (int i = 0; i < 8 && i + aOffset < aBytes.length; ++i) {
            theWord <<= 8;
            if (i >= aBytes.length) continue;
            theWord |= (long)aBytes[i + aOffset] & 0xFFL;
        }
        return theWord;
    }

    public static int toInt(byte[] aBytes) {
        return NumericalUtility.toInt(aBytes, 0);
    }

    public static int toInt(byte[] aBytes, int aOffset) {
        int theWord = 0;
        for (int i = 0; i < 4 && i + aOffset < aBytes.length; ++i) {
            theWord <<= 8;
            if (i >= aBytes.length) continue;
            theWord |= aBytes[i + aOffset] & 0xFF;
        }
        return theWord;
    }

    public static short[] toShorts(byte[] aBytes) {
        if (aBytes != null) {
            short[] theShorts = new short[aBytes.length];
            for (int i = 0; i < aBytes.length; ++i) {
                theShorts[i] = aBytes[i];
            }
            return theShorts;
        }
        return null;
    }

    public static byte[] toBytes(Double aDouble) {
        if (aDouble != null) {
            byte[] theBytes = new byte[8];
            long theLong = Double.doubleToLongBits(aDouble);
            for (int i = 0; i < 8; ++i) {
                theBytes[i] = (byte)(theLong >> (7 - i) * 8 & 0xFFL);
            }
            return theBytes;
        }
        return null;
    }

    public static long toLong(String aString) {
        byte[] theBytes;
        try {
            theBytes = aString.getBytes(Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            theBytes = aString.getBytes();
        }
        long theValue = 0L;
        for (byte theByte : theBytes) {
            theValue = (theValue << 8) + (long)(theByte & 0xFF);
        }
        return theValue;
    }

    public static double toDouble(String aString) {
        long theLong = NumericalUtility.toLong(aString);
        double theDouble = theLong >= 0L ? (double)theLong / 9.223372036854776E18 : 1.0 - (double)theLong / -9.223372036854776E18;
        return theDouble;
    }

    public static double[] toDoubles(String aString, int aCount) {
        if (aCount <= 0) {
            throw new IllegalArgumentException("The provided count <" + aCount + "> must be greatet than one!");
        }
        double[] theResult = new double[aCount];
        String[] theStrings = new String[aCount];
        int step = aString.length() / aCount;
        if (step == 0) {
            step = 1;
        }
        for (int i = 0; i < aCount; ++i) {
            theStrings[i] = "";
            int index = step * i;
            for (int j = 0; j < aString.length(); ++j) {
                if (index >= aString.length()) {
                    index = 0;
                }
                theStrings[i] = theStrings[i] + aString.charAt(index);
                ++index;
            }
            theResult[i] = NumericalUtility.toDouble(theStrings[i]);
        }
        return theResult;
    }

    public static int toHashCode(Object ... aObjects) {
        int thePrime = 31;
        int theResult = 1;
        for (Object eObject : aObjects) {
            theResult = 31 * theResult + (eObject == null ? 0 : eObject.hashCode());
        }
        return theResult;
    }

    public static long toUnsignedLong(int aSignedIntValue) {
        if (aSignedIntValue >= 0) {
            return aSignedIntValue;
        }
        long theSignedValue = aSignedIntValue;
        return theSignedValue & 0xFFFFFFFFL;
    }

    public static byte[] toLittleEndianBytes(long aValue, int aLength) {
        byte[] theResult = NumericalUtility.toBigEndianBytes(aValue, aLength);
        for (int i = 0; i < theResult.length / 2; ++i) {
            byte eTmp = theResult[i];
            theResult[i] = theResult[theResult.length - i - 1];
            theResult[theResult.length - i - 1] = eTmp;
        }
        return theResult;
    }

    public static byte[] toLittleEndianBytes(long aValue) {
        return NumericalUtility.toLittleEndianBytes(aValue, 8);
    }

    public static byte[] toLittleEndianBytes(int aValue) {
        return NumericalUtility.toLittleEndianBytes(aValue, 4);
    }

    public static byte[] toLittleEndianBytes(short aValue) {
        return NumericalUtility.toLittleEndianBytes(aValue, 2);
    }

    public static byte[] toBigEndianBytes(long aValue, int aLength) {
        BigInteger theBigInt = BigInteger.valueOf(aValue);
        byte[] theBytes = theBigInt.toByteArray();
        if (theBytes.length == aLength) {
            return theBytes;
        }
        byte[] theResult = new byte[aLength];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[theResult.length - i - 1] = theBytes.length > i ? theBytes[theBytes.length - i - 1] : (aValue < 0L ? -1 : 0);
        }
        return theResult;
    }

    public static byte[] toBigEndianBytes(long aValue) {
        return NumericalUtility.toBigEndianBytes(aValue, 8);
    }

    public static byte[] toBigEndianBytes(int aValue) {
        return NumericalUtility.toBigEndianBytes(aValue, 4);
    }

    public static byte[] toBigEndianBytes(short aValue) {
        return NumericalUtility.toBigEndianBytes(aValue, 2);
    }

    public static byte[] toUnsignedLittleEndianBytes(long aValue, int aLength) {
        byte[] theResult = new byte[aLength];
        BigInteger theBigInt = BigInteger.valueOf(aValue).and(UNSIGNED_LONG_MASK);
        byte[] theBytes = theBigInt.toByteArray();
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = theBytes.length > i ? theBytes[theBytes.length - 1 - i] : (byte)0;
        }
        return theResult;
    }

    public static byte[] toUnsignedLittleEndianBytes(long aValue) {
        return NumericalUtility.toUnsignedLittleEndianBytes(aValue, 8);
    }

    public static byte[] toUnsignedLittleEndianBytes(int aValue) {
        return NumericalUtility.toUnsignedLittleEndianBytes(aValue, 4);
    }

    public static byte[] toUnsignedLittleEndianBytes(short aValue) {
        return NumericalUtility.toUnsignedLittleEndianBytes(aValue, 2);
    }

    public static byte[] toUnsignedBigEndianBytes(long aValue, int aLength) {
        byte[] theResult = new byte[aLength];
        BigInteger theBigInt = BigInteger.valueOf(aValue).and(UNSIGNED_LONG_MASK);
        byte[] theBytes = theBigInt.toByteArray();
        for (int i = 0; i < theResult.length; ++i) {
            theResult[theResult.length - i - 1] = theBytes.length > i ? theBytes[theBytes.length - i - 1] : (byte)0;
        }
        return theResult;
    }

    public static byte[] toUnsignedBigEndianBytes(long aValue) {
        return NumericalUtility.toUnsignedBigEndianBytes(aValue, 8);
    }

    public static byte[] toUnsignedBigEndianBytes(int aValue) {
        return NumericalUtility.toUnsignedBigEndianBytes(aValue, 4);
    }

    public static byte[] toUnsignedBigEndianBytes(short aValue) {
        return NumericalUtility.toUnsignedBigEndianBytes(aValue, 2);
    }

    public static long toLongFromLittleEndianBytes(byte[] aLittleEndian) {
        byte[] theBigEndian = new byte[aLittleEndian.length];
        for (int i = 0; i < aLittleEndian.length; ++i) {
            theBigEndian[i] = aLittleEndian[aLittleEndian.length - i - 1];
        }
        BigInteger theBigInt = new BigInteger(theBigEndian);
        return theBigInt.longValue();
    }

    public static long toUnsignedLongFromLittleEndianBytes(byte[] aLittleEndian) {
        return NumericalUtility.toLongFromLittleEndianBytes(NumericalUtility.toUnsignedLittleEndianBytes(aLittleEndian));
    }

    public static long toLongFromBigEndianBytes(byte[] aBigEndian) {
        BigInteger theBigInt = new BigInteger(aBigEndian);
        return theBigInt.longValue();
    }

    public static long toUnsignedLongFromBigEndianBytes(byte[] aBigEndian) {
        return NumericalUtility.toLongFromBigEndianBytes(NumericalUtility.toUnsignedBigEndianBytes(aBigEndian));
    }

    public static int toIntFromLittleEndianBytes(byte[] aLittleEndian) {
        byte[] theBigEndian = new byte[aLittleEndian.length];
        for (int i = 0; i < aLittleEndian.length; ++i) {
            theBigEndian[i] = aLittleEndian[aLittleEndian.length - i - 1];
        }
        BigInteger theBigInt = new BigInteger(theBigEndian);
        return theBigInt.intValue();
    }

    public static int toUnsignedIntFromLittleEndianBytes(byte[] aLittleEndian) {
        return NumericalUtility.toIntFromLittleEndianBytes(NumericalUtility.toUnsignedLittleEndianBytes(aLittleEndian));
    }

    public static int toIntFromBigEndianBytes(byte[] aBigEndian) {
        BigInteger theBigInt = new BigInteger(aBigEndian);
        return theBigInt.intValue();
    }

    public static int toUnsignedIntFromBigEndianBytes(byte[] aBigEndian) {
        return NumericalUtility.toIntFromBigEndianBytes(NumericalUtility.toUnsignedBigEndianBytes(aBigEndian));
    }

    public static short toShortFromLittleEndianBytes(byte[] aLittleEndian) {
        byte[] theBigEndian = new byte[aLittleEndian.length];
        for (int i = 0; i < aLittleEndian.length; i = (int)((short)(i + 1))) {
            theBigEndian[i] = aLittleEndian[aLittleEndian.length - i - 1];
        }
        BigInteger theBigInt = new BigInteger(theBigEndian);
        return theBigInt.shortValue();
    }

    public static short toUnsignedShortFromLittleEndianBytes(byte[] aLittleEndian) {
        return NumericalUtility.toShortFromLittleEndianBytes(NumericalUtility.toUnsignedLittleEndianBytes(aLittleEndian));
    }

    public static short toShortFromBigEndianBytes(byte[] aBigEndian) {
        BigInteger theBigInt = new BigInteger(aBigEndian);
        return theBigInt.shortValue();
    }

    public static short toUnsignedShortFromBigEndianBytes(byte[] aBigEndian) {
        return NumericalUtility.toShortFromBigEndianBytes(NumericalUtility.toUnsignedBigEndianBytes(aBigEndian));
    }

    public static byte[] toUnsignedLittleEndianBytes(byte[] aLittleEndian) {
        if (aLittleEndian[aLittleEndian.length - 1] == 0) {
            return aLittleEndian;
        }
        byte[] theLittleEndian = new byte[aLittleEndian.length + 1];
        for (int i = 0; i < aLittleEndian.length; ++i) {
            theLittleEndian[i] = aLittleEndian[i];
        }
        theLittleEndian[theLittleEndian.length - 1] = 0;
        return theLittleEndian;
    }

    public static byte[] toUnsignedBigEndianBytes(byte[] aBigEndian) {
        if (aBigEndian[0] == 0) {
            return aBigEndian;
        }
        byte[] theBigEndian = new byte[aBigEndian.length + 1];
        for (int i = 0; i < aBigEndian.length; ++i) {
            theBigEndian[i + 1] = aBigEndian[i];
        }
        theBigEndian[0] = 0;
        return theBigEndian;
    }

    public static float toFloatFromBigEndianBytes(byte[] aBigEndian) {
        return ByteBuffer.wrap(aBigEndian).getFloat();
    }

    public static float toFloatFromLittleEndianBytes(byte[] aLittleEndian) {
        byte[] theBigEndian = new byte[aLittleEndian.length];
        for (int i = 0; i < aLittleEndian.length; ++i) {
            theBigEndian[i] = aLittleEndian[aLittleEndian.length - i - 1];
        }
        return ByteBuffer.wrap(theBigEndian).getFloat();
    }

    public static byte[] toBigEndianBytes(float aValue) {
        byte[] theBytes = new byte[4];
        ByteBuffer.wrap(theBytes).putFloat(aValue);
        return theBytes;
    }

    public static byte[] toLittleEndianBytes(float aValue) {
        byte[] theBytes = new byte[4];
        ByteBuffer.wrap(theBytes).putFloat(aValue);
        byte[] theResult = new byte[theBytes.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = theBytes.length > i ? theBytes[theBytes.length - 1 - i] : (byte)0;
        }
        return theResult;
    }

    public static double toDoubleFromBigEndianBytes(byte[] aBigEndian) {
        return ByteBuffer.wrap(aBigEndian).getDouble();
    }

    public static double toDoubleFromLittleEndianBytes(byte[] aLittleEndian) {
        byte[] theBigEndian = new byte[aLittleEndian.length];
        for (int i = 0; i < aLittleEndian.length; ++i) {
            theBigEndian[i] = aLittleEndian[aLittleEndian.length - i - 1];
        }
        return ByteBuffer.wrap(theBigEndian).getDouble();
    }

    public static byte[] toBigEndianBytes(double aValue) {
        byte[] theBytes = new byte[8];
        ByteBuffer.wrap(theBytes).putDouble(aValue);
        return theBytes;
    }

    public static byte[] toLittleEndianBytes(double aValue) {
        byte[] theBytes = new byte[8];
        ByteBuffer.wrap(theBytes).putDouble(aValue);
        byte[] theResult = new byte[theBytes.length];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = theBytes.length > i ? theBytes[theBytes.length - 1 - i] : (byte)0;
        }
        return theResult;
    }

    public static String toHexString(byte ... aBytes) {
        return NumericalUtility.toHexString(true, aBytes);
    }

    public static String toHexString(boolean isPrefixBytes, byte ... aBytes) {
        StringBuilder theBuffer = new StringBuilder();
        for (byte aByte : aBytes) {
            theBuffer.append(NumericalUtility.toHexString(aByte, isPrefixBytes));
        }
        return theBuffer.toString();
    }

    public static String toHexString(int aBytesPerLine, byte ... aBytes) {
        return NumericalUtility.toHexString(aBytesPerLine, true, aBytes);
    }

    public static String toHexString(int aBytesPerLine, boolean isPrefixBytes, byte ... aBytes) {
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aBytes.length; ++i) {
            boolean hasLineFeed;
            theBuffer.append(NumericalUtility.toHexString(aBytes[i], isPrefixBytes));
            boolean bl = hasLineFeed = (i + 1) % aBytesPerLine == 0 && i != aBytes.length - 1;
            if (!hasLineFeed) continue;
            theBuffer.append(System.lineSeparator());
        }
        return theBuffer.toString();
    }

    public static String toHexString(String aByteSeparator, byte ... aBytes) {
        return NumericalUtility.toHexString(aByteSeparator, true, aBytes);
    }

    public static String toHexString(String aByteSeparator, boolean isPrefixBytes, byte ... aBytes) {
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aBytes.length; ++i) {
            theBuffer.append(NumericalUtility.toHexString(isPrefixBytes, aBytes[i]));
            if (aByteSeparator == null || i >= aBytes.length - 1) continue;
            theBuffer.append(aByteSeparator);
        }
        return theBuffer.toString();
    }

    public static String toHexString(String aByteSeparator, int aBytesPerLine, byte ... aBytes) {
        return NumericalUtility.toHexString(aByteSeparator, aBytesPerLine, true, aBytes);
    }

    public static String toHexString(String aByteSeparator, int aBytesPerLine, boolean isPrefixBytes, byte ... aBytes) {
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aBytes.length; ++i) {
            boolean hasLineFeed;
            theBuffer.append(NumericalUtility.toHexString(isPrefixBytes, aBytes[i]));
            boolean bl = hasLineFeed = (i + 1) % aBytesPerLine == 0 && i != aBytes.length - 1;
            if (i < aBytes.length - 1 && !hasLineFeed) {
                theBuffer.append(aByteSeparator);
            }
            if (!hasLineFeed) continue;
            theBuffer.append(System.lineSeparator());
        }
        return theBuffer.toString();
    }

    public static String toHexString(byte[] aBytes, String aByteSeparator) {
        return NumericalUtility.toHexString(aBytes, aByteSeparator, true);
    }

    public static String toHexString(byte[] aBytes, String aByteSeparator, boolean isPrefixBytes) {
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aBytes.length; ++i) {
            theBuffer.append(NumericalUtility.toHexString(isPrefixBytes, aBytes[i]));
            if (aByteSeparator == null || i >= aBytes.length - 1) continue;
            theBuffer.append(aByteSeparator);
        }
        return theBuffer.toString();
    }

    public static String toHexString(byte[] aBytes, int aBytesPerLine) {
        return NumericalUtility.toHexString(aBytes, aBytesPerLine, true);
    }

    public static String toHexString(byte[] aBytes, int aBytesPerLine, boolean isPrefixBytes) {
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aBytes.length; ++i) {
            boolean hasLineFeed;
            theBuffer.append(NumericalUtility.toHexString(isPrefixBytes, aBytes[i]));
            boolean bl = hasLineFeed = (i + 1) % aBytesPerLine == 0 && i != aBytes.length - 1;
            if (!hasLineFeed) continue;
            theBuffer.append(System.lineSeparator());
        }
        return theBuffer.toString();
    }

    public static String toHexString(byte[] aBytes, String aByteSeparator, int aBytesPerLine) {
        return NumericalUtility.toHexString(aBytes, aByteSeparator, aBytesPerLine, true);
    }

    public static String toHexString(byte[] aBytes, String aByteSeparator, int aBytesPerLine, boolean isPrefixBytes) {
        StringBuilder theBuffer = new StringBuilder();
        for (int i = 0; i < aBytes.length; ++i) {
            boolean hasLineFeed;
            theBuffer.append(NumericalUtility.toHexString(isPrefixBytes, aBytes[i]));
            boolean bl = hasLineFeed = (i + 1) % aBytesPerLine == 0 && i != aBytes.length - 1;
            if (i < aBytes.length - 1 && !hasLineFeed) {
                theBuffer.append(aByteSeparator);
            }
            if (!hasLineFeed) continue;
            theBuffer.append(System.lineSeparator());
        }
        return theBuffer.toString();
    }

    public static String toHexString(int aByte) {
        return NumericalUtility.toHexString((byte)aByte, true);
    }

    public static String toHexString(int aByte, boolean isPrefixByte) {
        return NumericalUtility.toHexString((byte)aByte, isPrefixByte);
    }

    public static String toHexString(byte aByte) {
        return NumericalUtility.toHexString(aByte, true);
    }

    public static String toHexString(byte aByte, boolean isPrefixByte) {
        StringBuilder theBuffer = new StringBuilder();
        if (isPrefixByte) {
            theBuffer.append("0x");
        }
        theBuffer.append(Character.forDigit(aByte >> 4 & 0xF, 16));
        theBuffer.append(Character.forDigit(aByte & 0xF, 16));
        return theBuffer.toString();
    }

    public static boolean toBoolean(String aValue) {
        for (String eTrue : BooleanLiterals.TRUE.getNames()) {
            if (!eTrue.equalsIgnoreCase(aValue)) continue;
            return true;
        }
        for (String eFalse : BooleanLiterals.FALSE.getNames()) {
            if (!eFalse.equalsIgnoreCase(aValue)) continue;
            return false;
        }
        throw new IllegalArgumentException("Unable to determine neither <true> nor <false> for the provided string \"" + aValue + "\".");
    }

    static long toReversedLong(long aValue) {
        long theResult = 0L;
        for (int i = 63; i >= 0; --i) {
            theResult |= (aValue & 1L) << i;
            aValue >>= 1;
        }
        return theResult;
    }

    static long toReversedLong(long aValue, int aLength) {
        long theResult = 0L;
        for (int i = aLength - 1; i >= 0; --i) {
            theResult |= (aValue & 1L) << i;
            aValue >>= 1;
        }
        return theResult;
    }

    static int toReversedInt(int aValue) {
        int theResult = 0;
        for (int i = 31; i >= 0; --i) {
            theResult |= (aValue & 1) << i;
            aValue >>= 1;
        }
        return theResult;
    }

    static int toReversedInt(int aValue, int aLength) {
        int theResult = 0;
        for (int i = aLength - 1; i >= 0; --i) {
            theResult |= (aValue & 1) << i;
            aValue >>= 1;
        }
        return theResult;
    }

    public static String toMd5Hash(String aText) throws NoSuchAlgorithmException {
        byte[] theBytes = aText.getBytes();
        MessageDigest theMessageDigest = MessageDigest.getInstance(Encoding.MD5.getCode());
        theMessageDigest.update(theBytes, 0, theBytes.length);
        String theHash = new BigInteger(1, theMessageDigest.digest()).toString(32);
        return theHash;
    }

    public static double toScaled(double aValue, double aMin, double aMax) {
        if (aValue < 0.0 || aValue > 1.0) {
            throw new IllegalArgumentException("The provided value <" + aValue + "> must be between 0 and 1!");
        }
        double theRange = aMax - aMin;
        double theScaled = aValue * theRange;
        double theShifted = theScaled + aMin;
        return theShifted;
    }

    public static int sum(int ... aSummands) {
        int theSum = 0;
        for (int eSummand : aSummands) {
            theSum += eSummand;
        }
        return theSum;
    }

    public static double toDouble(int aIntValue, double aMinDouble, double aMaxDouble) {
        double theRange = aMaxDouble - aMinDouble;
        long theUnsignedInt = Integer.toUnsignedLong(aIntValue);
        long theUnsignedIntMax = 0xFFFFFFFFL;
        double theDoubleValue = (double)theUnsignedInt / 4.294967295E9 * theRange;
        return theDoubleValue + aMinDouble;
    }

    public static double toDouble(long aLongValue, double aMinDouble, double aMaxDouble) {
        BigDecimal theRange = BigDecimal.valueOf(aMaxDouble).subtract(BigDecimal.valueOf(aMinDouble));
        BigDecimal theUnsignedLong = BigDecimal.valueOf(aLongValue);
        theUnsignedLong = theUnsignedLong.add(BigDecimal.valueOf(Long.MAX_VALUE)).add(BigDecimal.ONE);
        BigDecimal theUnsignedLongMax = BigDecimal.valueOf(Long.MIN_VALUE).abs().add(BigDecimal.valueOf(Long.MAX_VALUE));
        BigDecimal theDivide = theUnsignedLong.divide(theUnsignedLongMax, 16, RoundingMode.HALF_DOWN);
        BigDecimal theDoubleValue = theDivide.multiply(theRange);
        return theDoubleValue.add(BigDecimal.valueOf(aMinDouble)).doubleValue();
    }

    public static int toHashCode(String aValue) {
        byte[] theBytes;
        int theHash = 0;
        for (byte theByte : theBytes = aValue.getBytes()) {
            theHash = 31 * theHash + theByte;
        }
        return theHash;
    }

    public static int[] toHashCodes(String aSource, int aCount) {
        StringBuilder[] theBuilders = new StringBuilder[aCount];
        for (int i = 0; i < theBuilders.length; ++i) {
            theBuilders[i] = new StringBuilder();
        }
        int theSegmentSize = aSource.length() / aCount + aCount;
        for (int i = 0; i < theSegmentSize; ++i) {
            for (int j = 0; j < theBuilders.length; ++j) {
                int ePos = (j * theSegmentSize + i) % aSource.length();
                theBuilders[j].append(aSource.charAt(ePos));
            }
        }
        int[] theResult = new int[aCount];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = NumericalUtility.toHashCode(theBuilders[i].toString());
        }
        return theResult;
    }

    public static int[] toHashCodes(char[] aSource, int aCount) {
        StringBuilder[] theBuilders = new StringBuilder[aCount];
        for (int i = 0; i < theBuilders.length; ++i) {
            theBuilders[i] = new StringBuilder();
        }
        int theSegmentSize = aSource.length / aCount + aCount;
        for (int i = 0; i < theSegmentSize; ++i) {
            for (int j = 0; j < theBuilders.length; ++j) {
                int ePos = (j * theSegmentSize + i) % aSource.length;
                theBuilders[j].append(aSource[ePos]);
            }
        }
        int[] theResult = new int[aCount];
        for (int i = 0; i < theResult.length; ++i) {
            theResult[i] = NumericalUtility.toHashCode(theBuilders[i].toString());
        }
        return theResult;
    }
}

