/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger.alt.slf4j;

import java.text.MessageFormat;
import org.refcodes.logger.DefaultRuntimeLogger;
import org.refcodes.logger.LogPriority;
import org.refcodes.logger.LogPriorityAccessor;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerAccessor;
import org.refcodes.logger.RuntimeLoggerSingleton;
import org.refcodes.logger.alt.slf4j.Slf4jLogger;
import org.refcodes.logger.alt.slf4j.Slf4jRuntimeLoggerFactory;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.runtime.Execution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4jRuntimeLogger
implements RuntimeLogger,
NameAccessor.NameProperty,
LogPriorityAccessor.LogPriorityProperty {
    private transient Logger _logger = null;
    private transient RuntimeLogger _runtimeLogger = null;

    public Slf4jRuntimeLogger() {
        StackTraceElement theCaller = Execution.probeTillNoneLoggerElement(Slf4jRuntimeLoggerFactory.class, DefaultRuntimeLogger.class, RuntimeLogger.class, RuntimeLoggerSingleton.class, Slf4jLogger.class);
        String theClassName = theCaller.getClassName();
        this.setName(theClassName);
    }

    public Slf4jRuntimeLogger(Logger aLogger) {
        this.toRuntimeLogger(aLogger);
    }

    @Override
    public void log(LogPriority aPriority, String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log(aPriority, aMessage);
        } else {
            switch (aPriority) {
                case PANIC: {
                    this._logger.error(aMessage);
                    break;
                }
                case ALERT: {
                    this._logger.error(aMessage);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(aMessage);
                    break;
                }
                case ERROR: {
                    this._logger.error(aMessage);
                    break;
                }
                case WARN: {
                    this._logger.warn(aMessage);
                    break;
                }
                case NOTICE: {
                    this._logger.info(aMessage);
                    break;
                }
                case INFO: {
                    this._logger.info(aMessage);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(aMessage);
                    break;
                }
                case TRACE: {
                    this._logger.trace(aMessage);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    this._logger.info(aMessage);
                    break;
                }
                default: {
                    this._logger.info(aMessage);
                }
            }
        }
    }

    @Override
    public void log(LogPriority aPriority, String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log(aPriority, aMessage, aArguments);
        } else {
            switch (aPriority) {
                case PANIC: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case ALERT: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case ERROR: {
                    this._logger.error(aMessage, aArguments);
                    break;
                }
                case WARN: {
                    this._logger.warn(aMessage, aArguments);
                    break;
                }
                case NOTICE: {
                    this._logger.info(aMessage, aArguments);
                    break;
                }
                case INFO: {
                    this._logger.info(aMessage, aArguments);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(aMessage, aArguments);
                    break;
                }
                case TRACE: {
                    this._logger.trace(aMessage, aArguments);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    this._logger.info(aMessage, aArguments);
                    break;
                }
                default: {
                    this._logger.info(aMessage, aArguments);
                }
            }
        }
    }

    @Override
    public String getName() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.getName();
        }
        return this._logger.getName();
    }

    @Override
    public void setName(String aName) {
        Logger aLogger = LoggerFactory.getLogger(aName);
        this.toRuntimeLogger(aLogger);
    }

    @Override
    public LogPriority getLogPriority() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.getLogPriority();
        }
        if (this._logger.isDebugEnabled()) {
            return LogPriority.DEBUG;
        }
        if (this._logger.isErrorEnabled()) {
            return LogPriority.ERROR;
        }
        if (this._logger.isInfoEnabled()) {
            return LogPriority.INFO;
        }
        if (this._logger.isTraceEnabled()) {
            return LogPriority.TRACE;
        }
        return this._logger.isWarnEnabled() ? LogPriority.WARN : LogPriority.NONE;
    }

    @Override
    public void setLogPriority(LogPriority aLogPriority) {
        Execution.setJulLoggingLevel(aLogPriority.toLevel());
    }

    @Override
    public void log(LogPriority aPriority, String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log(aPriority, aMessage, aThrowable);
        } else {
            switch (aPriority) {
                case PANIC: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case ALERT: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case CRITICAL: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case ERROR: {
                    this._logger.error(aMessage, aThrowable);
                    break;
                }
                case WARN: {
                    this._logger.warn(aMessage, aThrowable);
                    break;
                }
                case NOTICE: {
                    this._logger.info(aMessage, aThrowable);
                    break;
                }
                case INFO: {
                    this._logger.info(aMessage, aThrowable);
                    break;
                }
                case DEBUG: {
                    this._logger.debug(aMessage, aThrowable);
                    break;
                }
                case TRACE: {
                    this._logger.trace(aMessage, aThrowable);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    this._logger.info(aMessage, aThrowable);
                    break;
                }
                default: {
                    this._logger.info(aMessage, aThrowable);
                }
            }
        }
    }

    @Override
    public void log(LogPriority aPriority, String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.log(aPriority, aMessage, aThrowable, aArguments);
        } else {
            switch (aPriority) {
                case PANIC: {
                    if (!this._logger.isErrorEnabled()) break;
                    this.logError(aMessage, aThrowable, aArguments);
                    break;
                }
                case ALERT: {
                    if (!this._logger.isErrorEnabled()) break;
                    this.logError(aMessage, aThrowable, aArguments);
                    break;
                }
                case CRITICAL: {
                    if (!this._logger.isErrorEnabled()) break;
                    this.logError(aMessage, aThrowable, aArguments);
                    break;
                }
                case ERROR: {
                    if (!this._logger.isErrorEnabled()) break;
                    this.logError(aMessage, aThrowable, aArguments);
                    break;
                }
                case WARN: {
                    if (!this._logger.isWarnEnabled()) break;
                    this.logWarn(aMessage, aThrowable, aArguments);
                    break;
                }
                case NOTICE: {
                    if (!this._logger.isInfoEnabled()) break;
                    this.logInfo(aMessage, aThrowable, aArguments);
                    break;
                }
                case INFO: {
                    if (!this._logger.isInfoEnabled()) break;
                    this.logInfo(aMessage, aThrowable, aArguments);
                    break;
                }
                case DEBUG: {
                    if (!this._logger.isDebugEnabled()) break;
                    this.logDebug(aMessage, aThrowable, aArguments);
                    break;
                }
                case TRACE: {
                    if (!this._logger.isTraceEnabled()) break;
                    this.logTrace(aMessage, aThrowable, aArguments);
                    break;
                }
                case DISCARD: {
                    break;
                }
                case NONE: {
                    if (!this._logger.isInfoEnabled()) break;
                    this.logInfo(aMessage, aThrowable, aArguments);
                    break;
                }
                default: {
                    if (!this._logger.isInfoEnabled()) break;
                    this.logInfo(aMessage, aThrowable, aArguments);
                }
            }
        }
    }

    @Override
    public boolean isLog(LogPriority aPriority) {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLog(aPriority);
        }
        return aPriority.getPriority() >= this.getLogPriority().getPriority() && aPriority.getPriority() >= 0;
    }

    @Override
    public void trace(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.trace(aMessage);
        } else {
            this._logger.trace(aMessage);
        }
    }

    @Override
    public void trace(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.trace(aMessage, aArguments);
        } else {
            this._logger.trace(aMessage, aArguments);
        }
    }

    @Override
    public boolean isLogTrace() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogTrace();
        }
        return this.isLog(LogPriority.TRACE);
    }

    @Override
    public void debug(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.debug(aMessage);
        } else {
            this._logger.debug(aMessage);
        }
    }

    @Override
    public void debug(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.debug(aMessage, aArguments);
        } else {
            this._logger.debug(aMessage, aArguments);
        }
    }

    @Override
    public boolean isLogDebug() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogDebug();
        }
        return this.isLog(LogPriority.DEBUG);
    }

    @Override
    public void info(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.info(aMessage);
        } else {
            this._logger.info(aMessage);
        }
    }

    @Override
    public void info(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.info(aMessage, aArguments);
        } else {
            this._logger.info(aMessage, aArguments);
        }
    }

    @Override
    public boolean isLogInfo() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogInfo();
        }
        return this.isLog(LogPriority.INFO);
    }

    @Override
    public void notice(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.notice(aMessage);
        } else {
            this._logger.info(aMessage);
        }
    }

    @Override
    public void notice(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.notice(aMessage, aArguments);
        } else {
            this._logger.info(aMessage, aArguments);
        }
    }

    @Override
    public boolean isLogNotice() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogNotice();
        }
        return this.isLog(LogPriority.NOTICE);
    }

    @Override
    public void warn(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage);
        } else {
            this._logger.warn(aMessage);
        }
    }

    @Override
    public void warn(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage, aArguments);
        } else {
            this._logger.warn(aMessage, aArguments);
        }
    }

    @Override
    public void warn(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage, aThrowable);
        } else {
            this._logger.warn(aMessage, aThrowable);
        }
    }

    @Override
    public void warn(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.warn(aMessage, aArguments);
        } else {
            this.logWarn(aMessage, aThrowable, aArguments);
        }
    }

    @Override
    public boolean isLogWarn() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogWarn();
        }
        return this.isLog(LogPriority.WARN);
    }

    @Override
    public void error(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    @Override
    public void error(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    @Override
    public void error(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    @Override
    public void error(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.error(aMessage, aThrowable, aArguments);
        } else {
            this.logError(aMessage, aThrowable, aArguments);
        }
    }

    @Override
    public boolean isLogError() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogError();
        }
        return this.isLog(LogPriority.ERROR);
    }

    @Override
    public void critical(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    @Override
    public void critical(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    @Override
    public void critical(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    @Override
    public void critical(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.critical(aMessage, aThrowable, aArguments);
        } else {
            this.logError(aMessage, aThrowable, aArguments);
        }
    }

    @Override
    public boolean isLogCritical() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogCritical();
        }
        return this.isLog(LogPriority.CRITICAL);
    }

    @Override
    public void alert(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    @Override
    public void alert(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    @Override
    public void alert(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    @Override
    public void alert(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.alert(aMessage, aThrowable, aArguments);
        } else {
            this.logError(aMessage, aThrowable, aArguments);
        }
    }

    @Override
    public boolean isLogAlert() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogAlert();
        }
        return this.isLog(LogPriority.ALERT);
    }

    @Override
    public void panic(String aMessage) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage);
        } else {
            this._logger.error(aMessage);
        }
    }

    @Override
    public void panic(String aMessage, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage, aArguments);
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    @Override
    public void panic(String aMessage, Throwable aThrowable) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage, aThrowable);
        } else {
            this._logger.error(aMessage, aThrowable);
        }
    }

    @Override
    public void panic(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (this._runtimeLogger != null) {
            this._runtimeLogger.panic(aMessage, aThrowable, aArguments);
        } else {
            this.logError(aMessage, aThrowable, aArguments);
        }
    }

    @Override
    public boolean isLogPanic() {
        if (this._runtimeLogger != null) {
            return this._runtimeLogger.isLogPanic();
        }
        return this.isLog(LogPriority.PANIC);
    }

    private void logError(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (aThrowable != null) {
            if (this.isNullArray(aArguments)) {
                this._logger.error(aMessage, aThrowable);
            } else {
                this._logger.error(MessageFormat.format(aMessage, aArguments), aThrowable);
            }
        } else {
            this._logger.error(aMessage, aArguments);
        }
    }

    private void logWarn(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (aThrowable != null) {
            if (this.isNullArray(aArguments)) {
                this._logger.warn(aMessage, aThrowable);
            } else {
                this._logger.warn(MessageFormat.format(aMessage, aArguments), aThrowable);
            }
        } else {
            this._logger.warn(aMessage, aArguments);
        }
    }

    private void logInfo(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (aThrowable != null) {
            if (this.isNullArray(aArguments)) {
                this._logger.info(aMessage, aThrowable);
            } else {
                this._logger.info(MessageFormat.format(aMessage, aArguments), aThrowable);
            }
        } else {
            this._logger.info(aMessage, aArguments);
        }
    }

    private void logDebug(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (aThrowable != null) {
            if (this.isNullArray(aArguments)) {
                this._logger.debug(aMessage, aThrowable);
            } else {
                this._logger.debug(MessageFormat.format(aMessage, aArguments), aThrowable);
            }
        } else {
            this._logger.debug(aMessage, aArguments);
        }
    }

    private void logTrace(String aMessage, Throwable aThrowable, Object ... aArguments) {
        if (aThrowable != null) {
            if (this.isNullArray(aArguments)) {
                this._logger.trace(aMessage, aThrowable);
            } else {
                this._logger.trace(MessageFormat.format(aMessage, aArguments), aThrowable);
            }
        } else {
            this._logger.trace(aMessage, aArguments);
        }
    }

    private void toRuntimeLogger(Logger aLogger) {
        if (aLogger instanceof RuntimeLoggerAccessor && ((RuntimeLoggerAccessor)((Object)aLogger)).getRuntimeLogger() != null) {
            this._runtimeLogger = ((RuntimeLoggerAccessor)((Object)aLogger)).getRuntimeLogger();
        } else {
            this._logger = aLogger;
        }
    }

    private boolean isNullArray(Object[] aArray) {
        if (aArray == null || aArray.length == 0) {
            return true;
        }
        for (Object e : aArray) {
            if (e == null) continue;
            return false;
        }
        return true;
    }
}

