/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.logger;

import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.criteria.BadCriteriaException;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.CriteriaUtility;
import org.refcodes.logger.AbstractPartedQueryLogger;
import org.refcodes.logger.LoggerFactory;
import org.refcodes.logger.LoggerUtility;
import org.refcodes.logger.TrimLogger;
import org.refcodes.tabular.Column;

abstract class AbstractPartedTrimLogger<L extends TrimLogger<T>, T, P extends T>
extends AbstractPartedQueryLogger<L, T, P>
implements TrimLogger<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractPartedTrimLogger.class.getName());

    public AbstractPartedTrimLogger(Column<P> aPartitionColumn, LoggerFactory<L> aLoggerFactory, boolean isPartitionAutoInitialize) {
        super(aPartitionColumn, aLoggerFactory, isPartitionAutoInitialize);
    }

    public AbstractPartedTrimLogger(Column<P> aPartitionColumn, String aDefaultLoggerName, LoggerFactory<L> aLoggerFactory, boolean isPartitionAutoInitialize) {
        super(aPartitionColumn, aDefaultLoggerName, aLoggerFactory, isPartitionAutoInitialize);
    }

    @Override
    public void deleteLogs(Criteria aCriteria) throws BadCriteriaException {
        Set thePartitions = CriteriaUtility.getPartitions(aCriteria, (String)this.getPartitionColumn().getKey(), this.getPartitionColumn().getType());
        if (thePartitions.size() == 1) {
            Object ePartition = thePartitions.iterator().next();
            TrimLogger theLogger = (TrimLogger)this.getPartitionLogger(ePartition);
            if (theLogger != null) {
                aCriteria = CriteriaUtility.doRemovePartitionCriteria(aCriteria, (String)this.getPartitionColumn().getKey(), thePartitions);
                theLogger.deleteLogs(aCriteria);
                return;
            }
            LOGGER.log(Level.WARNING, "No logger found for partition \"" + this.getPartitionUid(ePartition) + "\": Now querying all partitions (fallback)!");
        } else if (thePartitions.size() == 0 && this.getFallbackLogger() != null) {
            LOGGER.log(Level.FINE, "No partition found for provided criteria, now deleting logs from default logger!");
            ((TrimLogger)this.getFallbackLogger()).deleteLogs(aCriteria);
            return;
        }
        Collection theLoggers = this.getPartitionLoggers(thePartitions);
        LoggerUtility.deleteLogs(aCriteria, theLoggers);
    }

    @Override
    public void clear() {
        LoggerUtility.clearLogs(this.getLoggers());
    }
}

